/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.utils;

import com.talkilla.utils.MathUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    static Logger logger;
    public static final String PATTERN_DATE_1 = "yyyy-MM-dd";
    public static final String PARTTERN_1 = "yyyy-MM-dd HH:mm:ss";
    public static final String PARTTERN_2 = "yyyy-MM-dd HH:mm";
    public static final String PARTTERN_3 = "yyyy/MM/dd HH:mm";
    public static final String PARTTERN_4 = "yyyyMMddHHmmss";
    public static final String PARTTERN_5 = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String PATTERN_DATE_3 = "MM\u6708dd\u65e5";
    public static final String PATTERN_MONTH_1 = "yyyy-MM";
    public static final String PATTERN_WEEK_1 = "yyyy-ww";
    private static final Date originDate;
    private static char[] currentTimeFlow;
    public static String[] weeks;
    public static final SimpleDateFormat FMT_YMD;
    public static List<String[]> hours;
    public static List<String[]> minuts;

    public static Integer getNowSeconds() {
        return Integer.valueOf(System.currentTimeMillis() / 1000L + "");
    }

    public static String formatDateToSecond(Date date) {
        return new SimpleDateFormat(PARTTERN_1).format(date);
    }

    public static String formatDateToSecond2(Date date) {
        return new SimpleDateFormat(PARTTERN_4).format(date);
    }

    public static String formatDateToMinute(Date date) {
        return new SimpleDateFormat(PARTTERN_2).format(date);
    }

    public static String formatDateToMinuteByTimeZone(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX:00", Locale.ENGLISH).format(date);
    }

    public static String formatDateToDay(Date date) {
        return new SimpleDateFormat(PATTERN_DATE_1).format(date);
    }

    public static String formatDateToDay2(Date date) {
        return new SimpleDateFormat("yyyyMMdd").format(date);
    }

    public static String formatByJsDate(Date date) {
        return new SimpleDateFormat(PARTTERN_3).format(date);
    }

    public static String formatDateToHHmm(Date date) {
        return new SimpleDateFormat("HH:mm").format(date);
    }

    public static String formatDateToHHmmss(Date date) {
        return new SimpleDateFormat("HH:mm:ss").format(date);
    }

    public static String formatDateToyyyyMM(Date date) {
        return new SimpleDateFormat(PATTERN_MONTH_1).format(date);
    }

    public static String formatDateToMonth(Date date) {
        return new SimpleDateFormat(PATTERN_MONTH_1).format(date);
    }

    public static Date parseByMonth(String date) throws ParseException {
        return new SimpleDateFormat(PATTERN_MONTH_1).parse(date);
    }

    public static Date parseDateToSecond(String date) throws ParseException {
        return new SimpleDateFormat(PARTTERN_1).parse(date);
    }

    public static Date parseDateToDay(String date) throws ParseException {
        return new SimpleDateFormat(PATTERN_DATE_1).parse(date);
    }

    public static Date parseDateToMinute(String date) throws ParseException {
        return new SimpleDateFormat(PARTTERN_2).parse(date);
    }

    public static Date parseByJsDate(String date) throws ParseException {
        return new SimpleDateFormat(PARTTERN_3).parse(date);
    }

    public static String getWeekOfDate(Date date) {
        int w;
        String[] weekOfDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if ((w = calendar.get(7) - 1) < 0) {
            w = 0;
        }
        return weekOfDays[w];
    }

    public static Integer getWeekNumberOfDate(Date date) {
        int w;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if ((w = calendar.get(7) - 1) < 0) {
            w = 0;
        }
        return w;
    }

    public static Integer getHourOfDate(Date date) {
        int w;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if ((w = calendar.get(11)) < 0) {
            w = 0;
        }
        return w;
    }

    public static Integer getMinuterOfDate(Date date) {
        int w;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if ((w = calendar.get(12)) < 0) {
            w = 0;
        }
        return w;
    }

    public static String getChineseWeekNumberOfDate(Date date) {
        int w;
        String[] weekOfDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if ((w = calendar.get(7) - 1) < 0) {
            w = 0;
        }
        return weekOfDays[w];
    }

    public static Integer getWeekNumberFromOneOfDate(Date date) {
        int w;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if ((w = calendar.get(7)) < 0) {
            w = 0;
        }
        return w;
    }

    public static String getEnglishWeekNumberOfDate(Date date) {
        int w;
        String[] weekOfDays = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if ((w = calendar.get(7) - 1) < 0) {
            w = 0;
        }
        return weekOfDays[w];
    }

    public static String getHHmmString(Date date, Integer minutes) {
        StringBuffer sb = new StringBuffer();
        sb.append(DateUtils.formatDateToHHmm(date)).append("-");
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(date);
        endDate.add(12, minutes);
        sb.append(DateUtils.formatDateToHHmm(endDate.getTime()));
        return sb.toString();
    }

    public static Date getDateToAddDays(Date date, Integer days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(10, 24 * days);
        return new Date(calendar.getTimeInMillis());
    }

    public static boolean isWorkday(Date date) {
        int w;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if ((w = calendar.get(7) - 1) < 0) {
            w = 0;
        }
        return w > 0 && w < 6;
    }

    public static Date getEndDayTime(Date date, Integer days) throws ParseException {
        String dateStr = DateUtils.formatDateToDay(date);
        date = DateUtils.parseDateToDay(dateStr);
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(date);
        endDate.add(6, days - 1);
        endDate.add(10, 23);
        endDate.add(12, 59);
        return new Date(endDate.getTimeInMillis());
    }

    public static Timestamp getTodayBeginWorkTime() throws ParseException {
        String dateStr = DateUtils.formatDateToDay(new Date());
        Date date = DateUtils.parseDateToDay(dateStr);
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(date);
        endDate.add(10, 9);
        return new Timestamp(endDate.getTimeInMillis());
    }

    public static Timestamp getDateBeginWorkTime(Date date) throws ParseException {
        String dateStr = DateUtils.formatDateToDay(date);
        date = DateUtils.parseDateToDay(dateStr);
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(date);
        endDate.add(10, 9);
        return new Timestamp(endDate.getTimeInMillis());
    }

    public static Date getDateEndWorkTime(Date date) throws ParseException {
        String dateStr = DateUtils.formatDateToDay(date);
        date = DateUtils.parseDateToDay(dateStr);
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(date);
        endDate.add(10, 21);
        return new Date(endDate.getTimeInMillis());
    }

    public static long getTodayBeginTimes() throws ParseException {
        return DateUtils.parseDateToDay(DateUtils.formatDateToDay(new Date())).getTime();
    }

    public static Date getTodayBeginDate() throws ParseException {
        return DateUtils.parseDateToDay(DateUtils.formatDateToDay(new Date()));
    }

    public static List<Long> getWorkTimeListTimes(int days) throws ParseException {
        ArrayList<Long> list = new ArrayList<Long>();
        Timestamp dateBeginWorkTime = DateUtils.getTodayBeginWorkTime();
        Timestamp dayBegin = DateUtils.getDateBeginWorkTime(dateBeginWorkTime);
        for (int i = 0; i < days; ++i) {
            Long times = ((Date)dayBegin).getTime() + 86400000L * (long)i;
            for (int j = 0; j < 48; ++j) {
                Long tempTimes = times + 1800000L * (long)j;
                list.add(tempTimes);
            }
        }
        return list;
    }

    public static Date getTodayEnd() throws ParseException {
        String dateStr = DateUtils.formatDateToDay(new Date());
        Date date = DateUtils.parseDateToDay(dateStr);
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(date);
        endDate.set(11, 23);
        endDate.set(12, 59);
        endDate.set(13, 59);
        return new Date(endDate.getTimeInMillis());
    }

    public static Date getDateEnd(Date thisdate) throws ParseException {
        String dateStr = DateUtils.formatDateToDay(thisdate);
        Date date = DateUtils.parseDateToDay(dateStr);
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(date);
        endDate.set(11, 23);
        endDate.set(12, 59);
        endDate.set(13, 59);
        return new Date(endDate.getTimeInMillis());
    }

    public static Date getDateBegin(Date dates) {
        String dateStr = DateUtils.formatDateToDay(dates);
        try {
            return DateUtils.parseDateToDay(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getDateHours(Date dates) {
        Calendar endDate = Calendar.getInstance(Locale.CHINA);
        endDate.setTime(dates);
        return endDate.get(11);
    }

    public static int getDateMinutes(Date dates) {
        Calendar endDate = Calendar.getInstance(Locale.CHINA);
        endDate.setTime(dates);
        return endDate.get(12);
    }

    public static String formatDate(Date time, String parttern) {
        return new SimpleDateFormat(parttern).format(time);
    }

    public static boolean isAfter12Hours(Date date) {
        boolean result = false;
        long times = date.getTime() - System.currentTimeMillis() - 43200000L;
        if (times > 0L) {
            result = true;
        }
        return result;
    }

    public static Date getLastWeekDate(Date date, int day) {
        int b = day;
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(2, 1);
        instance.set(5, 1);
        instance.add(5, -1);
        int a = instance.get(7);
        System.out.println("a=" + a);
        instance.add(5, b - a > 0 ? -a - (7 - b) : b - a);
        instance.add(11, 23);
        instance.add(12, 59);
        instance.add(13, 59);
        String date_str = DateUtils.formatDate(instance.getTime(), PARTTERN_1);
        System.out.println(date_str);
        return instance.getTime();
    }

    public static Date parseDate(String strDate, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatDate(Date date) {
        return DateUtils.formatDateToSecond2(date);
    }

    public static Date addTimeByType(Date date, int type, int time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(type, time);
        return calendar.getTime();
    }

    public static String getThisMonthFirstDay() throws ParseException {
        return DateUtils.formatDateToSecond(DateUtils.parseByMonth(DateUtils.formatDateToMonth(new Date())));
    }

    public static String getThisMonthLastDay() throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(PATTERN_DATE_1);
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        ca.add(11, 23);
        ca.add(12, 59);
        ca.add(13, 59);
        return format.format(ca.getTime());
    }

    public static String getLastMonthFirstDay() throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(PATTERN_DATE_1);
        Calendar cal_1 = Calendar.getInstance();
        cal_1.add(2, -1);
        cal_1.set(5, 1);
        return format.format(cal_1.getTime());
    }

    public static String getLastMonthLastDay() throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(PATTERN_DATE_1);
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 0);
        Date date = DateUtils.parseDateToDay(format.format(calendar.getTime()));
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, 23);
        calendar.add(12, 59);
        calendar.add(13, 59);
        return new SimpleDateFormat(PARTTERN_1).format(calendar.getTime());
    }

    public static String getThisYearFirstDay() throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(PARTTERN_1);
        Calendar currCal = Calendar.getInstance();
        int currentYear = currCal.get(1);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, currentYear);
        return format.format(calendar.getTime());
    }

    public static String getThisYearLastDay() throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(PARTTERN_1);
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(1);
        calendar.clear();
        calendar.set(1, currentYear);
        calendar.roll(6, -1);
        calendar.add(11, 23);
        calendar.add(12, 59);
        calendar.add(13, 59);
        return format.format(calendar.getTime());
    }

    public static String getMonthFirstDay(String date) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(DateUtils.parseByMonth(date));
        return DateUtils.formatDateToSecond(calendar.getTime());
    }

    public static String getMonthEndDay(String date) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(DateUtils.parseByMonth(date));
        calendar.roll(5, -1);
        calendar.add(11, 23);
        calendar.add(12, 59);
        calendar.add(13, 59);
        return DateUtils.formatDateToSecond(calendar.getTime());
    }

    public static Date getMonthEndDay(Date date) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        calendar.roll(5, -1);
        calendar.add(11, 23);
        calendar.add(12, 59);
        calendar.add(13, 59);
        return calendar.getTime();
    }

    public static Date get48HourBeforeTime() {
        long times = new Date().getTime() - 172800000L;
        return new Date(times);
    }

    public static Date get3MinuteBeforeTime() {
        long times = new Date().getTime() - 180000L;
        return new Date(times);
    }

    public static Date getOneMonthBeforeTime() {
        long times = new Date().getTime() - 2592000000L;
        return new Date(times);
    }

    public static Date getBirthdayFromAge(Double age) {
        Date result = new Date();
        if (age != null && age != 0.0) {
            long times = System.currentTimeMillis() - MathUtils.div(new BigDecimal(1471228928), new BigDecimal(age), 0).longValue();
            result = new Date(Long.valueOf("" + times));
        }
        return result;
    }

    public static Date convertTimezone(Date sourceDate, TimeZone sourceTimezone, TimeZone targetTimezone) {
        Calendar calendar = Calendar.getInstance();
        long sourceTime = sourceDate.getTime();
        calendar.setTimeZone(sourceTimezone);
        calendar.setTimeInMillis(sourceTime);
        int sourceZoneOffset = calendar.get(15);
        calendar.setTimeZone(targetTimezone);
        calendar.setTimeInMillis(sourceTime);
        int targetZoneOffset = calendar.get(15);
        int targetDaylightOffset = calendar.get(16);
        long targetTime = sourceTime + (long)(targetZoneOffset + targetDaylightOffset) - (long)sourceZoneOffset;
        return new Date(targetTime);
    }

    public static String getOneHourBeforeStr() {
        DateTime dateTime = new DateTime(System.currentTimeMillis());
        DateTime beforeOneTime = dateTime.minusHours(1);
        return beforeOneTime.toString(DateFormat.DATETIME_FORMAT.getFmt());
    }

    public static String getTodayStr() {
        DateTime dateTime = new DateTime((Object)DateUtils.getTodayTimeStamp());
        return dateTime.toString(DateFormat.DATETIME_FORMAT.getFmt());
    }

    public static String getTodayStrByDateFormat() {
        DateTime dateTime = new DateTime((Object)DateUtils.getTodayTimeStamp());
        return dateTime.toString(DateFormat.DATE_FORMAT.getFmt());
    }

    public static String getYesterdayStrByDateFormat() {
        DateTime dateTime = new DateTime((Object)DateUtils.getYesterdayTimeStamp());
        return dateTime.toString(DateFormat.DATE_FORMAT.getFmt());
    }

    public static String timestampToStr(Long timestamp, DateFormat fmt) {
        DateTime dateTime = new DateTime((Object)timestamp);
        if (timestamp == null || timestamp == 0L) {
            return "";
        }
        return dateTime.toString(fmt.getFmt());
    }

    public static Date timestampToDate(long timestamp) {
        DateTime dateTime = new DateTime(timestamp);
        return dateTime.toDate();
    }

    public static Date getTodayMinusDays(Integer days) {
        DateTime dateTime = new DateTime(DateUtils.getToday().getTime());
        if (days != null) {
            dateTime = days >= 0 ? dateTime.plusDays(days.intValue()) : dateTime.minusDays(Math.abs(days));
        }
        return dateTime.toDate();
    }

    public static Date getDayEnd(Date day) {
        DateTime dateTime = new DateTime(day.getTime());
        dateTime = dateTime.plusHours(23);
        dateTime = dateTime.plusMinutes(59);
        dateTime = dateTime.plusSeconds(59);
        return dateTime.toDate();
    }

    public static Integer getTodayExpiredDays(Date expiredDay) {
        Date today = DateUtils.getToday();
        Integer result = 0;
        if (expiredDay != null) {
            Long time = DateUtils.strToDate(DateUtils.dateToStr(expiredDay, DateFormat.DATE_FORMAT), DateFormat.DATE_FORMAT).getTime();
            Long tempTime = time - today.getTime();
            Long divTime = 86400000L;
            BigDecimal div = MathUtils.div(new BigDecimal(tempTime), new BigDecimal(divTime), 0);
            result = div.intValue();
        }
        return result;
    }

    public static Date timestampToDateForMonth(long timestamp) {
        DateTime dateTime = new DateTime(timestamp);
        String dateStr = dateTime.toString(DateFormat.YYYY_MM_FORMAT.getFmt());
        return DateUtils.strToDate(dateStr, DateFormat.YYYY_MM_FORMAT);
    }

    public static Date getToday() {
        DateTime dateTime = new DateTime(System.currentTimeMillis());
        String dateStr = dateTime.toString(DateFormat.DATE_FORMAT.getFmt());
        return DateUtils.strToDate(dateStr, DateFormat.DATE_FORMAT);
    }

    public static Long getTodayTimeStamp() {
        DateTime dateTime = new DateTime(System.currentTimeMillis());
        String dateStr = dateTime.toString(DateFormat.DATE_FORMAT.getFmt());
        return DateUtils.strToDate(dateStr, DateFormat.DATE_FORMAT).getTime();
    }

    public static Date getYesterday() {
        DateTime dateTime = new DateTime(System.currentTimeMillis());
        DateTime beforeSevenDayTime = dateTime.minusDays(1);
        String dateStr = beforeSevenDayTime.toString(DateFormat.DATE_FORMAT.getFmt());
        return DateUtils.strToDate(dateStr, DateFormat.DATE_FORMAT);
    }

    public static Date getTomorrow() {
        DateTime dateTime = new DateTime(System.currentTimeMillis());
        DateTime beforeSevenDayTime = dateTime.plusDays(1);
        String dateStr = beforeSevenDayTime.toString(DateFormat.DATE_FORMAT.getFmt());
        return DateUtils.strToDate(dateStr, DateFormat.DATE_FORMAT);
    }

    public static Long getYesterdayTimeStamp() {
        DateTime dateTime = new DateTime(System.currentTimeMillis());
        DateTime beforeSevenDayTime = dateTime.minusDays(1);
        String dateStr = beforeSevenDayTime.toString(DateFormat.DATE_FORMAT.getFmt());
        return DateUtils.strToDate(dateStr, DateFormat.DATE_FORMAT).getTime();
    }

    public static Date getBeforeSevenDay() {
        DateTime dateTime = new DateTime(System.currentTimeMillis());
        DateTime beforeSevenDayTime = dateTime.minusDays(7);
        String dateStr = beforeSevenDayTime.toString(DateFormat.DATE_FORMAT.getFmt());
        return DateUtils.strToDate(dateStr, DateFormat.DATE_FORMAT);
    }

    public static Long getBeforeSevenDayTimeStamp() {
        DateTime dateTime = new DateTime(System.currentTimeMillis());
        DateTime beforeSevenDayTime = dateTime.minusDays(7);
        String dateStr = beforeSevenDayTime.toString(DateFormat.DATE_FORMAT.getFmt());
        return DateUtils.strToDate(dateStr, DateFormat.DATE_FORMAT).getTime();
    }

    public static Long getThisMonthTimestamp() {
        DateTime dateTime = new DateTime(System.currentTimeMillis());
        String dateStr = dateTime.toString(DateFormat.YYYY_MM_FORMAT.getFmt());
        return DateUtils.strToDate(dateStr, DateFormat.YYYY_MM_FORMAT).getTime();
    }

    public static Date getThisMonthDate() {
        DateTime dateTime = new DateTime(System.currentTimeMillis());
        int dayOfMonth = dateTime.getDayOfMonth();
        String dateStr = "";
        if (dayOfMonth == 1) {
            dateTime = dateTime.minusMonths(1);
        }
        dateStr = dateTime.toString(DateFormat.YYYY_MM_FORMAT.getFmt());
        return DateUtils.strToDate(dateStr, DateFormat.YYYY_MM_FORMAT);
    }

    public static String dateToStr(Date date, DateFormat fmt) {
        if (date == null) {
            return "";
        }
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.toString(fmt.getFmt());
    }

    public static Date strToDate(String dateTimeStr, DateFormat fmt) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)fmt.getFmt());
        DateTime dateTime = dateTimeFormatter.parseDateTime(dateTimeStr);
        return dateTime.toDate();
    }

    public static String strToNewStr(String dateTimeStr, DateFormat fmt) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)fmt.getFmt());
        DateTime dateTime = dateTimeFormatter.parseDateTime(dateTimeStr);
        return DateUtils.dateToStr(dateTime.toDate(), DateFormat.DATE_FORMAT);
    }

    public static long toTimeStamp(String date, DateFormat fmt) {
        DateTimeFormatter formatter = DateUtils.getFormatter(fmt);
        DateTime dateTime = formatter.parseDateTime(date);
        return dateTime.getMillis() / 1000L;
    }

    public static long toTimeStampMillis(String date, DateFormat fmt) {
        DateTimeFormatter formatter = DateUtils.getFormatter(fmt);
        DateTime dateTime = formatter.parseDateTime(date);
        return dateTime.getMillis();
    }

    public static long toTimeStamp(String date, DateFormat sourceFmt, DateFormat targetFmt) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return 0L;
        }
        String parse = DateUtils.parse(date, sourceFmt, targetFmt);
        return DateUtils.toTimeStamp(parse, targetFmt);
    }

    public static int toIntTimeStamp(String date, DateFormat fmt) {
        DateTimeFormatter formatter = DateUtils.getFormatter(fmt);
        DateTime dateTime = formatter.parseDateTime(date);
        return (int)(dateTime.getMillis() / 1000L);
    }

    public static String timestampToString(Integer timestamp, DateFormat fmt) {
        DateTimeFormatter formatter = DateUtils.getFormatter(fmt);
        DateTime dateTime = new DateTime(timestamp.longValue() * 1000L);
        return dateTime.toString(formatter);
    }

    public static String timestampToString(Long timestamp, DateFormat fmt) {
        DateTimeFormatter formatter = DateUtils.getFormatter(fmt);
        DateTime dateTime = new DateTime(timestamp * 1000L);
        return dateTime.toString(formatter);
    }

    public static boolean formatCheck(String date, DateFormat fmt) {
        DateTimeFormatter formatter = DateUtils.getFormatter(fmt);
        try {
            formatter.parseDateTime(date);
            return true;
        }
        catch (Exception var4) {
            return false;
        }
    }

    public static String parse(String date, DateFormat sourceFmt, DateFormat targetFmt) {
        DateTimeFormatter source = DateUtils.getFormatter(sourceFmt);
        DateTime dateTime = source.parseDateTime(date);
        DateTimeFormatter target = DateUtils.getFormatter(targetFmt);
        return dateTime.toString(target);
    }

    public static String plusDays(String date, int days, DateFormat fmt) {
        DateTimeFormatter formatter = DateUtils.getFormatter(fmt);
        DateTime dateTime = formatter.parseDateTime(date);
        DateTime plusDays = dateTime.plusDays(days);
        return plusDays.toString(formatter);
    }

    public static String yesterday(String date, DateFormat fmt) throws Exception {
        if (StringUtils.isEmpty((CharSequence)date)) {
            throw new Exception("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fmt == null) {
            throw new Exception("\u683c\u5f0f\u5316\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateTimeFormatter formatter = DateUtils.getFormatter(fmt);
        DateTime dateTime = formatter.parseDateTime(date);
        DateTime yesterday = dateTime.plusDays(-1);
        return yesterday.toString(formatter);
    }

    public static String yesterday() throws Exception {
        String date = DateTime.now().toString(DateUtils.getFormatter(DateFormat.DATE_FORMAT));
        return DateUtils.yesterday(date);
    }

    public static String yesterday(String date) throws Exception {
        return DateUtils.yesterday(date, DateFormat.DATE_FORMAT);
    }

    public static String yesterday(DateFormat fmt) throws Exception {
        String date = DateTime.now().toString(DateUtils.getFormatter(fmt));
        return DateUtils.yesterday(date, fmt);
    }

    public static Long yesterdayTimeStamp(Long date) throws Exception {
        return DateUtils.yesterdayTimeStamp(date, DateFormat.DATE_FORMAT);
    }

    public static Long yesterdayTimeStamp(Long date, DateFormat fmt) throws Exception {
        if (date == null || date == 0L) {
            throw new Exception("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fmt == null) {
            throw new Exception("\u683c\u5f0f\u5316\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateTimeFormatter formatter = DateUtils.getFormatter(fmt);
        DateTime dateTime = formatter.parseDateTime(DateUtils.timestampToStr(date, fmt));
        DateTime yesterday = dateTime.plusDays(-1);
        return yesterday.getMillis();
    }

    public static String lastWeekFirstDay(String date, DateFormat fmt) throws Exception {
        if (StringUtils.isEmpty((CharSequence)date)) {
            throw new Exception("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fmt != null) {
            throw new Exception("\u683c\u5f0f\u5316\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateTimeFormatter formatter = DateUtils.getFormatter(fmt);
        DateTime dateTime = formatter.parseDateTime(date);
        DateTime lastWeek = dateTime.plusWeeks(-1);
        int dayOfWeek = lastWeek.getDayOfWeek();
        DateTime lastWeekFirstDay = lastWeek.plusDays(1 - dayOfWeek);
        return lastWeekFirstDay.toString(formatter);
    }

    public static String lastWeekFirstDay(String date) throws Exception {
        return DateUtils.lastWeekFirstDay(date, DateFormat.DATE_FORMAT);
    }

    public static String lastWeekFirstDay() throws Exception {
        DateTimeFormatter formatter = DateUtils.getFormatter(DateFormat.DATE_FORMAT);
        String now = DateTime.now().toString(formatter);
        return DateUtils.lastWeekFirstDay(now);
    }

    public static String lastWeekLastDay(String date, DateFormat fmt) throws Exception {
        if (StringUtils.isEmpty((CharSequence)date)) {
            throw new Exception("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fmt != null) {
            throw new Exception("\u683c\u5f0f\u5316\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateTimeFormatter formatter = DateUtils.getFormatter(fmt);
        DateTime dateTime = formatter.parseDateTime(date);
        DateTime lastWeek = dateTime.plusWeeks(-1);
        int dayOfWeek = lastWeek.getDayOfWeek();
        DateTime lastWeekLastDay = lastWeek.plusDays(7 - dayOfWeek);
        return lastWeekLastDay.toString(formatter);
    }

    public static String lastWeekLastDay(String date) throws Exception {
        return DateUtils.lastWeekFirstDay(date, DateFormat.DATE_FORMAT);
    }

    public static String lastWeekLastDay() throws Exception {
        DateTimeFormatter formatter = DateUtils.getFormatter(DateFormat.DATE_FORMAT);
        String now = DateTime.now().toString(formatter);
        return DateUtils.lastWeekLastDay(now);
    }

    public static Long lastWeekDay(Long date, DateFormat fmt) throws Exception {
        if (date == null || date == 0L) {
            throw new Exception("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (fmt == null) {
            throw new Exception("\u683c\u5f0f\u5316\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateTimeFormatter formatter = DateUtils.getFormatter(fmt);
        DateTime dateTime = formatter.parseDateTime(DateUtils.timestampToStr(date, fmt));
        DateTime lastWeek = dateTime.plusWeeks(-1);
        return lastWeek.getMillis();
    }

    public static Long lastWeekDay(Long date) throws Exception {
        return DateUtils.lastWeekDay(date, DateFormat.DATE_FORMAT);
    }

    private static DateTimeFormatter getFormatter(DateFormat fmt) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)fmt.getFmt());
        return dateTimeFormatter;
    }

    public static Integer intTimestamp() {
        long l = System.currentTimeMillis() / 1000L;
        return (int)l;
    }

    public static Long longTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String getMillisecondToHourAndMinutes(Long recentCumulativeChargingTime) {
        if (recentCumulativeChargingTime == null) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        if (recentCumulativeChargingTime != null && recentCumulativeChargingTime >= 3600000L) {
            sb.append(recentCumulativeChargingTime / 3600000L).append("\u5c0f\u65f6").append(recentCumulativeChargingTime % 3600000L / 60000L).append("\u5206");
        } else {
            sb.append(recentCumulativeChargingTime % 3600000L / 60000L).append("\u5206");
        }
        return sb.toString();
    }

    public static String getOrderTimeStr(String monthlyChargingTime) {
        if (StringUtils.isBlank((CharSequence)monthlyChargingTime)) {
            return "";
        }
        String[] split = monthlyChargingTime.split(",");
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (String str : split) {
            set.add(Integer.valueOf(str));
        }
        StringBuilder sb = new StringBuilder();
        for (Integer item : set) {
            sb.append(item).append("\u70b9,");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static long getDaysNearbyToday(Date date) {
        long time = date.getTime();
        long today = DateUtils.getToday().getTime();
        long ss = time - today;
        long l = ss / 86400000L;
        return l;
    }

    public static void main(String[] args) throws ParseException {
        Date yesterday = DateUtils.getYesterday();
        long daysNearbyToday = DateUtils.getDaysNearbyToday(yesterday);
        long daysNearbyToday1 = DateUtils.getDaysNearbyToday(DateUtils.getTomorrow());
        System.out.println(daysNearbyToday);
        System.out.println(daysNearbyToday1);
    }

    static {
        String[] s;
        int i;
        logger = LoggerFactory.getLogger(DateUtils.class);
        originDate = new Date(100L);
        weeks = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        FMT_YMD = new SimpleDateFormat(PATTERN_DATE_1);
        hours = new ArrayList<String[]>();
        minuts = new ArrayList<String[]>();
        if (hours.size() == 0) {
            for (i = 0; i < 24; ++i) {
                s = new String[]{i + 1 + "", i + 1 + "h"};
                hours.add(s);
            }
        }
        if (minuts.size() == 0) {
            for (i = 0; i < 60; ++i) {
                if (i % 5 != 0) continue;
                s = new String[]{i + "", i + "m"};
                minuts.add(s);
            }
        }
    }

    public static enum DateFormat {
        YYYYMMDDHHMMSS("yyyyMMddHHmmss"),
        YYYY_MM_FORMAT("yyyyMM"),
        YYYYMMDDFORMAT("yyyyMMdd"),
        YYYYMMDDFORMATOTHER("yyyy/MM/dd"),
        MMDD_FORMAT("MM/dd"),
        DATE_FORMAT("yyyy-MM-dd"),
        DATETIME_FORMAT("yyyy-MM-dd HH:mm:ss"),
        YYYY_MM_DD_HH_MM_FORMAT("yyyy-MM-dd HH:mm");

        private String fmt;

        private DateFormat(String fmt) {
            this.fmt = fmt;
        }

        public String getFmt() {
            return this.fmt;
        }
    }
}

