/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.constant.SystemConfig;
import com.talkilla.mysql.domain.TDistributionUser;
import com.talkilla.mysql.domain.TSysdict;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.service.TSysdictService;
import com.talkilla.service.admin.AdminDistributionUserService;
import com.talkilla.utils.QRCodeUtil;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/distribute"})
public class AdminDistributionUserController {
    @Autowired
    AdminDistributionUserService adminDistributionUserService;
    @Autowired
    TSysdictService tSysdictService;

    @RequestMapping(value={"/list"})
    public String distrUserList(Model model, @RequestParam(defaultValue="0") int pid, @RequestParam(defaultValue="5") int pageSize, @RequestParam(defaultValue="1") int pageNo) throws ParseException {
        PageObj pageObj = this.adminDistributionUserService.findListByPid(pid, pageSize, pageNo);
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("pid", (Object)pid);
        return "distributionUser";
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public String addDistrUser(TDistributionUser tDistributionUser) throws ParseException {
        Integer parentId = tDistributionUser.getParentId();
        if (parentId == null || parentId == 0) {
            tDistributionUser.setLevel(Integer.valueOf(1));
            tDistributionUser.setParentId(Integer.valueOf(0));
        } else {
            tDistributionUser.setLevel(Integer.valueOf(2));
        }
        this.adminDistributionUserService.addDistUser(tDistributionUser);
        return "ok";
    }

    @RequestMapping(value={"/add/page"})
    public String addDistrUserPage(@RequestParam(defaultValue="0") int pid, Model model) throws ParseException {
        if (pid > 0) {
            TDistributionUser byId = this.adminDistributionUserService.findById(pid);
            model.addAttribute("parent", (Object)byId);
        }
        return "distributionUserAdd";
    }

    @RequestMapping(value={"/edit/page"})
    public String editDistrUserPage(@RequestParam(defaultValue="0") int id, Model model) throws ParseException {
        TDistributionUser byId = this.adminDistributionUserService.findById(id);
        model.addAttribute("distUser", (Object)byId);
        return "distributionUserEdit";
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    @ResponseBody
    public String editDistrUser(TDistributionUser user, Model model) throws ParseException {
        this.adminDistributionUserService.addDistUser(user);
        return "ok";
    }

    @RequestMapping(value={"/pic/add/page"})
    public String addDistrPicPage(Model model) throws ParseException {
        TSysdict tSysdict = this.tSysdictService.fingBgImg();
        model.addAttribute("bgImg", (Object)tSysdict.getDictname());
        return "distributionPicAdd";
    }

    @RequestMapping(value={"/pic/add"})
    @ResponseBody
    public String addPic(String imgUrl) throws ParseException {
        if (StringUtils.isNotBlank((String)imgUrl)) {
            this.tSysdictService.updateBgImg(imgUrl);
        }
        return "ok";
    }

    @RequestMapping(value={"/download/qRcode"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> downloadQRcode(HttpServletResponse response, HttpServletRequest request, int id) throws UnsupportedEncodingException {
        String agent = request.getHeader("User-Agent");
        TDistributionUser school = this.adminDistributionUserService.findById(id);
        TDistributionUser parent = this.adminDistributionUserService.findById(school.getParentId().intValue());
        String fileName = parent.getCompany() + "_" + school.getCompany();
        TSysdict tSysdict = this.tSysdictService.fingBgImg();
        fileName = new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
        response.setHeader("Content-Type", "application/octet-stream;charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".jpg");
        String recommendregistUrl = String.format(SystemConfig.Wechat.WECHAT_RECOMMENDREGIST, school.getId(), 2);
        try {
            QRCodeUtil.encode((String)recommendregistUrl, (String)tSysdict.getDictname(), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
    }
}

