/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.SearchStudentsForm;
import com.talkilla.form.admin.AdminCoursePackageAddSaveForm;
import com.talkilla.form.admin.AdminCoursePackageAddStudentSaveForm;
import com.talkilla.form.admin.AdminCoursePackageDeleteStudentSaveForm;
import com.talkilla.form.admin.AdminCoursePackageQueryForm;
import com.talkilla.form.admin.AdminCoursePackageSettingSaveForm;
import com.talkilla.form.admin.AdminSellCourseEditSaveForm;
import com.talkilla.form.admin.AdminSellCourseListForm;
import com.talkilla.form.admin.CoursePackageAwardConfirmForm;
import com.talkilla.form.admin.CoursePackageAwardSaveForm;
import com.talkilla.interceptor.SessionUtils;
import com.talkilla.mysql.mapper.TSellCourseDao;
import com.talkilla.mysql.mapper.TSellCourseOrderDao;
import com.talkilla.otherbean.UserDto;
import com.talkilla.result.CoursePackageAwardConfirmResult;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.admin.AdminCoursePackageAddResult;
import com.talkilla.result.admin.AdminCoursePackageDetailResult;
import com.talkilla.result.admin.AdminCoursePackageEditResult;
import com.talkilla.result.admin.AdminCoursePackageRenewResult;
import com.talkilla.result.admin.AdminCoursePackageSettingResult;
import com.talkilla.result.admin.AdminSellCourseListResult;
import com.talkilla.result.admin.CoursePackageAwardResult;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.service.TCourseService;
import com.talkilla.service.TLoginService;
import com.talkilla.service.TStudentService;
import com.talkilla.service.TTeacherService;
import com.talkilla.service.TWechatService;
import com.talkilla.service.admin.AdminCourseService;
import com.talkilla.service.admin.AdminExportService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/course"})
public class AdminCourseManageController {
    private SimpleDateFormat s = new SimpleDateFormat("yyyy-MM");
    @Autowired
    AdminCourseService adminCourseService;
    @Autowired
    TTeacherService tTeacherService;
    @Autowired
    TStudentService tStudentService;
    @Autowired
    TLoginService tLoginService;
    @Autowired
    TCourseService tCourseService;
    @Autowired
    AdminExportService adminExportService;
    @Autowired
    TSellCourseOrderDao tSellCourseOrderDao;
    @Autowired
    TSellCourseDao tSellCourseDao;
    @Autowired
    private TWechatService tWechatService;

    @RequestMapping(value={"/sell/course/list"})
    public String sellCourseList(HttpServletRequest request, Model model, AdminSellCourseListForm form) {
        PageObj pageObj = this.adminCourseService.sellCourseList(form);
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        return "sellCourseList";
    }

    @RequestMapping(value={"/sell/course/edit"})
    public String sellCourseEdit(HttpServletRequest request, Model model, Integer id) {
        AdminSellCourseListResult result = this.adminCourseService.sellCourseEdit(id);
        model.addAttribute("sellCourse", (Object)result);
        return "sellCourseDetail";
    }

    @RequestMapping(value={"/sell/course/edit/save"})
    @ResponseBody
    public Object sellCourseEditSave(HttpServletRequest request, Model model, AdminSellCourseEditSaveForm form) {
        ReturnMessageResult messageResult = this.adminCourseService.sellCourseEditSave(form);
        return messageResult;
    }

    @RequestMapping(value={"/sell/course/add"})
    public String sellCourseAdd() {
        return "sellCourseAdd";
    }

    @RequestMapping(value={"/sell/course/add/save"})
    @ResponseBody
    public Object sellCourseAddSave(HttpServletRequest request, Model model, AdminSellCourseEditSaveForm form) {
        ReturnMessageResult messageResult = this.adminCourseService.sellCourseAddSave(form);
        model.addAttribute("messageResult", (Object)messageResult);
        return messageResult;
    }

    @RequestMapping(value={"/course/package/list"})
    public String coursePackageList(HttpServletRequest req, HttpServletResponse res, HttpSession session, Model model, AdminCoursePackageQueryForm form) {
        PageObj pageObj = this.adminCourseService.findCoursePackageQuerys(form);
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        return "coursePackageManageList";
    }

    @RequestMapping(value={"/course/package/delete"})
    @ResponseBody
    public Object coursePackageDelete(HttpServletRequest req, HttpServletResponse res, HttpSession session, Model model, Integer cid) {
        ReturnMessageResult messageResult = this.adminCourseService.coursePackageDelete(cid);
        return messageResult;
    }

    @RequestMapping(value={"/course/package/time/clear"})
    @ResponseBody
    public Object coursePackageTimeClear(HttpServletRequest req, HttpServletResponse res, HttpSession session, Model model, Integer cid) {
        ReturnMessageResult messageResult = this.adminCourseService.coursePackageTimeClear(cid);
        return messageResult;
    }

    @RequestMapping(value={"/course/package/detail"})
    public String coursePackageDetail(HttpServletRequest req, HttpServletResponse res, HttpSession session, Model model, Integer cid) {
        AdminCoursePackageDetailResult result = this.adminCourseService.coursePackageDetail(cid);
        model.addAttribute("courseDto", (Object)result);
        return "courseDetail";
    }

    @RequestMapping(value={"/course/package/add"})
    public String coursePackageAdd(HttpServletRequest req, HttpServletResponse res, Integer id, HttpSession session, Model model) {
        AdminCoursePackageAddResult result = this.adminCourseService.coursePackageAdd(id);
        String token = UUID.randomUUID().toString();
        req.getSession().setAttribute("token", (Object)token);
        model.addAttribute("token", (Object)token);
        model.addAttribute("result", (Object)result);
        model.addAttribute("sellCourseName", (Object)result.getSellCourseName());
        model.addAttribute("stuid", (Object)result.getStuid());
        model.addAttribute("stuname", (Object)result.getStuname());
        model.addAttribute("classid", (Object)new SimpleDateFormat("yyMMddHHmm").format(new Date()));
        model.addAttribute("sellCourseOrder", (Object)result.getSellCourseOrder());
        model.addAttribute("sellCourse", (Object)result.getSellCourse());
        model.addAttribute("date", (Object)new Date());
        model.addAttribute("showloginList", new ArrayList());
        return "coursePackageAdd";
    }

    @RequestMapping(value={"/course/package/add/save"})
    public String coursePackageAddSave(AdminCoursePackageAddSaveForm form, HttpServletRequest req, HttpServletResponse res, HttpSession session, Model model) {
        ReturnMessageResult messageResult;
        if (SessionUtils.isSubmit(req)) {
            messageResult = new ReturnMessageResult();
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4\u6570\u636e");
        } else {
            UserDto userDto = (UserDto)session.getAttribute(TalkillaConstant.SESSION_ADMIN_LOGIN_PREFIX);
            form.setLoginId(userDto.getLoginId());
            messageResult = this.adminCourseService.coursePackageAddSave(form);
        }
        model.addAttribute("message", (Object)messageResult.getMessage());
        if (messageResult.getFlag() == 1) {
            model.addAttribute("token", (Object)UUID.randomUUID().toString());
            return "coursePackageAdd";
        }
        return "redirect:/course/course/package/list";
    }

    @RequestMapping(value={"/search/students"})
    public String searchStudents(SearchStudentsForm form, Model model) {
        List list = this.tStudentService.findListsbyRemoveIds(form);
        model.addAttribute("list", (Object)list);
        model.addAttribute("form", (Object)form);
        return "openStudents";
    }

    @RequestMapping(value={"/search/students/del"})
    public String searchStudentsDel(SearchStudentsForm form, Model model) {
        List list = this.tStudentService.findByPids(form);
        model.addAttribute("list", (Object)list);
        model.addAttribute("form", (Object)form);
        return "openStudents";
    }

    @RequestMapping(value={"/course/package/edit"})
    public String coursePackageEdit(Model model, HttpServletRequest req, Integer cid) {
        AdminCoursePackageEditResult result = this.adminCourseService.coursePackageEdit(cid);
        String token = UUID.randomUUID().toString();
        req.getSession().setAttribute("token", (Object)token);
        model.addAttribute("token", (Object)token);
        model.addAttribute("result", (Object)result);
        model.addAttribute("sellCourseName", (Object)result.getSellCourseName());
        model.addAttribute("stuid", (Object)result.getStuid());
        model.addAttribute("stuname", (Object)result.getStuname());
        model.addAttribute("classid", (Object)new SimpleDateFormat("yyMMddHHmm").format(new Date()));
        model.addAttribute("date", (Object)new Date());
        model.addAttribute("showloginList", (Object)result.getStudentDtos());
        model.addAttribute("instance", (Object)result.getCourse());
        return "coursePackageEdit";
    }

    @RequestMapping(value={"/course/package/edit/save"})
    public String coursePackageEditSave(Model model, HttpSession session, HttpServletRequest req, AdminCoursePackageAddSaveForm form) {
        ReturnMessageResult messageResult;
        if (SessionUtils.isSubmit(req)) {
            messageResult = new ReturnMessageResult();
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4\u6570\u636e");
        } else {
            UserDto userDto = (UserDto)session.getAttribute(TalkillaConstant.SESSION_ADMIN_LOGIN_PREFIX);
            form.setLoginId(userDto.getLoginId());
            messageResult = this.adminCourseService.coursePackageEditSave(form);
        }
        model.addAttribute("message", (Object)messageResult.getMessage());
        if (messageResult.getFlag() == 1) {
            model.addAttribute("token", (Object)UUID.randomUUID().toString());
            return "coursePackageEdit";
        }
        return "redirect:/course/course/package/list";
    }

    @RequestMapping(value={"/course/package/renew"})
    public String coursePackageRenew(Model model, HttpServletRequest req, Integer cid) {
        AdminCoursePackageRenewResult result = this.adminCourseService.coursePackageRenew(cid);
        String token = UUID.randomUUID().toString();
        req.getSession().setAttribute("token", (Object)token);
        model.addAttribute("token", (Object)token);
        model.addAttribute("result", (Object)result);
        model.addAttribute("sellCourseName", (Object)result.getSellCourseName());
        model.addAttribute("stuid", (Object)result.getStuid());
        model.addAttribute("stuname", (Object)result.getStuname());
        model.addAttribute("classid", (Object)new SimpleDateFormat("yyMMddHHmm").format(new Date()));
        model.addAttribute("date", (Object)new Date());
        model.addAttribute("showloginList", (Object)result.getStudentDtos());
        model.addAttribute("instance", (Object)result.getCourse());
        return "coursePackageRenew";
    }

    @RequestMapping(value={"/course/package/setting"})
    public String coursePackageSetting(Model model, HttpServletRequest req, Integer cid) {
        AdminCoursePackageSettingResult result = this.adminCourseService.coursePackageSetting(cid);
        model.addAttribute("result", (Object)result);
        return "coursePackageSetting";
    }

    @RequestMapping(value={"/course/package/setting/save"})
    @ResponseBody
    public String coursePackageSettingSave(Model model, HttpServletRequest req, AdminCoursePackageSettingSaveForm form) {
        ReturnMessageResult result = this.adminCourseService.coursePackageSettingSave(form);
        return result.getMessage();
    }

    @RequestMapping(value={"/course/package/student/add"})
    public String coursePackageAddStudent(Model model, HttpServletRequest req, Integer cid) {
        AdminCoursePackageEditResult result = this.adminCourseService.coursePackageEdit(cid);
        String token = UUID.randomUUID().toString();
        req.getSession().setAttribute("token", (Object)token);
        model.addAttribute("token", (Object)token);
        model.addAttribute("result", (Object)result);
        model.addAttribute("sellCourseName", (Object)result.getSellCourseName());
        model.addAttribute("stuid", (Object)result.getStuid());
        model.addAttribute("stuname", (Object)result.getStuname());
        model.addAttribute("classid", (Object)new SimpleDateFormat("yyMMddHHmm").format(new Date()));
        model.addAttribute("date", (Object)new Date());
        model.addAttribute("showloginList", (Object)result.getStudentDtos());
        model.addAttribute("instance", (Object)result.getCourse());
        return "coursePackageStudentAdd";
    }

    @RequestMapping(value={"/course/package/add/student/save"})
    public String coursePackageAddStudentSave(Model model, HttpSession session, HttpServletRequest req, AdminCoursePackageAddStudentSaveForm form) {
        ReturnMessageResult messageResult;
        if (SessionUtils.isSubmit(req)) {
            messageResult = new ReturnMessageResult();
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4\u6570\u636e");
        } else {
            UserDto userDto = (UserDto)session.getAttribute(TalkillaConstant.SESSION_ADMIN_LOGIN_PREFIX);
            form.setLoginId(userDto.getLoginId());
            messageResult = this.adminCourseService.coursePackageAddStudentSave(form);
        }
        model.addAttribute("message", (Object)messageResult.getMessage());
        if (messageResult.getFlag() == 1) {
            model.addAttribute("token", (Object)UUID.randomUUID().toString());
            return "coursePackageStudentAdd";
        }
        return "redirect:/course/course/package/list";
    }

    @RequestMapping(value={"/course/package/student/del"})
    public String coursePackageDelStudent(Model model, HttpServletRequest req, Integer cid) {
        AdminCoursePackageEditResult result = this.adminCourseService.coursePackageEdit(cid);
        String token = UUID.randomUUID().toString();
        req.getSession().setAttribute("token", (Object)token);
        model.addAttribute("token", (Object)token);
        model.addAttribute("result", (Object)result);
        model.addAttribute("sellCourseName", (Object)result.getSellCourseName());
        model.addAttribute("stuid", (Object)result.getStuid());
        model.addAttribute("stuname", (Object)result.getStuname());
        model.addAttribute("classid", (Object)new SimpleDateFormat("yyMMddHHmm").format(new Date()));
        model.addAttribute("date", (Object)new Date());
        model.addAttribute("showloginList", (Object)result.getStudentDtos());
        model.addAttribute("instance", (Object)result.getCourse());
        return "coursePackageStudentDel";
    }

    @RequestMapping(value={"/course/package/delete/student/save"})
    public String coursePackageDeleteStudentSave(Model model, HttpSession session, HttpServletRequest req, AdminCoursePackageDeleteStudentSaveForm form) {
        ReturnMessageResult messageResult;
        if (SessionUtils.isSubmit(req)) {
            messageResult = new ReturnMessageResult();
            messageResult.setFlag(Integer.valueOf(1));
            messageResult.setMessage("\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4\u6570\u636e");
        } else {
            UserDto userDto = (UserDto)session.getAttribute(TalkillaConstant.SESSION_ADMIN_LOGIN_PREFIX);
            form.setLoginId(userDto.getLoginId());
            messageResult = this.adminCourseService.coursePackageDeleteStudentSave(form);
        }
        model.addAttribute("message", (Object)messageResult.getMessage());
        if (messageResult.getFlag() == 1) {
            model.addAttribute("token", (Object)UUID.randomUUID().toString());
            return "coursePackageStudentDel";
        }
        return "redirect:/course/course/package/list";
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public Object test() {
        this.adminCourseService.test();
        return "success";
    }

    @RequestMapping(value={"/course/package/award"})
    public String coursePackageAward(HttpServletRequest req, HttpServletResponse res, Integer cid, HttpSession session, Model model) {
        CoursePackageAwardResult result = this.adminCourseService.coursePackageAward(cid);
        model.addAttribute("instance", (Object)result);
        return "coursePackageAddAward";
    }

    @RequestMapping(value={"/course/package/award/confirm"})
    public String coursePackageAwardConfirm(HttpServletRequest req, HttpServletResponse res, Integer cid, HttpSession session, Model model, CoursePackageAwardConfirmForm form) {
        CoursePackageAwardConfirmResult result = this.adminCourseService.coursePackageAwardConfirm(form);
        if (result.getFlag() == 0) {
            model.addAttribute("instance", (Object)result);
            return "coursePackageAddAwardConfirm";
        }
        CoursePackageAwardResult returnResult = this.adminCourseService.coursePackageAward(cid);
        model.addAttribute("message", (Object)result.getMessage());
        model.addAttribute("instance", (Object)returnResult);
        return "coursePackageAddAward";
    }

    @RequestMapping(value={"/course/package/award/save"})
    public String coursePackageAwardSave(HttpServletRequest req, HttpServletResponse res, Integer cid, HttpSession session, Model model, CoursePackageAwardSaveForm form) throws ParseException {
        ReturnMessageResult messageResult = this.adminCourseService.coursePackageAwardSave(form);
        if (messageResult == null || messageResult.getFlag() != 0) {
            CoursePackageAwardResult result = this.adminCourseService.coursePackageAward(cid);
            model.addAttribute("instance", (Object)result);
            model.addAttribute("message", (Object)messageResult.getMessage());
            return "coursePackageAddAward";
        }
        return "redirect:/course/course/package/list";
    }
}

