/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.constant.TalkillaConstant;
import com.talkilla.form.admin.message.MessageAddForm;
import com.talkilla.mysql.domain.TMessage;
import com.talkilla.otherbean.UserDto;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.service.admin.MessageService;
import com.talkilla.service.form.QueryMessageForm;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/message"})
public class MessageController {
    @Autowired
    private MessageService messageService;

    @RequestMapping(value={"/list"})
    public String list(QueryMessageForm form, Model model) {
        PageObj pageObj = this.messageService.findPageMessage(form);
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        return "message/list";
    }

    @RequestMapping(value={"/add"})
    public String add() {
        return "message/add";
    }

    @RequestMapping(value={"/edit"})
    public String edit(Integer id, Model model) {
        TMessage tMessage = this.messageService.getByMessageId(id);
        model.addAttribute("message", (Object)tMessage);
        return "message/edit";
    }

    @RequestMapping(value={"/detail"})
    public String detail(Integer id, Model model) {
        TMessage tMessage = this.messageService.getByMessageId(id);
        model.addAttribute("message", (Object)tMessage);
        return "message/detail";
    }

    @RequestMapping(value={"/saveOrUpdate"})
    public String saveOrUpdate(MessageAddForm form, Model model, HttpSession session) {
        UserDto userDto = (UserDto)session.getAttribute(TalkillaConstant.SESSION_ADMIN_LOGIN_PREFIX);
        form.setLoginId(userDto.getLoginId());
        this.messageService.saveOrUpdate(form);
        QueryMessageForm queryMessageForm = new QueryMessageForm();
        return "redirect:/" + this.list(queryMessageForm, model);
    }

    @RequestMapping(value={"/delete"})
    public String deleteByMessageId(Integer id, Model model, HttpSession session) {
        UserDto userDto = (UserDto)session.getAttribute(TalkillaConstant.SESSION_ADMIN_LOGIN_PREFIX);
        this.messageService.deleteByMessageId(id, userDto.getLoginId());
        QueryMessageForm queryMessageForm = new QueryMessageForm();
        return "redirect:/" + this.list(queryMessageForm, model);
    }
}

