/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.google.common.collect.Lists;
import com.talkilla.constant.TalkillaConstant;
import com.talkilla.exception.BusinessException;
import com.talkilla.exception.base.ExceptionUtil;
import com.talkilla.form.admin.AdminTeacherAddBonusForm;
import com.talkilla.form.admin.AdminTeacherMonthIncomeRecordAddOrUpdateForm;
import com.talkilla.form.admin.AdminTeacherWagesForm;
import com.talkilla.form.admin.AdminTeacherWagesFormOld;
import com.talkilla.form.admin.AdminTeachingRecordEditRecoverForm;
import com.talkilla.form.admin.AdminTeachingRecordEditSaveForm;
import com.talkilla.form.admin.AdminTeachingRecordsForm;
import com.talkilla.mysql.domain.TTeacher;
import com.talkilla.mysql.mapper.TTeacherDao;
import com.talkilla.otherbean.AssignedCell;
import com.talkilla.otherbean.BankBillDto;
import com.talkilla.otherbean.ExportExcelParameter;
import com.talkilla.otherbean.TeacherManagementActionQueryDto;
import com.talkilla.otherbean.UserDto;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.admin.AdminTeacherWagesDetailListResult;
import com.talkilla.result.admin.AdminTeacherWagesDetailListResult2;
import com.talkilla.result.admin.AdminTeacherWagesResult;
import com.talkilla.result.admin.AdminTeacherWagesResult2;
import com.talkilla.result.admin.AdminTeachingRecordEditResult;
import com.talkilla.result.admin.AdminTeachingRecordListResult;
import com.talkilla.result.admin.AdminWagesCollectResult;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.result.admin.export.AdminTeacherWagesDetailExportTemplate;
import com.talkilla.result.admin.export.AdminTeacherWagesExportTemplate;
import com.talkilla.service.TForeignServiceService;
import com.talkilla.service.TNationService;
import com.talkilla.service.TSysdictService;
import com.talkilla.service.TTeacherService;
import com.talkilla.service.TTimezoneService;
import com.talkilla.service.admin.AdminExportService;
import com.talkilla.service.admin.AdminTeacherManageService;
import com.talkilla.service.form.AdminPrintBillForm;
import com.talkilla.service.form.AdminTeacherFenleiForm;
import com.talkilla.service.form.AdminTeacherFenleiSaveForm;
import com.talkilla.service.form.AdminTeacherListForm;
import com.talkilla.service.form.AdminTeacherManageEditSaveForm;
import com.talkilla.service.impl.InitDictionUtil;
import com.talkilla.utils.DateUtils;
import com.talkilla.utils.ExcelUtils;
import com.talkilla.utils.NoServiceUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.lang.StringUtils;
import org.nestframework.commons.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/teacher/manage"})
public class AdminTeacherManageController {
    @Autowired
    TTeacherDao tTeacherDao;
    @Autowired
    AdminExportService adminExportService;
    @Autowired
    TNationService tNationService;
    @Autowired
    TTeacherService tTeacherService;
    @Autowired
    TSysdictService tSysdictService;
    @Autowired
    TTimezoneService tTimezoneService;
    @Autowired
    AdminTeacherManageService adminTeacherManageService;
    @Autowired
    TForeignServiceService tForeignServiceService;
    @Autowired
    InitDictionUtil initDictionUtil;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat s = new SimpleDateFormat("yyyy-MM");

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(Exception ex) {
        return ExceptionUtil.printErrorInfo((Exception)ex);
    }

    @RequestMapping(value={"/export/bill/index"})
    public Object doDefault() {
        return "billList";
    }

    @RequestMapping(value={"/bill/export"})
    public Object doExport(HttpServletRequest req, HttpServletResponse res, HttpSession session, Model model, AdminPrintBillForm form) throws BusinessException, ParseException {
        String dateStart = form.getDateStart();
        String dateEnd = form.getDateEnd();
        if (StringUtils.isBlank((String)dateStart) || StringUtils.isBlank((String)dateEnd)) {
            model.addAttribute("error", (Object)"\u53c2\u6570\u9519\u8bef");
            return "billList";
        }
        Date start = DateUtils.parseDateToDay((String)dateStart);
        Date end = DateUtils.parseDateToDay((String)dateEnd);
        end = NoServiceUtil.correctDate((Date)end);
        List bs = this.adminTeacherManageService.findBillsByTime(start, end);
        ExportExcelParameter para = new ExportExcelParameter();
        ArrayList<AssignedCell[]> data = new ArrayList<AssignedCell[]>();
        try {
            para.setTemplateName("WEB-INF/template/\u5bf9\u8d26\u5355.xls");
            para.setDataRow(new AssignedCell(1, 0, (Object)""));
            para.setNeedCopyTemplateRow(true);
            para.setDataRowSpan(1);
            para.setTotalCol(10);
            if (null != bs) {
                int i = 1;
                int cs = 0;
                for (Object tObj : bs) {
                    BankBillDto dto = (BankBillDto)tObj;
                    AssignedCell[] row1 = new AssignedCell[]{new AssignedCell(0, 0, (Object)dto.getClassName(), cs), new AssignedCell(0, 1, (Object)dto.getCreateDate(), cs), new AssignedCell(0, 2, (Object)dto.getHourpurchase(), cs), new AssignedCell(0, 3, (Object)dto.getHourawarded(), cs), new AssignedCell(0, 4, (Object)dto.getDanjia(), cs), new AssignedCell(0, 5, (Object)dto.getZongjia(), cs), new AssignedCell(0, 6, (Object)dto.getComplete(), cs), new AssignedCell(0, 7, (Object)dto.getTleave(), cs), new AssignedCell(0, 8, (Object)dto.getSleave(), cs), new AssignedCell(0, 9, (Object)dto.getTabsent(), cs), new AssignedCell(0, 10, (Object)dto.getSabsent(), cs), new AssignedCell(0, 11, (Object)dto.getUncomplete(), cs), new AssignedCell(0, 12, (Object)dto.getApplymoney(), cs), new AssignedCell(0, 13, (Object)dto.getTName(), cs), new AssignedCell(0, 14, (Object)dto.getStuName(), cs), new AssignedCell(0, 15, (Object)dto.getFatherName(), cs), new AssignedCell(0, 16, (Object)dto.getNotes(), cs)};
                    data.add(row1);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.adminExportService.exportExcelByTemplate(para, "\u5bf9\u8d26\u5355(" + form.getDateStart() + "-" + form.getDateEnd() + ").xls", res, session, data);
    }

    @RequestMapping(value={"/wages/v1"})
    @Deprecated
    public Object wagesOld(HttpServletRequest request, HttpServletResponse response, HttpSession session, Model model, AdminTeacherWagesFormOld form) throws BusinessException, ParseException {
        BigDecimal totalMoney = new BigDecimal(0);
        PageObj pageObj = this.adminTeacherManageService.wagesOld(form);
        if (pageObj != null && pageObj.getPageElements() != null) {
            for (int i = 0; i < pageObj.getPageElements().size(); ++i) {
                AdminTeacherWagesResult wg = (AdminTeacherWagesResult)pageObj.getPageElements().get(i);
                if (wg.getMoney2() == null) continue;
                totalMoney = totalMoney.add(wg.getMoney2());
            }
        }
        if (StringUtils.isNotEmpty((String)form.getDoExport())) {
            ExportExcelParameter para = new ExportExcelParameter();
            ArrayList<AssignedCell[]> data = new ArrayList<AssignedCell[]>();
            try {
                para.setTemplateName("WEB-INF/template/\u6559\u5e08\u5de5\u8d44.xls");
                para.setDataRow(new AssignedCell(1, 0, (Object)""));
                para.setNeedCopyTemplateRow(true);
                para.setDataRowSpan(1);
                para.setTotalCol(10);
                if (null != pageObj) {
                    int i = 1;
                    int cs = 0;
                    for (Object tObj : pageObj.getPageElements()) {
                        AdminTeacherWagesResult dto = (AdminTeacherWagesResult)tObj;
                        BigDecimal b1 = dto.getMoney2();
                        if (b1 != null) {
                            b1.setScale(2);
                        }
                        AssignedCell[] row1 = new AssignedCell[]{new AssignedCell(0, 0, (Object)(dto.getFirstName() + " " + dto.getLastName()), cs), new AssignedCell(0, 1, (Object)b1.doubleValue(), cs)};
                        data.add(row1);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.adminExportService.exportExcelByTemplate(para, "\u6559\u5e08\u5de5\u8d44(" + form.getDate1() + "--" + form.getDate2() + ").xls", response, session, data);
        }
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        model.addAttribute("totalMoney", (Object)totalMoney);
        return "teacherWagesList";
    }

    @RequestMapping(value={"/wages"})
    public Object wageslist(HttpServletRequest request, HttpServletResponse response, HttpSession session, Model model, AdminTeacherWagesForm form) throws ParseException, IOException, TransformerException, ParserConfigurationException {
        if (null == form.getDate1()) {
            form.setDate1(DateUtils.addTimeByType((Date)new Date(), (int)2, (int)-1));
            model.addAttribute("form", (Object)form);
        }
        return "teacherWagesList2";
    }

    @RequestMapping(value={"/wages/list"})
    public Object wages(HttpServletRequest request, HttpServletResponse response, HttpSession session, Model model, AdminTeacherWagesForm form) throws ParseException, IOException, TransformerException, ParserConfigurationException {
        BigDecimal totalMoney = new BigDecimal(0);
        Date date1 = form.getDate1();
        if (StringUtils.isNotEmpty((String)form.getDoExport())) {
            form.setPageNo(null);
            form.setPageSize(null);
            if (null != form.getDate1()) {
                form.setDate2(DateUtils.getMonthEndDay((Date)form.getDate1()));
            }
            List pageElements = this.tTeacherDao.teacherWageList2(form);
            if (StringUtils.isNotEmpty((String)form.getDoExport()) && !CollectionUtils.isEmpty((Collection)pageElements)) {
                List<AdminTeacherWagesExportTemplate> exportTemplateList = this.adminTeacherWagesResult2ToAdminTeacherWagesExportTemplate(pageElements);
                String fileNamePrefix = date1 != null ? "\u6559\u5e08\u5de5\u8d44(" + DateUtils.formatDate((Date)date1, (String)"yyyy-MM") + ")" : "\u6559\u5e08\u5de5\u8d44";
                response.setContentType("application/form-data");
                String fileName = new String(fileNamePrefix.getBytes("utf-8"), "ISO8859-1");
                response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
                ExcelUtils.writeToExcel((OutputStream)response.getOutputStream(), AdminTeacherWagesExportTemplate.class, exportTemplateList);
            }
        } else {
            List pageElements;
            PageObj pageObj = this.adminTeacherManageService.wages(form);
            Integer pageNo = form.getPageNo();
            Integer lastPageNumber = pageObj.getLastPageNumber();
            AdminWagesCollectResult adminWagesCollectResult = null;
            if (pageNo != 0 && pageNo == lastPageNumber) {
                adminWagesCollectResult = new AdminWagesCollectResult();
                form.setPageNo(null);
                form.setPageSize(null);
                pageElements = this.tTeacherDao.teacherWageList2(form);
                if (!CollectionUtils.isEmpty((Collection)pageElements)) {
                    Double oneToOneClassTime = 0.0;
                    BigDecimal oneToOneMoney = BigDecimal.ZERO;
                    Double groupClassTime = 0.0;
                    BigDecimal groupMoney = BigDecimal.ZERO;
                    Double totalClassTime = 0.0;
                    BigDecimal shouldPayMoney = BigDecimal.ZERO;
                    BigDecimal actualPayMoney = BigDecimal.ZERO;
                    BigDecimal classIncome = BigDecimal.ZERO;
                    for (AdminTeacherWagesResult2 wg : pageElements) {
                        oneToOneClassTime = oneToOneClassTime + wg.getOneToOneClassTime();
                        oneToOneClassTime = BigDecimal.valueOf(oneToOneClassTime).setScale(2, RoundingMode.HALF_UP).doubleValue();
                        oneToOneMoney = oneToOneMoney.add(wg.getOneToOneMoney()).setScale(2, RoundingMode.HALF_UP);
                        groupClassTime = groupClassTime + wg.getGroupClassTime();
                        groupClassTime = BigDecimal.valueOf(groupClassTime).setScale(2, RoundingMode.HALF_UP).doubleValue();
                        groupMoney = groupMoney.add(wg.getGroupMoney()).setScale(2, RoundingMode.HALF_UP);
                        totalClassTime = totalClassTime + wg.getTotalClassTime();
                        totalClassTime = BigDecimal.valueOf(totalClassTime).setScale(2, RoundingMode.HALF_UP).doubleValue();
                        shouldPayMoney = shouldPayMoney.add(wg.getShouldPayMoney()).setScale(2, RoundingMode.HALF_UP);
                        actualPayMoney = actualPayMoney.add(wg.getActualPayMoney()).setScale(2, RoundingMode.HALF_UP);
                        classIncome = classIncome.add(wg.getClassIncome()).setScale(2, RoundingMode.HALF_UP);
                    }
                    adminWagesCollectResult.setOneToOneClassTime(oneToOneClassTime);
                    adminWagesCollectResult.setOneToOneMoney(oneToOneMoney);
                    adminWagesCollectResult.setGroupClassTime(groupClassTime);
                    adminWagesCollectResult.setGroupMoney(groupMoney);
                    adminWagesCollectResult.setTotalClassTime(totalClassTime);
                    adminWagesCollectResult.setShouldPayMoney(shouldPayMoney);
                    adminWagesCollectResult.setActualPayMoney(actualPayMoney);
                    adminWagesCollectResult.setClassIncome(classIncome);
                }
            }
            pageElements = pageObj.getPageElements();
            if (pageObj != null && pageElements != null) {
                for (int i = 0; i < pageElements.size(); ++i) {
                    AdminTeacherWagesResult2 wg = (AdminTeacherWagesResult2)pageElements.get(i);
                    if (wg.getShouldPayMoney() == null) continue;
                    totalMoney = totalMoney.add(wg.getShouldPayMoney());
                }
            }
            model.addAttribute("pageObj", (Object)pageObj);
            model.addAttribute("form", (Object)form);
            model.addAttribute("totalMoney", (Object)totalMoney);
            model.addAttribute("adminWagesCollectResult", (Object)adminWagesCollectResult);
        }
        return "teacherWagesList2";
    }

    private List<AdminTeacherWagesExportTemplate> adminTeacherWagesResult2ToAdminTeacherWagesExportTemplate(List<AdminTeacherWagesResult2> pageElements) {
        ArrayList<AdminTeacherWagesExportTemplate> exportTemplates = new ArrayList<AdminTeacherWagesExportTemplate>();
        AdminTeacherWagesExportTemplate exportTemplate = null;
        Double oneToOneClassTime = 0.0;
        BigDecimal oneToOneMoney = BigDecimal.ZERO;
        Double groupClassTime = 0.0;
        BigDecimal groupMoney = BigDecimal.ZERO;
        Double totalClassTime = 0.0;
        BigDecimal shouldPayMoney = BigDecimal.ZERO;
        BigDecimal actualPayMoney = BigDecimal.ZERO;
        BigDecimal classIncome = BigDecimal.ZERO;
        Iterator<AdminTeacherWagesResult2> iterator = pageElements.iterator();
        while (iterator.hasNext()) {
            AdminTeacherWagesResult2 pageElement;
            AdminTeacherWagesResult2 wg = pageElement = iterator.next();
            exportTemplate = new AdminTeacherWagesExportTemplate();
            exportTemplate.setTeacherName(wg.getFirstName() + " " + wg.getLastName());
            exportTemplate.setPaypalAccount(wg.getPaypalAccount());
            exportTemplate.setOneToOneClassTime(Double.valueOf(BigDecimal.valueOf(wg.getOneToOneClassTime()).setScale(2, RoundingMode.HALF_UP).doubleValue()));
            exportTemplate.setOneToOneMoney(wg.getOneToOneMoney().setScale(2, RoundingMode.HALF_UP));
            exportTemplate.setGroupClassTime(Double.valueOf(BigDecimal.valueOf(wg.getGroupClassTime()).setScale(2, RoundingMode.HALF_UP).doubleValue()));
            exportTemplate.setGroupMoney(wg.getGroupMoney().setScale(2, RoundingMode.HALF_UP));
            exportTemplate.setTotalClassTime(Double.valueOf(BigDecimal.valueOf(wg.getTotalClassTime()).setScale(2, RoundingMode.HALF_UP).doubleValue()));
            exportTemplate.setShouldPayMoney(wg.getShouldPayMoney().setScale(2, RoundingMode.HALF_UP));
            exportTemplate.setActualPayMoney(wg.getActualPayMoney().setScale(2, RoundingMode.HALF_UP));
            exportTemplate.setClassIncome(wg.getClassIncome().setScale(2, RoundingMode.HALF_UP));
            exportTemplate.setRemarks(wg.getRemarks());
            exportTemplates.add(exportTemplate);
            oneToOneClassTime = oneToOneClassTime + wg.getOneToOneClassTime();
            oneToOneClassTime = BigDecimal.valueOf(oneToOneClassTime).setScale(2, RoundingMode.HALF_UP).doubleValue();
            oneToOneMoney = oneToOneMoney.add(wg.getOneToOneMoney()).setScale(2, RoundingMode.HALF_UP);
            groupClassTime = groupClassTime + wg.getGroupClassTime();
            groupClassTime = BigDecimal.valueOf(groupClassTime).setScale(2, RoundingMode.HALF_UP).doubleValue();
            groupMoney = groupMoney.add(wg.getGroupMoney()).setScale(2, RoundingMode.HALF_UP);
            totalClassTime = totalClassTime + wg.getTotalClassTime();
            totalClassTime = BigDecimal.valueOf(totalClassTime).setScale(2, RoundingMode.HALF_UP).doubleValue();
            shouldPayMoney = shouldPayMoney.add(wg.getShouldPayMoney()).setScale(2, RoundingMode.HALF_UP);
            actualPayMoney = actualPayMoney.add(wg.getActualPayMoney()).setScale(2, RoundingMode.HALF_UP);
            classIncome = classIncome.add(wg.getClassIncome()).setScale(2, RoundingMode.HALF_UP);
        }
        exportTemplate = new AdminTeacherWagesExportTemplate();
        exportTemplate.setOneToOneClassTime(oneToOneClassTime);
        exportTemplate.setOneToOneMoney(oneToOneMoney);
        exportTemplate.setGroupClassTime(groupClassTime);
        exportTemplate.setGroupMoney(groupMoney);
        exportTemplate.setTotalClassTime(totalClassTime);
        exportTemplate.setShouldPayMoney(shouldPayMoney);
        exportTemplate.setActualPayMoney(actualPayMoney);
        exportTemplate.setClassIncome(classIncome);
        exportTemplates.add(exportTemplate);
        return exportTemplates;
    }

    @RequestMapping(value={"/teacherMonthIncomeRecord/addOrupdate"})
    @ResponseBody
    public Object teacherMonthIncomeRecordAddOrUpdate(HttpServletRequest request, AdminTeacherMonthIncomeRecordAddOrUpdateForm form) {
        UserDto user = (UserDto)request.getSession().getAttribute(TalkillaConstant.SESSION_ADMIN_LOGIN_PREFIX);
        ReturnMessageResult returnMessageResult = this.adminTeacherManageService.teacherMonthIncomeRecordAddOrUpdate(user, form);
        return returnMessageResult;
    }

    @RequestMapping(value={"/wages/detail/list"})
    public Object wagesDetailList(HttpServletRequest req, HttpServletResponse response, HttpSession session, Model model, AdminTeacherWagesForm form) throws ParseException, BusinessException, IOException {
        String teacherid = form.getTeacherid();
        TTeacher t = this.tTeacherDao.findOne(Integer.valueOf(teacherid));
        String des = t.getFirstName() + " " + t.getLastName();
        List wages = this.adminTeacherManageService.findWageDetailsByTeacherId(form);
        this.handelWages(wages);
        if (StringUtils.isNotEmpty((String)form.getDoExportDetail()) && !CollectionUtils.isEmpty((Collection)wages)) {
            List<AdminTeacherWagesDetailExportTemplate> exportTemplateList = this.adminTeacherWagesDetailListResult2ToAdminTeacherWagesDetailExportTemplate(wages);
            String fileNamePrefix = "\u6559\u5e08\u8be6\u7ec6\u5de5\u8d44(" + des + ")";
            response.setContentType("application/form-data");
            String fileName = new String(fileNamePrefix.getBytes("utf-8"), "ISO8859-1");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
            ExcelUtils.writeToExcel((OutputStream)response.getOutputStream(), AdminTeacherWagesDetailExportTemplate.class, exportTemplateList);
        }
        model.addAttribute("wages", (Object)wages);
        model.addAttribute("form", (Object)form);
        model.addAttribute("teacherInfo", (Object)t);
        return "teacherWagesDetail2";
    }

    private void handelWages(List<AdminTeacherWagesDetailListResult2> wages) {
        if (CollectionUtils.isEmpty(wages)) {
            return;
        }
        wages.stream().forEach(adminTeacherWagesDetailListResult -> {
            Integer type = adminTeacherWagesDetailListResult.getType();
            String stuName = adminTeacherWagesDetailListResult.getStuName();
            if (type.equals(100002)) {
                StringBuilder sb = new StringBuilder();
                String[] split = stuName.split(";");
                if (split.length > 0) {
                    for (String s1 : split) {
                        String[] split2 = s1.split("_");
                        if (split2.length <= 2) continue;
                        sb.append(split2[1]).append("/").append(split2[2]).append(";");
                    }
                    adminTeacherWagesDetailListResult.setStuName(sb.substring(0, sb.length() - 1));
                }
            }
        });
    }

    private List<AdminTeacherWagesDetailExportTemplate> adminTeacherWagesDetailListResult2ToAdminTeacherWagesDetailExportTemplate(List<AdminTeacherWagesDetailListResult2> wages) {
        ArrayList<AdminTeacherWagesDetailExportTemplate> templateList = new ArrayList<AdminTeacherWagesDetailExportTemplate>();
        AdminTeacherWagesDetailExportTemplate template = null;
        Double duration = 0.0;
        BigDecimal money = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        for (AdminTeacherWagesDetailListResult2 wage : wages) {
            template = new AdminTeacherWagesDetailExportTemplate();
            template.setClassid(wage.getClassid());
            template.setClassname(wage.getClassname());
            template.setType(TalkillaConstant.transferCourseType((Integer)wage.getType()));
            template.setStuName(wage.getStuName());
            template.setStarttime(DateUtils.formatDate((Date)wage.getStarttime(), (String)"yyyy-MM-dd HH:mm"));
            template.setDuration(Double.valueOf(BigDecimal.valueOf(wage.getDuration()).setScale(2, RoundingMode.HALF_UP).doubleValue()));
            template.setStatus(TalkillaConstant.transferCourseStatus((Integer)wage.getStatus()));
            template.setRate(wage.getRate().setScale(2, RoundingMode.HALF_UP));
            template.setMoney(wage.getMoney().setScale(2, RoundingMode.HALF_UP));
            template.setIspay(wage.getIspay() == 1 ? "\u662f" : "\u5426");
            template.setPrice(wage.getPrice().setScale(2, RoundingMode.HALF_UP));
            templateList.add(template);
            duration = duration + wage.getDuration();
            money = money.add(wage.getMoney());
            price = price.add(wage.getPrice());
        }
        template = new AdminTeacherWagesDetailExportTemplate();
        template.setDuration(Double.valueOf(BigDecimal.valueOf(duration).setScale(2, RoundingMode.HALF_UP).doubleValue()));
        template.setMoney(money.setScale(2, RoundingMode.HALF_UP));
        template.setPrice(price.setScale(2, RoundingMode.HALF_UP));
        templateList.add(template);
        return templateList;
    }

    @RequestMapping(value={"/wages/detail/list/v1"})
    @Deprecated
    public Object wagesDetailListOld(HttpServletRequest req, HttpServletResponse res, HttpSession session, Model model, AdminTeacherWagesFormOld form) throws ParseException, BusinessException {
        String teacherid = form.getTeacherid();
        String date1 = form.getDate1();
        String date2 = "";
        if (StringUtils.isNotBlank((String)date1)) {
            date2 = DateUtils.getMonthEndDay((String)date1);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date start = null;
        Date end = null;
        if (StringUtil.isNotEmpty((String)date1) && StringUtil.isNotEmpty((String)date2)) {
            form.setDate1(date1);
            form.setDate2(date2);
            start = sdf.parse(date1);
            end = DateUtils.parseDateToSecond((String)date2);
            if (end != null) {
                end = NoServiceUtil.correctDate((Date)end);
            }
        }
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy\u5e74MM\u6708");
        TTeacher t = this.tTeacherDao.findOne(Integer.valueOf(teacherid));
        String des = (StringUtil.isEmpty((String)form.getDate1()) ? "" : sdf2.format(start)) + "  " + t.getFirstName() + " " + t.getLastName();
        List wages = this.adminTeacherManageService.findWageDetailsByTeacherIdOld(form);
        if (StringUtils.isNotEmpty((String)form.getDoExportDetail())) {
            ExportExcelParameter para = new ExportExcelParameter();
            ArrayList<AssignedCell[]> data = new ArrayList<AssignedCell[]>();
            try {
                para.setTemplateName("WEB-INF/template/\u6559\u5e08\u8be6\u7ec6\u5de5\u8d44.xls");
                para.setDataRow(new AssignedCell(1, 0, (Object)""));
                para.setNeedCopyTemplateRow(true);
                para.setDataRowSpan(1);
                para.setTotalCol(10);
                SimpleDateFormat sdfm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                if (null != wages) {
                    int i = 1;
                    int cs = 0;
                    for (Object tObj : wages) {
                        AdminTeacherWagesDetailListResult dto = (AdminTeacherWagesDetailListResult)tObj;
                        BigDecimal b1 = dto.getMoney();
                        if (b1 != null) {
                            b1.setScale(2);
                        }
                        AssignedCell[] row1 = new AssignedCell[]{new AssignedCell(0, 0, (Object)dto.getClassid(), cs), new AssignedCell(0, 1, (Object)dto.getClassname(), cs), new AssignedCell(0, 2, (Object)sdfm.format(dto.getStarttime()), cs), new AssignedCell(0, 3, (Object)dto.getDuration(), cs), new AssignedCell(0, 4, (Object)this.initDictionUtil.getDictNameByDictId(dto.getStatus() + ""), cs), new AssignedCell(0, 5, (Object)dto.getZname(), cs), new AssignedCell(0, 6, (Object)b1.doubleValue(), cs)};
                        data.add(row1);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.adminExportService.exportExcelByTemplate(para, "\u6559\u5e08\u8be6\u7ec6\u5de5\u8d44(" + des + ").xls", res, session, data);
        }
        model.addAttribute("wages", (Object)wages);
        model.addAttribute("form", (Object)form);
        model.addAttribute("des", (Object)des);
        return "teacherWagesDetail";
    }

    @RequestMapping(value={"/list"})
    public String list(HttpServletRequest request, Model model, AdminTeacherListForm form) {
        if (StringUtils.isNotBlank((String)form.getDoExport())) {
            return "forward:/teacher/manage/list/export";
        }
        PageObj pageObj = this.adminTeacherManageService.getTeacherList(form);
        List list = this.tNationService.findAll();
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        model.addAttribute("list", (Object)list);
        List fenleiList = this.tSysdictService.findTeacherFenlei();
        model.addAttribute("fenleiList", (Object)fenleiList);
        return "teacherList";
    }

    @RequestMapping(value={"/dingji"})
    public Object toDingjiPage(HttpServletRequest request, Model model, AdminTeacherFenleiForm form) {
        TTeacher instance = this.tTeacherService.findOne(form.getTeacherid());
        model.addAttribute("instance", (Object)instance);
        List foreignServiceList = this.tForeignServiceService.getForeignServiceList();
        model.addAttribute("foreignServiceList", (Object)foreignServiceList);
        return "teacherFenlei";
    }

    @RequestMapping(value={"/dingji/save"})
    public Object dingjiSave(HttpServletRequest request, Model model, AdminTeacherFenleiSaveForm form) {
        this.adminTeacherManageService.dingjiSave(form);
        model.addAttribute("message", (Object)"\u4fee\u6539\u6210\u529f");
        return "redirect:/teacher/manage/list";
    }

    @RequestMapping(value={"/dingji/delete"})
    @ResponseBody
    public Object dingjiDelete(HttpServletRequest request, Model model, @RequestParam(value="teacherId") Integer teacherId) {
        return this.adminTeacherManageService.dingjiDelete(teacherId);
    }

    @RequestMapping(value={"/edit"})
    public Object edit(HttpServletRequest request, Model model, @RequestParam(value="teacherid") Integer teacherid) {
        List nations = this.tNationService.findAll();
        model.addAttribute("nations", (Object)nations);
        List zones = this.tTimezoneService.findAllStr();
        model.addAttribute("zones", (Object)zones);
        TTeacher instance = this.tTeacherService.findOne(teacherid);
        model.addAttribute("teacher", (Object)instance);
        List foreignServiceList = this.tForeignServiceService.getForeignServiceList();
        model.addAttribute("foreignServiceList", (Object)foreignServiceList);
        return "teacherEdit";
    }

    @RequestMapping(value={"/edit/save"})
    public Object editSave(HttpServletRequest request, Model model, AdminTeacherManageEditSaveForm form, @RequestParam(value="fileItem") MultipartFile fileItem) {
        this.adminTeacherManageService.editSave(form, fileItem);
        model.addAttribute("message", (Object)"\u4fee\u6539\u6210\u529f");
        return "redirect:/teacher/manage/list";
    }

    @RequestMapping(value={"/bonus"})
    public Object bonus(HttpServletRequest request, Model model, @RequestParam(value="teacherId") Integer teacherId) {
        TTeacher instance = this.tTeacherService.findOne(teacherId);
        instance.setBirthday(new Date());
        model.addAttribute("instance", (Object)instance);
        return "teacherAddBonus";
    }

    @RequestMapping(value={"/bonus/save"})
    public Object bonusSave(HttpServletRequest request, HttpSession session, Model model, AdminTeacherAddBonusForm form) throws BusinessException, DateParseException {
        ReturnMessageResult result = this.tTeacherService.addTeacherBonus(form);
        model.addAttribute("message", (Object)result.getMessage());
        TTeacher instance = this.tTeacherService.findOne(form.getTeacherId());
        instance.setBirthday(new Date());
        model.addAttribute("instance", (Object)instance);
        if (result.getFlag() == 0) {
            return "forward:/teacher/manage/list";
        }
        return "forward:/teacher/manage//bonus";
    }

    @RequestMapping(value={"/list/export"})
    public Object listExport(HttpServletRequest request, HttpServletResponse response, HttpSession session, Model model, AdminTeacherListForm form) throws BusinessException {
        form.setPageSize(Integer.valueOf(1000));
        PageObj pageObj = this.adminTeacherManageService.getTeacherList(form);
        ExportExcelParameter para = new ExportExcelParameter();
        ArrayList<AssignedCell[]> data = new ArrayList<AssignedCell[]>();
        try {
            para.setTemplateName("WEB-INF/template/\u6559\u5e08\u7edf\u8ba1.xls");
            para.setDataRow(new AssignedCell(1, 0, (Object)""));
            para.setNeedCopyTemplateRow(true);
            para.setDataRowSpan(1);
            para.setTotalCol(10);
            if (null != pageObj) {
                int i = 1;
                int cs = 0;
                for (Object tObj : pageObj.getPageElements()) {
                    TeacherManagementActionQueryDto dto = (TeacherManagementActionQueryDto)tObj;
                    AssignedCell[] row1 = new AssignedCell[]{new AssignedCell(0, 0, (Object)(dto.getFirstName() + " " + dto.getLastName()), cs), new AssignedCell(0, 1, (Object)dto.getLoginname(), cs), new AssignedCell(0, 2, (Object)dto.getSkypeid(), cs), new AssignedCell(0, 3, (Object)dto.getOnetoone(), cs), new AssignedCell(0, 4, (Object)dto.getOnetomany(), cs), new AssignedCell(0, 5, (Object)dto.getPaypalaccount(), cs), new AssignedCell(0, 6, (Object)dto.getTimezone(), cs), new AssignedCell(0, 7, (Object)dto.getCountrystr(), cs)};
                    data.add(row1);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.adminExportService.exportExcelByTemplate(para, "\u6559\u5e08\u7edf\u8ba1.xls", response, session, data);
    }

    @RequestMapping(value={"/teacher/info"})
    public Object teacherEditInfo(HttpServletRequest request, HttpServletResponse response, HttpSession session, Model model, Integer id) throws BusinessException {
        TTeacher tTeacher = this.adminTeacherManageService.teacherEditInfo(id);
        model.addAttribute("teacher", (Object)tTeacher);
        return "teacherInfo";
    }

    @RequestMapping(value={"/teaching/record/list"})
    public Object teachingRecordList(HttpServletRequest request, HttpServletResponse response, HttpSession session, Model model, AdminTeachingRecordsForm form) throws BusinessException {
        PageObj pageObj = this.adminTeacherManageService.teachingRecordList(form);
        List list = pageObj.getPageElements();
        for (Object obj : list) {
            if (!(obj instanceof AdminTeachingRecordListResult)) continue;
            AdminTeachingRecordListResult result = (AdminTeachingRecordListResult)obj;
            String stuname = result.getStuname().replaceAll("^[0-9]+_", "");
            stuname = stuname.replaceAll(",", ";");
            stuname = stuname.replaceAll(";[0-9]+_", ";");
            stuname = stuname.replaceAll("_", "/");
            result.setStuname(stuname);
            String[] stunamearr = stuname.split(";");
            ArrayList stunames = Lists.newArrayList();
            for (String name : stunamearr) {
                if (StringUtils.isBlank((String)name)) continue;
                stunames.add(name);
            }
            result.setStunames((List)stunames);
        }
        if (StringUtils.isNotEmpty((String)form.getDoExport())) {
            ExportExcelParameter para = new ExportExcelParameter();
            ArrayList<AssignedCell[]> data = new ArrayList<AssignedCell[]>();
            try {
                para.setTemplateName("WEB-INF/template/\u4e0a\u8bfe\u8bb0\u5f55\u67e5\u8be2.xls");
                para.setDataRow(new AssignedCell(1, 0, (Object)""));
                para.setNeedCopyTemplateRow(true);
                para.setDataRowSpan(1);
                para.setTotalCol(10);
                SimpleDateFormat z = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (null != pageObj.getPageElements()) {
                    int i = 1;
                    int cs = 0;
                    for (Object tObj : pageObj.getPageElements()) {
                        AdminTeachingRecordListResult dto = (AdminTeachingRecordListResult)tObj;
                        AssignedCell[] row1 = new AssignedCell[]{new AssignedCell(0, 0, (Object)dto.getClassid(), cs), new AssignedCell(0, 1, (Object)dto.getClassname(), cs), new AssignedCell(0, 2, (Object)dto.getTeachername(), cs), new AssignedCell(0, 3, (Object)TalkillaConstant.transferCourseTypeEnglish((Integer)dto.getType()), cs), new AssignedCell(0, 4, (Object)(dto.getStarttime() != null ? z.format(dto.getStarttime()) : ""), cs), new AssignedCell(0, 5, (Object)TalkillaConstant.transferCourseStatusEnglish((Integer)dto.getStatus()), cs), new AssignedCell(0, 6, (Object)dto.getComments(), cs), new AssignedCell(0, 7, (Object)dto.getFeedbacks(), cs), new AssignedCell(0, 8, (Object)dto.getStunames(), cs), new AssignedCell(0, 9, (Object)dto.getNote(), cs)};
                        data.add(row1);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.adminExportService.exportExcelByTemplate(para, "\u4e0a\u8bfe\u8bb0\u5f55\u67e5\u8be2.xls", response, session, data);
        }
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        return "teachingRecordList";
    }

    @RequestMapping(value={"/teaching/record/edit"})
    public String teachingRecordEdit(HttpServletRequest request, Model model, Integer sessionid) {
        AdminTeachingRecordEditResult result = this.adminTeacherManageService.teachingRecordEdit(sessionid);
        model.addAttribute("instance", (Object)result);
        return "teachingrecordToModify";
    }

    @RequestMapping(value={"/teaching/record/edit/save"})
    public Object teachingRecordEditSave(HttpServletRequest request, Model model, AdminTeachingRecordEditSaveForm form) throws ParseException {
        UserDto user = (UserDto)request.getSession().getAttribute(TalkillaConstant.SESSION_ADMIN_LOGIN_PREFIX);
        form.setLoginId(user.getLoginId());
        ReturnMessageResult messageResult = this.adminTeacherManageService.teachingRecordEditSave(form);
        model.addAttribute("message", (Object)messageResult.getMessage());
        return "redirect:/teacher/manage/teaching/record/list";
    }

    @RequestMapping(value={"/teaching/record/edit/recover"})
    @ResponseBody
    public String teachingRecordEditRecover(HttpServletRequest request, Model model, AdminTeachingRecordEditRecoverForm form) throws ParseException {
        UserDto user = (UserDto)request.getSession().getAttribute(TalkillaConstant.SESSION_ADMIN_LOGIN_PREFIX);
        form.setLoginId(user.getLoginId());
        ReturnMessageResult messageResult = this.adminTeacherManageService.teachingRecordEditRecover(form);
        return messageResult.getMessage();
    }
}

