/*
 * Decompiled with CFR 0.152.
 */
package com.talkilla.controller;

import com.talkilla.exception.BusinessException;
import com.talkilla.form.admin.AdminMechanismAdminForm;
import com.talkilla.form.admin.AdminMechanismEditForm;
import com.talkilla.form.admin.AdminMechanismListForm;
import com.talkilla.form.admin.AdminWagesDetailListForm;
import com.talkilla.form.admin.AdminWagesListForm;
import com.talkilla.mysql.domain.TForeignService;
import com.talkilla.otherbean.AssignedCell;
import com.talkilla.otherbean.ExportExcelParameter;
import com.talkilla.otherbean.WageDto;
import com.talkilla.result.ReturnMessageResult;
import com.talkilla.result.admin.base.PageObj;
import com.talkilla.service.TForeignServiceService;
import com.talkilla.service.admin.AdminExportService;
import com.talkilla.service.admin.AdminForeignTeachersMechanismService;
import com.talkilla.service.impl.InitDictionUtil;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.omg.CORBA.portable.ApplicationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/foreign/service"})
public class AdminForeignTeachersMechanismController {
    @Autowired
    private AdminForeignTeachersMechanismService adminForeignTeachersMechanismService;
    @Autowired
    private AdminExportService adminExportService;
    @Autowired
    private InitDictionUtil initDictionUtil;
    @Autowired
    private TForeignServiceService tForeignServiceService;

    @RequestMapping(value={"/mechanism/list"})
    public String mechanismList(HttpServletRequest request, Model model, AdminMechanismListForm form) {
        PageObj pageObj = this.adminForeignTeachersMechanismService.mechanismList(form);
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        return "foreignServiceList";
    }

    @RequestMapping(value={"/mechanism/edit"})
    public String mechanismDetail(HttpServletRequest request, Model model, Integer id) {
        TForeignService tForeignService = this.adminForeignTeachersMechanismService.mechanismDetail(id);
        model.addAttribute("foreignService", (Object)tForeignService);
        return "foreignServiceEdit";
    }

    @RequestMapping(value={"/mechanism/edit/save"})
    @ResponseBody
    public Object mechanismEdit(HttpServletRequest request, Model model, AdminMechanismEditForm form) throws IllegalAccessException, ApplicationException, InvocationTargetException {
        ReturnMessageResult messageResult = this.adminForeignTeachersMechanismService.mechanismEdit(form);
        return messageResult;
    }

    @RequestMapping(value={"/mechanism/add"})
    public Object mechanismAdd() {
        return "foreignServiceAdd";
    }

    @RequestMapping(value={"/mechanism/add/save"})
    @ResponseBody
    public Object mechanismAddSave(HttpServletRequest request, Model model, AdminMechanismAdminForm form) {
        ReturnMessageResult messageResult = this.adminForeignTeachersMechanismService.mechanismAddSave(form);
        return messageResult;
    }

    @RequestMapping(value={"/wages/list"})
    public Object wagesList(HttpServletRequest request, HttpServletResponse response, HttpSession session, Model model, AdminWagesListForm form) throws BusinessException {
        PageObj pageObj = this.adminForeignTeachersMechanismService.wagesList(form);
        if (StringUtils.isNotEmpty((String)form.getDoExport())) {
            ExportExcelParameter para = new ExportExcelParameter();
            ArrayList<AssignedCell[]> data = new ArrayList<AssignedCell[]>();
            try {
                para.setTemplateName("WEB-INF/template/\u5916\u6559\u673a\u6784\u8d39\u7528.xls");
                para.setDataRow(new AssignedCell(1, 0, (Object)""));
                para.setNeedCopyTemplateRow(true);
                para.setDataRowSpan(1);
                para.setTotalCol(10);
                if (null != pageObj) {
                    int i = 1;
                    int cs = 0;
                    for (Object tObj : pageObj.getPageElements()) {
                        WageDto dto = (WageDto)tObj;
                        BigDecimal b1 = dto.getMoney();
                        if (b1 != null) {
                            b1.setScale(2);
                        }
                        AssignedCell[] row1 = new AssignedCell[]{new AssignedCell(0, 0, (Object)dto.getName(), cs), new AssignedCell(0, 1, (Object)b1.doubleValue(), cs)};
                        data.add(row1);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.adminExportService.exportExcelByTemplate(para, "\u5916\u6559\u673a\u6784\u8d39\u7528(" + form.getDate1() + "--" + form.getDate2() + ").xls", response, session, data);
        }
        model.addAttribute("pageObj", (Object)pageObj);
        model.addAttribute("form", (Object)form);
        return "foreignServiceWagesList";
    }

    @RequestMapping(value={"/wages/detail/list"})
    public Object wagesDetailList(HttpServletRequest request, HttpServletResponse response, HttpSession session, Model model, AdminWagesDetailListForm form) throws BusinessException {
        List results = this.adminForeignTeachersMechanismService.wagesDetailList(form);
        if (StringUtils.isNotEmpty((String)form.getDoExportDetail())) {
            ExportExcelParameter para = new ExportExcelParameter();
            ArrayList<AssignedCell[]> data = new ArrayList<AssignedCell[]>();
            try {
                para.setTemplateName("WEB-INF/template/\u5916\u6559\u673a\u6784\u8d39\u7528\u8be6\u7ec6.xls");
                para.setDataRow(new AssignedCell(1, 0, (Object)""));
                para.setNeedCopyTemplateRow(true);
                para.setDataRowSpan(1);
                para.setTotalCol(10);
                SimpleDateFormat sdfm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                if (null != results) {
                    int i = 1;
                    int cs = 0;
                    for (Object tObj : results) {
                        WageDto dto = (WageDto)tObj;
                        BigDecimal b1 = dto.getManagementCost();
                        if (b1 != null) {
                            b1.setScale(2);
                        }
                        AssignedCell[] row1 = new AssignedCell[]{new AssignedCell(0, 0, (Object)dto.getClassid(), cs), new AssignedCell(0, 1, (Object)dto.getClassname(), cs), new AssignedCell(0, 2, (Object)sdfm.format(dto.getSessiontime()), cs), new AssignedCell(0, 3, (Object)dto.getDuration(), cs), new AssignedCell(0, 4, (Object)this.initDictionUtil.getDictNameByDictId(dto.getStatus() + ""), cs), new AssignedCell(0, 5, (Object)dto.getStuNames(), cs), new AssignedCell(0, 6, (Object)b1.doubleValue(), cs), new AssignedCell(0, 7, (Object)dto.getTeachername(), cs)};
                        data.add(row1);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TForeignService tForeignService = this.tForeignServiceService.findOne(form.getForeignServiceId());
            return this.adminExportService.exportExcelByTemplate(para, "\u5916\u6559\u673a\u6784  " + tForeignService.getName() + " \u8d39\u7528\u8be6\u7ec6.xls", response, session, data);
        }
        model.addAttribute("results", (Object)results);
        return "foreignServiceWagesDetailList";
    }
}

