/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.xpath.XPathException;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.Selector;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDAbstractIDConstraintTraverser
extends XSDAbstractTraverser {
    public XSDAbstractIDConstraintTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    boolean traverseIdentityConstraint(IdentityConstraint ic, Element icElem, XSDocumentInfo schemaDoc, Object[] icElemAttrs) {
        String sText;
        Element sElem = DOMUtil.getFirstChildElement(icElem);
        if (sElem == null) {
            this.reportSchemaError("s4s-elt-must-match.2", new Object[]{"identity constraint", "(annotation?, selector, field+)"}, icElem);
            return false;
        }
        if (DOMUtil.getLocalName(sElem).equals(SchemaSymbols.ELT_ANNOTATION)) {
            ic.addAnnotation(this.traverseAnnotationDecl(sElem, icElemAttrs, false, schemaDoc));
            sElem = DOMUtil.getNextSiblingElement(sElem);
            if (sElem == null) {
                this.reportSchemaError("s4s-elt-must-match.2", new Object[]{"identity constraint", "(annotation?, selector, field+)"}, icElem);
                return false;
            }
        } else {
            String text = DOMUtil.getSyntheticAnnotation(icElem);
            if (text != null) {
                ic.addAnnotation(this.traverseSyntheticAnnotation(icElem, text, icElemAttrs, false, schemaDoc));
            }
        }
        if (!DOMUtil.getLocalName(sElem).equals(SchemaSymbols.ELT_SELECTOR)) {
            this.reportSchemaError("s4s-elt-must-match.1", new Object[]{"identity constraint", "(annotation?, selector, field+)", SchemaSymbols.ELT_SELECTOR}, sElem);
            return false;
        }
        Object[] attrValues = this.fAttrChecker.checkAttributes(sElem, false, schemaDoc);
        Element selChild = DOMUtil.getFirstChildElement(sElem);
        if (selChild != null) {
            if (DOMUtil.getLocalName(selChild).equals(SchemaSymbols.ELT_ANNOTATION)) {
                ic.addAnnotation(this.traverseAnnotationDecl(selChild, attrValues, false, schemaDoc));
                selChild = DOMUtil.getNextSiblingElement(selChild);
            } else {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_SELECTOR, "(annotation?)", DOMUtil.getLocalName(selChild)}, selChild);
            }
            if (selChild != null) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_SELECTOR, "(annotation?)", DOMUtil.getLocalName(selChild)}, selChild);
            }
        } else {
            String text = DOMUtil.getSyntheticAnnotation(sElem);
            if (text != null) {
                ic.addAnnotation(this.traverseSyntheticAnnotation(icElem, text, attrValues, false, schemaDoc));
            }
        }
        if ((sText = (String)attrValues[XSAttributeChecker.ATTIDX_XPATH]) == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_SELECTOR, SchemaSymbols.ATT_XPATH}, sElem);
            return false;
        }
        sText = XMLChar.trim(sText);
        Selector.XPath sXpath = null;
        try {
            sXpath = new Selector.XPath(sText, this.fSymbolTable, schemaDoc.fNamespaceSupport);
            Selector selector = new Selector(sXpath, ic, this.getXPathDefaultNamespace(attrValues, schemaDoc));
            ic.setSelector(selector);
        }
        catch (XPathException e) {
            this.reportSchemaError(e.getKey(), new Object[]{sText}, sElem);
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return false;
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        Element fElem = DOMUtil.getNextSiblingElement(sElem);
        if (fElem == null) {
            this.reportSchemaError("s4s-elt-must-match.2", new Object[]{"identity constraint", "(annotation?, selector, field+)"}, sElem);
            return false;
        }
        while (fElem != null) {
            if (!DOMUtil.getLocalName(fElem).equals(SchemaSymbols.ELT_FIELD)) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{"identity constraint", "(annotation?, selector, field+)", SchemaSymbols.ELT_FIELD}, fElem);
                fElem = DOMUtil.getNextSiblingElement(fElem);
                continue;
            }
            attrValues = this.fAttrChecker.checkAttributes(fElem, false, schemaDoc);
            Element fieldChild = DOMUtil.getFirstChildElement(fElem);
            if (fieldChild != null && DOMUtil.getLocalName(fieldChild).equals(SchemaSymbols.ELT_ANNOTATION)) {
                ic.addAnnotation(this.traverseAnnotationDecl(fieldChild, attrValues, false, schemaDoc));
                fieldChild = DOMUtil.getNextSiblingElement(fieldChild);
            }
            if (fieldChild != null) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_FIELD, "(annotation?)", DOMUtil.getLocalName(fieldChild)}, fieldChild);
            } else {
                String text = DOMUtil.getSyntheticAnnotation(fElem);
                if (text != null) {
                    ic.addAnnotation(this.traverseSyntheticAnnotation(icElem, text, attrValues, false, schemaDoc));
                }
            }
            String fText = (String)attrValues[XSAttributeChecker.ATTIDX_XPATH];
            if (fText == null) {
                this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_FIELD, SchemaSymbols.ATT_XPATH}, fElem);
                this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
                return false;
            }
            fText = XMLChar.trim(fText);
            try {
                Field.XPath fXpath = new Field.XPath(fText, this.fSymbolTable, schemaDoc.fNamespaceSupport);
                Field field = new Field(fXpath, ic, this.getXPathDefaultNamespace(attrValues, schemaDoc));
                ic.addField(field);
            }
            catch (XPathException e) {
                this.reportSchemaError(e.getKey(), new Object[]{fText}, fElem);
                this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
                return false;
            }
            fElem = DOMUtil.getNextSiblingElement(fElem);
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        }
        return ic.getFieldCount() > 0;
    }

    private String getXPathDefaultNamespace(Object[] attrValues, XSDocumentInfo schemaDoc) {
        String xpathDefaultNamespace = (String)attrValues[XSAttributeChecker.ATTIDX_XPATHDEFAULTNS];
        if (xpathDefaultNamespace == null) {
            xpathDefaultNamespace = schemaDoc.fXpathDefaultNamespace;
        }
        return xpathDefaultNamespace;
    }

    void traverseIdentityConstraintReferral(Element icElem, XSElementDecl element, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(icElem, false, schemaDoc);
        QName referredIcQName = (QName)attrValues[XSAttributeChecker.ATTIDX_REF];
        IdentityConstraint referredIc = (IdentityConstraint)this.fSchemaHandler.getGlobalDecl(schemaDoc, 5, referredIcQName, icElem);
        if (referredIc == null) {
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return;
        }
        String icCategoryName = DOMUtil.getLocalName(icElem);
        short referralIcCategory = icCategoryName.equals(SchemaSymbols.ELT_UNIQUE) ? (short)3 : (icCategoryName.equals(SchemaSymbols.ELT_KEY) ? (short)1 : 2);
        if (referredIc.getCategory() != referralIcCategory) {
            this.reportSchemaError("src-identity-constraint.5", new Object[]{DOMUtil.getLocalName(icElem)}, icElem);
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return;
        }
        Element annoElem = DOMUtil.getFirstChildElement(icElem);
        if (annoElem != null) {
            if (!DOMUtil.getLocalName(annoElem).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{icElem.getLocalName(), "(annotation?)", DOMUtil.getLocalName(annoElem)}, annoElem);
                return;
            }
            element.addAnnotation(this.traverseAnnotationDecl(annoElem, attrValues, false, schemaDoc));
            annoElem = DOMUtil.getNextSiblingElement(annoElem);
            if (annoElem != null) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{icElem.getLocalName(), "(annotation?)", DOMUtil.getLocalName(annoElem)}, annoElem);
                return;
            }
        } else {
            String text = DOMUtil.getSyntheticAnnotation(icElem);
            if (text != null) {
                element.addAnnotation(this.traverseSyntheticAnnotation(icElem, text, attrValues, false, schemaDoc));
            }
        }
        grammar.addIDConstraintDecl(element, referredIc);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
    }
}

