/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.SocketConfigurators;
import com.rabbitmq.client.SslEngineConfigurator;
import java.io.IOException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public abstract class SslEngineConfigurators {
    public static AbstractSslEngineConfigurator DEFAULT = new AbstractSslEngineConfigurator(){

        @Override
        public void configure(SSLEngine sslEngine) {
        }
    };
    public static AbstractSslEngineConfigurator ENABLE_HOSTNAME_VERIFICATION = new AbstractSslEngineConfigurator(){

        @Override
        public void configure(SSLEngine sslEngine) throws IOException {
            SSLParameters sslParameters = SocketConfigurators.enableHostnameVerification(sslEngine.getSSLParameters());
            sslEngine.setSSLParameters(sslParameters);
        }
    };

    public static AbstractSslEngineConfigurator defaultConfigurator() {
        return DEFAULT;
    }

    public static AbstractSslEngineConfigurator enableHostnameVerification() {
        return ENABLE_HOSTNAME_VERIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AbstractSslEngineConfigurator configurator = new AbstractSslEngineConfigurator(){

            @Override
            public void configure(SSLEngine channel) {
            }
        };

        public Builder defaultConfigurator() {
            this.configurator = this.configurator.andThen(DEFAULT);
            return this;
        }

        public Builder enableHostnameVerification() {
            this.configurator = this.configurator.andThen(ENABLE_HOSTNAME_VERIFICATION);
            return this;
        }

        public Builder add(SslEngineConfigurator extraConfiguration) {
            this.configurator = this.configurator.andThen(extraConfiguration);
            return this;
        }

        public SslEngineConfigurator build() {
            return this.configurator;
        }
    }

    public static abstract class AbstractSslEngineConfigurator
    implements SslEngineConfigurator {
        public AbstractSslEngineConfigurator andThen(final SslEngineConfigurator after) {
            if (after == null) {
                throw new NullPointerException();
            }
            return new AbstractSslEngineConfigurator(){

                @Override
                public void configure(SSLEngine t) throws IOException {
                    AbstractSslEngineConfigurator.this.configure(t);
                    after.configure(t);
                }
            };
        }
    }
}

