/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.util;

import com.google.gson.annotations.SerializedName;
import com.qiniu.http.Headers;
import com.qiniu.util.Json;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import com.qiniu.util.UrlSafeBase64;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class Auth {
    public static final String DTOKEN_ACTION_VOD = "linking:vod";
    public static final String DTOKEN_ACTION_STATUS = "linking:status";
    public static final String DTOKEN_ACTION_TUTK = "linking:tutk";
    private static final String[] policyFields = new String[]{"callbackUrl", "callbackBody", "callbackHost", "callbackBodyType", "callbackFetchKey", "returnUrl", "returnBody", "endUser", "saveKey", "insertOnly", "isPrefixalScope", "detectMime", "mimeLimit", "fsizeLimit", "fsizeMin", "persistentOps", "persistentNotifyUrl", "persistentPipeline", "deleteAfterDays", "fileType"};
    private static final String[] deprecatedPolicyFields = new String[]{"asyncOps"};
    private static boolean[] isTokenTable = Auth.genTokenTable();
    private static int toLower = 32;
    public final String accessKey;
    private final SecretKeySpec secretKey;

    private Auth(String accessKey, SecretKeySpec secretKeySpec) {
        this.accessKey = accessKey;
        this.secretKey = secretKeySpec;
    }

    public static Auth create(String accessKey, String secretKey) {
        if (StringUtils.isNullOrEmpty(accessKey) || StringUtils.isNullOrEmpty(secretKey)) {
            throw new IllegalArgumentException("empty key");
        }
        byte[] sk = StringUtils.utf8Bytes(secretKey);
        SecretKeySpec secretKeySpec = new SecretKeySpec(sk, "HmacSHA1");
        return new Auth(accessKey, secretKeySpec);
    }

    private static void copyPolicy(final StringMap policy, StringMap originPolicy, final boolean strict) {
        if (originPolicy == null) {
            return;
        }
        originPolicy.forEach(new StringMap.Consumer(){

            @Override
            public void accept(String key, Object value) {
                if (StringUtils.inStringArray(key, deprecatedPolicyFields)) {
                    throw new IllegalArgumentException(key + " is deprecated!");
                }
                if (!strict || StringUtils.inStringArray(key, policyFields)) {
                    policy.put(key, value);
                }
            }
        });
    }

    private static String canonicalMIMEHeaderKey(String name) {
        byte[] a = name.getBytes(Charset.forName("UTF-8"));
        for (int i = 0; i < a.length; ++i) {
            byte c = a[i];
            if (Auth.validHeaderFieldByte(c)) continue;
            return name;
        }
        boolean upper = true;
        for (int i = 0; i < a.length; ++i) {
            byte c = a[i];
            if (upper && 97 <= c && c <= 122) {
                c = (byte)(c - toLower);
            } else if (!upper && 65 <= c && c <= 90) {
                c = (byte)(c + toLower);
            }
            a[i] = c;
            upper = c == 45;
        }
        return new String(a);
    }

    private static boolean validHeaderFieldByte(byte b) {
        return 0 < b && b < isTokenTable.length && isTokenTable[b];
    }

    private static boolean[] genTokenTable() {
        int[] idx = new int[]{33, 35, 36, 37, 38, 39, 42, 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 87, 86, 88, 89, 90, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 124, 126};
        boolean[] tokenTable = new boolean[127];
        Arrays.fill(tokenTable, false);
        for (int i : idx) {
            tokenTable[i] = true;
        }
        return tokenTable;
    }

    private Mac createMac() {
        Mac mac;
        try {
            mac = Mac.getInstance("HmacSHA1");
            mac.init(this.secretKey);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
        return mac;
    }

    @Deprecated
    public String sign(byte[] data) {
        Mac mac = this.createMac();
        String encodedSign = UrlSafeBase64.encodeToString(mac.doFinal(data));
        return this.accessKey + ":" + encodedSign;
    }

    @Deprecated
    public String sign(String data) {
        return this.sign(StringUtils.utf8Bytes(data));
    }

    @Deprecated
    public String signWithData(byte[] data) {
        String s = UrlSafeBase64.encodeToString(data);
        return this.sign(StringUtils.utf8Bytes(s)) + ":" + s;
    }

    @Deprecated
    public String signWithData(String data) {
        return this.signWithData(StringUtils.utf8Bytes(data));
    }

    @Deprecated
    public String signRequest(String urlString, byte[] body, String contentType) {
        URI uri = URI.create(urlString);
        String path = uri.getRawPath();
        String query = uri.getRawQuery();
        Mac mac = this.createMac();
        mac.update(StringUtils.utf8Bytes(path));
        if (query != null && query.length() != 0) {
            mac.update((byte)63);
            mac.update(StringUtils.utf8Bytes(query));
        }
        mac.update((byte)10);
        if (body != null && "application/x-www-form-urlencoded".equalsIgnoreCase(contentType)) {
            mac.update(body);
        }
        String digest = UrlSafeBase64.encodeToString(mac.doFinal());
        return this.accessKey + ":" + digest;
    }

    public boolean isValidCallback(String originAuthorization, String url, byte[] body, String contentType) {
        String authorization = "QBox " + this.signRequest(url, body, contentType);
        return authorization.equals(originAuthorization);
    }

    public String privateDownloadUrl(String baseUrl) {
        return this.privateDownloadUrl(baseUrl, 3600L);
    }

    public String privateDownloadUrl(String baseUrl, long expires) {
        long deadline = System.currentTimeMillis() / 1000L + expires;
        return this.privateDownloadUrlWithDeadline(baseUrl, deadline);
    }

    public String privateDownloadUrlWithDeadline(String baseUrl, long deadline) {
        StringBuilder b = new StringBuilder();
        b.append(baseUrl);
        int pos = baseUrl.indexOf("?");
        if (pos > 0) {
            b.append("&e=");
        } else {
            b.append("?e=");
        }
        b.append(deadline);
        String token = this.sign(StringUtils.utf8Bytes(b.toString()));
        b.append("&token=");
        b.append(token);
        return b.toString();
    }

    public String uploadToken(String bucket) {
        return this.uploadToken(bucket, null, 3600L, null, true);
    }

    public String uploadToken(String bucket, String key) {
        return this.uploadToken(bucket, key, 3600L, null, true);
    }

    public String uploadToken(String bucket, String key, long expires, StringMap policy) {
        return this.uploadToken(bucket, key, expires, policy, true);
    }

    public String uploadToken(String bucket, String key, long expires, StringMap policy, boolean strict) {
        long deadline = System.currentTimeMillis() / 1000L + expires;
        return this.uploadTokenWithDeadline(bucket, key, deadline, policy, strict);
    }

    public String uploadTokenWithDeadline(String bucket, String key, long deadline, StringMap policy, boolean strict) {
        String scope = bucket;
        if (key != null) {
            scope = bucket + ":" + key;
        }
        StringMap x = new StringMap();
        Auth.copyPolicy(x, policy, strict);
        x.put("scope", scope);
        x.put("deadline", deadline);
        String s = Json.encode(x);
        return this.signWithData(StringUtils.utf8Bytes(s));
    }

    public String uploadTokenWithPolicy(Object obj) {
        String s = Json.encode(obj);
        return this.signWithData(StringUtils.utf8Bytes(s));
    }

    @Deprecated
    public StringMap authorization(String url, byte[] body, String contentType) {
        String authorization = "QBox " + this.signRequest(url, body, contentType);
        return new StringMap().put("Authorization", authorization);
    }

    @Deprecated
    public StringMap authorization(String url) {
        return this.authorization(url, null, null);
    }

    @Deprecated
    public String signRequestV2(String url, String method, byte[] body, String contentType) {
        return this.signQiniuAuthorization(url, method, body, contentType);
    }

    public String signQiniuAuthorization(String url, String method, byte[] body, String contentType) {
        Headers headers = null;
        if (!StringUtils.isNullOrEmpty(contentType)) {
            headers = new Headers.Builder().set("Content-Type", contentType).build();
        }
        return this.signQiniuAuthorization(url, method, body, headers);
    }

    public String signQiniuAuthorization(String url, String method, byte[] body, Headers headers) {
        URI uri = URI.create(url);
        if (StringUtils.isNullOrEmpty(method)) {
            method = "GET";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(method).append(" ").append(uri.getPath());
        if (uri.getQuery() != null) {
            sb.append("?").append(uri.getQuery());
        }
        sb.append("\nHost: ").append(uri.getHost() != null ? uri.getHost() : "");
        if (uri.getPort() > 0) {
            sb.append(":").append(uri.getPort());
        }
        String contentType = null;
        if (null != headers) {
            contentType = headers.get("Content-Type");
            if (contentType != null) {
                sb.append("\nContent-Type: ").append(contentType);
            }
            List<Header> xQiniuheaders = this.genXQiniuHeader(headers);
            Collections.sort(xQiniuheaders);
            if (xQiniuheaders.size() > 0) {
                for (Header h : xQiniuheaders) {
                    sb.append("\n").append(h.name).append(": ").append(h.value);
                }
            }
        }
        sb.append("\n\n");
        if (body != null && body.length > 0 && null != contentType && !"".equals(contentType) && !"application/octet-stream".equals(contentType)) {
            sb.append(new String(body));
        }
        Mac mac = this.createMac();
        mac.update(StringUtils.utf8Bytes(sb.toString()));
        String digest = UrlSafeBase64.encodeToString(mac.doFinal());
        return this.accessKey + ":" + digest;
    }

    private List<Header> genXQiniuHeader(Headers headers) {
        ArrayList<Header> hs = new ArrayList<Header>();
        for (String name : headers.names()) {
            if (name.length() <= "X-Qiniu-".length() || !name.startsWith("X-Qiniu-")) continue;
            for (String value : headers.values(name)) {
                hs.add(new Header(Auth.canonicalMIMEHeaderKey(name), value));
            }
        }
        return hs;
    }

    public Headers qiniuAuthorization(String url, String method, byte[] body, Headers headers) {
        String authorization = "Qiniu " + this.signQiniuAuthorization(url, method, body, headers);
        headers = headers == null ? new Headers.Builder().set("Authorization", authorization).build() : headers.newBuilder().set("Authorization", authorization).build();
        return headers;
    }

    @Deprecated
    public StringMap authorizationV2(String url, String method, byte[] body, String contentType) {
        String authorization = "Qiniu " + this.signRequestV2(url, method, body, contentType);
        return new StringMap().put("Authorization", authorization);
    }

    @Deprecated
    public StringMap authorizationV2(String url) {
        return this.authorizationV2(url, "GET", null, null);
    }

    public String signRoomToken(String roomAccess) throws Exception {
        String encodedRoomAcc = UrlSafeBase64.encodeToString(roomAccess);
        byte[] sign = this.createMac().doFinal(encodedRoomAcc.getBytes());
        String encodedSign = UrlSafeBase64.encodeToString(sign);
        return this.accessKey + ":" + encodedSign + ":" + encodedRoomAcc;
    }

    public String generateLinkingDeviceToken(String appid, String deviceName, long deadline, String[] actions) {
        LinkingDtokenStatement[] staments = new LinkingDtokenStatement[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            staments[i] = new LinkingDtokenStatement(actions[i]);
        }
        SecureRandom random = new SecureRandom();
        StringMap map = new StringMap();
        map.put("appid", appid).put("device", deviceName).put("deadline", deadline).put("random", random.nextInt()).put("statement", staments);
        String s = Json.encode(map);
        return this.signWithData(StringUtils.utf8Bytes(s));
    }

    public String generateLinkingDeviceTokenWithExpires(String appid, String deviceName, long expires, String[] actions) {
        long deadline = System.currentTimeMillis() / 1000L + expires;
        return this.generateLinkingDeviceToken(appid, deviceName, deadline, actions);
    }

    public String generateLinkingDeviceVodTokenWithExpires(String appid, String deviceName, long expires) {
        return this.generateLinkingDeviceTokenWithExpires(appid, deviceName, expires, new String[]{DTOKEN_ACTION_VOD});
    }

    public String generateLinkingDeviceStatusTokenWithExpires(String appid, String deviceName, long expires) {
        return this.generateLinkingDeviceTokenWithExpires(appid, deviceName, expires, new String[]{DTOKEN_ACTION_STATUS});
    }

    private class Header
    implements Comparable<Header> {
        String name;
        String value;

        Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public int compareTo(Header o) {
            int c = this.name.compareTo(o.name);
            if (c == 0) {
                return this.value.compareTo(o.value);
            }
            return c;
        }
    }

    class LinkingDtokenStatement {
        @SerializedName(value="action")
        private String action;

        LinkingDtokenStatement(String action) {
            this.action = action;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }
    }
}

