/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.util.Json;
import com.qiniu.util.UrlSafeBase64;

class RegionReqInfo {
    private final String accessKey;
    private final String bucket;

    RegionReqInfo(String token) throws QiniuException {
        try {
            String[] strings = token.split(":");
            this.accessKey = strings[0];
            String policy = new String(UrlSafeBase64.decode(strings[2]), Constants.UTF_8);
            this.bucket = Json.decode(policy).get("scope").toString().split(":")[0];
        }
        catch (Exception e) {
            throw new QiniuException(e, "token is invalid");
        }
    }

    RegionReqInfo(String accessKey, String bucket) {
        this.accessKey = accessKey;
        this.bucket = bucket;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getBucket() {
        return this.bucket;
    }

    public int hashCode() {
        return this.accessKey.hashCode() + this.bucket.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RegionReqInfo) {
            RegionReqInfo t = (RegionReqInfo)obj;
            return this.accessKey.equals(t.accessKey) && this.bucket.equals(t.bucket);
        }
        return false;
    }
}

