/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.xpath;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SchemaType;

public abstract class AbstractNode
implements NodeInfo {
    private final List<AbstractNode> children = new ArrayList<AbstractNode>();
    private final TreeInfo treeInfo;

    protected AbstractNode(TreeInfo treeInfo) {
        this.treeInfo = treeInfo;
    }

    public abstract int getTokenType();

    public abstract DetailAST getUnderlyingNode();

    protected List<AbstractNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    protected void addChild(AbstractNode node) {
        this.children.add(node);
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        return this == nodeInfo;
    }

    public boolean hasFingerprint() {
        return false;
    }

    public String getURI() {
        return "";
    }

    public boolean hasChildNodes() {
        return !this.children.isEmpty();
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        AxisIterator axisIterator = this.iterateAxis(axisNumber);
        if (nodeTest != null) {
            axisIterator = new Navigator.AxisFilter(axisIterator, nodeTest);
        }
        return axisIterator;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        return this.getLocalPart().compareTo(nodeInfo.getLocalPart());
    }

    public final TreeInfo getTreeInfo() {
        return this.treeInfo;
    }

    public final NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] namespaceBindings) {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final boolean isId() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final boolean isIdref() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final boolean isNilled() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final boolean isStreamed() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final Configuration getConfiguration() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final void setSystemId(String systemId) {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final String getSystemId() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final String getPublicId() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final String getBaseURI() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final Location saveLocation() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final CharSequence getStringValueCS() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final int getFingerprint() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final String getDisplayName() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final String getPrefix() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final SchemaType getSchemaType() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final AtomicSequence atomize() {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final void generateId(FastStringBuffer fastStringBuffer) {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    public final void copy(Receiver receiver, int index, Location location) {
        throw AbstractNode.throwUnsupportedOperationException();
    }

    private static UnsupportedOperationException throwUnsupportedOperationException() {
        return new UnsupportedOperationException("Operation is not supported");
    }
}

