/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.results;

import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.nodes.StructuredGraph;

public class StaticAnalysisResults
implements ProfilingInfo {
    public static final StaticAnalysisResults NO_RESULTS = new StaticAnalysisResults(0, null, null, null);
    private final int codeSize;
    private final JavaTypeProfile[] parameterTypeProfiles;
    private final JavaTypeProfile resultTypeProfile;
    private final BytecodeEntry first;
    private BytecodeEntry cache;
    private int graphSize;

    public StaticAnalysisResults(int codeSize, JavaTypeProfile[] parameterTypeProfiles, JavaTypeProfile resultTypeProfile, BytecodeEntry first) {
        this.codeSize = codeSize;
        this.parameterTypeProfiles = parameterTypeProfiles;
        this.resultTypeProfile = resultTypeProfile;
        this.first = first;
        this.cache = first;
        this.graphSize = -1;
    }

    public JavaTypeProfile getParameterTypeProfile(int parameter) {
        if (this.parameterTypeProfiles != null && parameter < this.parameterTypeProfiles.length) {
            return this.parameterTypeProfiles[parameter];
        }
        return null;
    }

    public JavaTypeProfile getResultTypeProfile() {
        return this.resultTypeProfile;
    }

    private BytecodeEntry lookup(int bci) {
        BytecodeEntry cur;
        if (this.first == null) {
            return null;
        }
        BytecodeEntry bytecodeEntry = cur = bci >= this.cache.bci ? this.cache : this.first;
        while (cur != null && cur.bci < bci) {
            cur = cur.next;
        }
        if (cur != null) {
            this.cache = cur;
            if (cur.bci == bci) {
                return cur;
            }
        }
        return null;
    }

    public JavaTypeProfile getInvokeResultTypeProfile(int bci) {
        BytecodeEntry entry = this.lookup(bci);
        return entry == null ? null : entry.invokeResultTypeProfile;
    }

    public int getCodeSize() {
        return this.codeSize;
    }

    public double getBranchTakenProbability(int bci) {
        return -1.0;
    }

    public double[] getSwitchProbabilities(int bci) {
        return null;
    }

    public JavaTypeProfile getTypeProfile(int bci) {
        BytecodeEntry entry = this.lookup(bci);
        return entry == null ? null : entry.typeProfile;
    }

    public JavaMethodProfile getMethodProfile(int bci) {
        BytecodeEntry entry = this.lookup(bci);
        return entry == null ? null : entry.methodProfile;
    }

    public TriState getExceptionSeen(int bci) {
        return TriState.TRUE;
    }

    public TriState getNullSeen(int bci) {
        BytecodeEntry entry = this.lookup(bci);
        return entry == null ? TriState.UNKNOWN : entry.typeProfile.getNullSeen();
    }

    public int getExecutionCount(int bci) {
        return -1;
    }

    public int getDeoptimizationCount(DeoptimizationReason reason) {
        return 0;
    }

    public boolean setCompilerIRSize(Class<?> irType, int size) {
        if (irType == StructuredGraph.class) {
            this.graphSize = size;
            return true;
        }
        return false;
    }

    public int getCompilerIRSize(Class<?> irType) {
        if (irType == StructuredGraph.class) {
            return this.graphSize;
        }
        return -1;
    }

    public boolean isMature() {
        return true;
    }

    public void setMature() {
    }

    public static class BytecodeEntry {
        private final int bci;
        protected BytecodeEntry next;
        private final JavaMethodProfile methodProfile;
        private final JavaTypeProfile invokeResultTypeProfile;
        private final JavaTypeProfile typeProfile;

        public BytecodeEntry(int bci, JavaTypeProfile typeProfile, JavaMethodProfile methodProfile, JavaTypeProfile invokeResultTypeProfile) {
            this.bci = bci;
            this.methodProfile = methodProfile;
            this.invokeResultTypeProfile = invokeResultTypeProfile;
            this.typeProfile = typeProfile;
        }

        public String toString() {
            return "BytecodeEntry(bci=" + this.bci + ", typeProfile=" + this.typeProfile + ", methodProfile=" + this.methodProfile + ", invokeResultTypeProfile=" + this.invokeResultTypeProfile + ")";
        }
    }
}

