/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AnalysisContextPolicy<C extends AnalysisContext> {
    private final ContextFactory factory = new ContextFactory();
    private final C emptyContext;

    public AnalysisContextPolicy(C emptyContext) {
        this.emptyContext = this.factory.lookupContext(emptyContext);
    }

    public final C emptyContext() {
        return this.emptyContext;
    }

    public final boolean isEmpty(C context) {
        return context == this.emptyContext;
    }

    public abstract C calleeContext(BigBang var1, AnalysisObject var2, C var3, MethodTypeFlow var4);

    public abstract C staticCalleeContext(BigBang var1, BytecodeLocation var2, C var3, MethodTypeFlow var4);

    public abstract C allocationContext(C var1, int var2);

    public abstract C peel(C var1, int var2);

    public static BytecodeLocation[] extend(BytecodeLocation[] labelList, BytecodeLocation add, int maxDepth) {
        int resultingContextDepth = labelList.length == maxDepth ? maxDepth : labelList.length + 1;
        BytecodeLocation[] resultingLabelList = new BytecodeLocation[resultingContextDepth];
        int i = resultingContextDepth - 2;
        for (int j = labelList.length - 1; i >= 0 && j >= 0; --i, --j) {
            resultingLabelList[i] = labelList[j];
        }
        if (resultingContextDepth > 0) {
            resultingLabelList[resultingContextDepth - 1] = add;
        }
        return resultingLabelList;
    }

    public static BytecodeLocation[] extend(BytecodeLocation[] labelList, BytecodeLocation add) {
        BytecodeLocation[] result = Arrays.copyOf(labelList, labelList.length + 1);
        result[result.length - 1] = add;
        return result;
    }

    public static BytecodeLocation[] prepend(BytecodeLocation add, BytecodeLocation[] labelList) {
        BytecodeLocation[] result = new BytecodeLocation[labelList.length + 1];
        result[0] = add;
        System.arraycopy(labelList, 0, result, 1, labelList.length);
        return result;
    }

    public static BytecodeLocation[] peel(BytecodeLocation[] labelList, int maxDepth) {
        assert (maxDepth >= 0);
        assert (labelList.length > maxDepth);
        BytecodeLocation[] resultingLabelList = new BytecodeLocation[maxDepth];
        int i = maxDepth - 1;
        for (int j = labelList.length - 1; i >= 0 && j >= 0; --i, --j) {
            resultingLabelList[i] = labelList[j];
        }
        return resultingLabelList;
    }

    public AnalysisContext lookupContext(C context) {
        return this.factory.lookupContext(context);
    }

    private class ContextFactory {
        private final ConcurrentHashMap<AnalysisContext.AnalysisContextKey, C> allContexts = new ConcurrentHashMap();

        protected ContextFactory() {
        }

        protected C lookupContext(C newContext) {
            AnalysisContext.AnalysisContextKey key = ((AnalysisContext)newContext).asKey();
            AnalysisContext oldContext = (AnalysisContext)this.allContexts.get(key);
            if (oldContext == null) {
                oldContext = (AnalysisContext)this.allContexts.putIfAbsent(key, newContext);
                oldContext = oldContext != null ? oldContext : newContext;
            }
            return oldContext;
        }
    }
}

