/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.api;

import jdk.vm.ci.common.JVMCIError;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;

public class PointstoOptions {
    @Option(help={"Enable hybrid context for static methods, i.e. uses invocation site as context for static methods."})
    public static final OptionKey<Boolean> HybridStaticContext = new OptionKey((Object)false);
    @Option(help={"A context sensitive heap means that each heap allocated object is modeled by using at least the allocation site."})
    public static final OptionKey<Boolean> AllocationSiteSensitiveHeap = new OptionKey((Object)false);
    @Option(help={"The minimum length of the context used to model a heap object in addition to the allocation site; used only when ContextSensitiveHeap is enabled."})
    public static final OptionKey<Integer> MinHeapContextDepth = new OptionKey((Object)0);
    @Option(help={"The maximum length of the context used to model a heap object in addition to the allocation site; used only when ContextSensitiveHeap is enabled."})
    public static final OptionKey<Integer> MaxHeapContextDepth = new OptionKey((Object)0);
    @Option(help={"The maximum number of contexts to record for a heap object.  It only affects the analysis when the max and min calling context depth are different."})
    public static final OptionKey<Integer> MaxHeapContextWidth = new OptionKey((Object)0);
    @Option(help={"The minimum length of the methods context chains."})
    public static final OptionKey<Integer> MinCallingContextDepth = new OptionKey((Object)0);
    @Option(help={"The maximum length of the methods context chains."})
    public static final OptionKey<Integer> MaxCallingContextDepth = new OptionKey((Object)0);
    @Option(help={"The maximum number of contexts to record for a method. It only affects the analysis when the max and min calling context depth are different."})
    public static final OptionKey<Integer> MaxCallingContextWidth = new OptionKey((Object)0);
    @Option(help={"Enable a limit for the number of objects recorded for each type of a type state before disabling heap sensitivity for that type. The analysis must be heap sensitive."})
    public static final OptionKey<Boolean> LimitObjectArrayLength = new OptionKey((Object)false);
    @Option(help={"The maximum number of objects recorded for each type of a type state before disabling heap sensitivity for that type. The analysis must be heap sensitive. It has a minimum value of 1."})
    public static final OptionKey<Integer> MaxObjectSetSize = new OptionKey((Object)100);
    @Option(help={"The maximum number of constant objects recorded for each type before merging the constants into one unique constant object per type. The analysis must be heap sensitive. It has a minimum value of 1."})
    public static final OptionKey<Integer> MaxConstantObjectsPerType = new OptionKey((Object)100);
    @Option(help={"Track the progress of the static analysis."})
    public static final OptionKey<Boolean> ProfileAnalysisOperations = new OptionKey((Object)false);
    @Option(help={"Track the creation of constant objects."})
    public static final OptionKey<Boolean> ProfileConstantObjects = new OptionKey((Object)false);
    @Option(help={"Print types used for Java synchronization."})
    public static final OptionKey<Boolean> PrintSynchronizedAnalysis = new OptionKey((Object)false);
    @Option(help={"Analysis: Detect methods that return one of their parameters and hardwire the parameter straight to the return."})
    public static final OptionKey<Boolean> DivertParameterReturningMethod = new OptionKey((Object)true);
    @Option(help={"Enable extended asserts which slow down analysis."})
    public static final OptionKey<Boolean> ExtendedAsserts = new OptionKey((Object)false);
    @Option(help={"Track the callers for methods and accessing methods for fields."})
    public static final OptionKey<Boolean> TrackAccessChain = new OptionKey((Object)false);
    @Option(help={"Track the input for type flows."})
    public static final OptionKey<Boolean> TrackInputFlows = new OptionKey((Object)false);
    @Option(help={"The maximum size of type and method profiles returned by the static analysis. -1 indicates no limitation."})
    public static final OptionKey<Integer> AnalysisSizeCutoff = new OptionKey((Object)8);
    @Option(help={"Unsupported features are fatal."})
    public static final OptionKey<Boolean> ReportUnsupportedFeaturesDuringAnalysis = new OptionKey((Object)true);
    @Option(help={"Report unresolved elements as errors."})
    public static final OptionKey<Boolean> UnresolvedIsError = new OptionKey((Object)true);
    @Option(help={"Report analysis statistics."})
    public static final OptionKey<Boolean> ReportAnalysisStatistics = new OptionKey((Object)false);
    @Option(help={"Path to the contents of the Inspect web server."})
    public static final OptionKey<String> InspectServerContentPath = new OptionKey((Object)"inspect");
    @Option(help={"Controls the static analysis context sensitivity. Available values: insens (context insensitive analysis), allocsens (context insensitive analysis, context insensitive heap, allocation site sensitive heap), _1obj (1 object sensitive analysis with a context insensitive heap), _2obj1h (2 object sensitive with a 1 context sensitive heap)"})
    public static final OptionKey<String> AnalysisContextSensitivity = new OptionKey<String>("insens"){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
            switch (newValue.toLowerCase()) {
                case "insens": {
                    AllocationSiteSensitiveHeap.update(values, (Object)false);
                    MinHeapContextDepth.update(values, (Object)0);
                    MaxHeapContextDepth.update(values, (Object)0);
                    MinCallingContextDepth.update(values, (Object)0);
                    MaxCallingContextDepth.update(values, (Object)0);
                    break;
                }
                case "allocsens": {
                    AllocationSiteSensitiveHeap.update(values, (Object)true);
                    MinHeapContextDepth.update(values, (Object)0);
                    MaxHeapContextDepth.update(values, (Object)0);
                    MinCallingContextDepth.update(values, (Object)0);
                    MaxCallingContextDepth.update(values, (Object)0);
                    break;
                }
                case "_1obj": {
                    AllocationSiteSensitiveHeap.update(values, (Object)true);
                    MinHeapContextDepth.update(values, (Object)0);
                    MaxHeapContextDepth.update(values, (Object)0);
                    MinCallingContextDepth.update(values, (Object)1);
                    MaxCallingContextDepth.update(values, (Object)1);
                    break;
                }
                case "_2obj1h": {
                    AllocationSiteSensitiveHeap.update(values, (Object)true);
                    MinHeapContextDepth.update(values, (Object)1);
                    MaxHeapContextDepth.update(values, (Object)1);
                    MinCallingContextDepth.update(values, (Object)2);
                    MaxCallingContextDepth.update(values, (Object)2);
                    break;
                }
                case "_3obj2h": {
                    AllocationSiteSensitiveHeap.update(values, (Object)true);
                    MinHeapContextDepth.update(values, (Object)2);
                    MaxHeapContextDepth.update(values, (Object)2);
                    MinCallingContextDepth.update(values, (Object)3);
                    MaxCallingContextDepth.update(values, (Object)3);
                    break;
                }
                case "_4obj3h": {
                    AllocationSiteSensitiveHeap.update(values, (Object)true);
                    MinHeapContextDepth.update(values, (Object)3);
                    MaxHeapContextDepth.update(values, (Object)3);
                    MinCallingContextDepth.update(values, (Object)4);
                    MaxCallingContextDepth.update(values, (Object)4);
                    break;
                }
                default: {
                    throw JVMCIError.shouldNotReachHere((String)("Unknown context sensitivity setting:" + newValue));
                }
            }
        }
    };

    public static enum ContextSensitivity {
        insens("insens"),
        allocsens("allocsens"),
        _1obj("_1obj"),
        _2obj1h("_2obj1h"),
        _3obj2h("_3obj2h"),
        _4obj3h("_4obj3h");

        private String value;

        private ContextSensitivity(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

