/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class CRLCertificateIssuerExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_certificateIssuer;
    private ArrayList<GeneralName> certificateIssuer = new ArrayList();

    public CRLCertificateIssuerExtension() {
        super(TYPE);
    }

    public CRLCertificateIssuerExtension(GeneralName certificateIssuer) {
        this(certificateIssuer, true);
    }

    public CRLCertificateIssuerExtension(GeneralName certificateIssuer, boolean critical) {
        super(TYPE, critical);
        this.certificateIssuer.add(certificateIssuer);
        this.setValue(this.toByteArray());
    }

    public CRLCertificateIssuerExtension(Vector<GeneralName> certificateIssuer) {
        this((List<GeneralName>)certificateIssuer);
    }

    public CRLCertificateIssuerExtension(List<GeneralName> certificateIssuer) {
        this(certificateIssuer, true);
    }

    public CRLCertificateIssuerExtension(Vector<GeneralName> certificateIssuer, boolean critical) {
        this((List<GeneralName>)certificateIssuer, critical);
    }

    public CRLCertificateIssuerExtension(List<GeneralName> certificateIssuer, boolean critical) {
        super(TYPE, critical);
        this.certificateIssuer = certificateIssuer == null ? null : (certificateIssuer instanceof ArrayList ? (ArrayList<Object>)certificateIssuer : new ArrayList<GeneralName>(certificateIssuer));
        this.setValue(this.toByteArray());
    }

    public CRLCertificateIssuerExtension(InputStream is) throws IOException {
        super(is);
    }

    public Enumeration<GeneralName> certificateIssuer() {
        ArrayList<GeneralName> l = this.getCertificateIssuer();
        return l == null ? null : new VectorOverArrayList(l).elements();
    }

    public ArrayList<GeneralName> getCertificateIssuer() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.certificateIssuer;
    }

    public void addIssuerName(GeneralName name) {
        this.certificateIssuer.add(name);
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        byte[] b = Utils.toBytes((Streamable)new ASN1Sequence(this.certificateIssuer));
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)is);
            this.certificateIssuer = new ArrayList();
            while (sis.hasMoreData()) {
                this.certificateIssuer.add(new GeneralName((InputStream)sis));
            }
            sis.terminate();
            if (this.certificateIssuer.size() == 0) {
                throw new ASN1FormatException("No GeneralName defined for extension");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s = new StringBuffer("CRLCertificateIssuerExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.certificateIssuer != null) {
            s.append("certificateIssuers = {");
            boolean mid = false;
            int size = this.certificateIssuer.size();
            for (int i = 0; i < size; ++i) {
                if (mid) {
                    s.append(", ");
                }
                s.append(this.certificateIssuer.get(i).toString());
                mid = true;
            }
            s.append("}");
        }
        s.append("]}");
        return s.toString();
    }
}

