/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.util.Utils;

public class PKCS12SecretBag
extends PKCS12Bag {
    private PKCS12Safe parent;
    private ASN1ObjectID type;
    private ASN1Object value;
    private ASN1Sequence contents;

    public PKCS12SecretBag() {
    }

    public PKCS12SecretBag(PKCS12Safe parent) {
        this.parent = parent;
    }

    public PKCS12SecretBag(PKCS12Safe parent, ASN1ObjectID type, ASN1Object value) {
        this(parent);
        this.type = type;
        this.value = value;
    }

    public PKCS12SecretBag(PKCS12Safe parent, InputStream is) throws IOException {
        this(parent);
        this.input(is);
    }

    public PKCS12SecretBag(PKCS12Safe parent, ASN1Sequence s) throws IOException {
        this(parent);
        this.input(s);
    }

    @Override
    void reset() {
        this.contents = null;
        if (this.parent != null) {
            this.parent.reset();
        }
    }

    public void input(InputStream is) throws IOException {
        this.input(new ASN1Sequence(is));
    }

    public void input(ASN1Sequence s) throws IOException {
        this.reset();
        try {
            ASN1GenericConstructed bc = (ASN1GenericConstructed)s.elementAt(1);
            ASN1Sequence cb = (ASN1Sequence)bc.elementAt(0);
            this.type = (ASN1ObjectID)cb.elementAt(0);
            ASN1GenericConstructed c = (ASN1GenericConstructed)cb.elementAt(1);
            this.value = c.elementAt(0);
        }
        catch (ClassCastException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ASN1FormatException(ex.toString());
        }
    }

    public void output(OutputStream os) throws IOException {
        this.outputASN1().output(os);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence s = new ASN1Sequence();
        s.addElement((ASN1Object)new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 5));
        ASN1Sequence cb = new ASN1Sequence();
        cb.addElement((ASN1Object)this.type);
        cb.addElement((ASN1Object)new ASN1GenericConstructed(this.value, 0));
        s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)cb, 0));
        ASN1Set attr = this.outputAttrsASN1();
        if (attr != null) {
            s.addElement((ASN1Object)attr);
        }
        this.contents = s;
        return s;
    }

    public int length() {
        return this.outputASN1().length();
    }

    public void setSecretType(ASN1ObjectID type) {
        this.type = type;
        this.reset();
    }

    public ASN1ObjectID getSecretType() {
        return this.type;
    }

    public void setSecretValue(ASN1Object value) {
        this.value = value;
        this.reset();
    }

    public ASN1Object getSecretValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        if (this.friendlyName != null) {
            s.append("friendlyName = \"" + this.friendlyName + "\", ");
        }
        if (this.localKeyID != null) {
            s.append("localKeyID = " + Utils.toHexString((byte[])this.localKeyID) + ", ");
        }
        s.append("type = " + this.type + ", ");
        s.append("value = " + this.value);
        return s.toString();
    }
}

