/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class GeneralName
implements ASN1Object,
Externalizable {
    private Type type;
    private ASN1Object value;
    private ASN1Object contents = null;

    public GeneralName() {
    }

    public GeneralName(Type type, ASN1Object value) {
        try {
            this.initialize(type, value);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public GeneralName(Type type, String value) {
        this(type, (ASN1Object)new ASN1String(value, 22));
    }

    public GeneralName(X500Name value) {
        this(Type.DIRECTORY_NAME, value);
    }

    public GeneralName(InputStream is) throws IOException {
        this.input(is);
    }

    private void initialize(Type type, ASN1Object value) throws IOException {
        if (type == Type.OTHER_NAME) {
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)value));
            new ASN1ObjectID((InputStream)sis);
            new ASN1ConstructedInputStream((InputStream)sis, 0);
        } else if (type == Type.RFC822_NAME || type == Type.DNS_NAME || type == Type.URI) {
            if (!(value instanceof ASN1String)) {
                throw new ASN1FormatException("Invalid value for " + type);
            }
            if (((ASN1String)value).getTag() != 22) {
                throw new ASN1FormatException("Invalid value for " + type);
            }
        } else if (type == Type.IP_ADDRESS) {
            if (!(value instanceof ASN1OctetString)) {
                throw new ASN1FormatException("Invalid value for " + type);
            }
        } else if (type == Type.X400_ADDRESS || type == Type.DIRECTORY_NAME || type == Type.EDI_PARTY_NAME) {
            new ASN1Sequence(Utils.toStream((Streamable)value));
        } else if (type == Type.REGISTERED_ID) {
            new ASN1ObjectID(Utils.toStream((Streamable)value));
        }
        this.contents = null;
        this.type = type;
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public ASN1Object getValue() {
        return this.value;
    }

    public List<?> getTypeAndValue() {
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(new Integer(this.type.tag));
        if (this.value instanceof ASN1String) {
            list.add(((ASN1String)this.value).getValue());
        } else if (this.value instanceof ASN1ObjectID) {
            list.add(((ASN1ObjectID)this.value).toStringCompact());
        } else if (this.value instanceof X500Name) {
            list.add(((X500Name)this.value).toString());
        } else {
            list.add(Utils.toBytes((Streamable)this.value));
        }
        return list;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            GeneralName gn = (GeneralName)obj;
            if (this.type == gn.type) {
                return Utils.areEqual((byte[])Utils.toBytes((Streamable)this.value), (byte[])Utils.toBytes((Streamable)gn.value));
            }
            return false;
        }
        if (obj instanceof ASN1Object) {
            return Utils.areEqual((byte[])Utils.toBytes((Streamable)this.value), (byte[])Utils.toBytes((Streamable)((ASN1Object)obj)));
        }
        return false;
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return "{ " + this.type + ": " + this.value + " }";
    }

    public void input(InputStream is) throws IOException {
        Object v;
        Type t;
        PushbackInputStream pis = is instanceof PushbackInputStream ? (PushbackInputStream)is : new PushbackInputStream(is);
        int tagByte = pis.read();
        if (tagByte == -1) {
            throw new EOFException();
        }
        int tagCBit = tagByte & 0x20;
        switch (tagByte & 0x1F) {
            case 0: {
                t = Type.OTHER_NAME;
                pis.unread(tagCBit | 0x10);
                v = new ASN1Sequence((InputStream)pis);
                break;
            }
            case 1: {
                t = Type.RFC822_NAME;
                pis.unread(tagCBit | 0x16);
                v = new ASN1String((InputStream)pis);
                break;
            }
            case 2: {
                t = Type.DNS_NAME;
                pis.unread(tagCBit | 0x16);
                v = new ASN1String((InputStream)pis);
                break;
            }
            case 3: {
                t = Type.X400_ADDRESS;
                pis.unread(tagCBit | 0x10);
                v = new ASN1Sequence((InputStream)pis);
                break;
            }
            case 4: {
                t = Type.DIRECTORY_NAME;
                pis.unread(tagByte);
                ASN1ConstructedInputStream constructedName = new ASN1ConstructedInputStream((InputStream)pis, 4);
                v = new X500Name((InputStream)constructedName);
                constructedName.terminate();
                break;
            }
            case 5: {
                t = Type.EDI_PARTY_NAME;
                pis.unread(tagCBit | 0x10);
                v = new ASN1Sequence((InputStream)pis);
                break;
            }
            case 6: {
                t = Type.URI;
                pis.unread(tagCBit | 0x16);
                v = new ASN1String((InputStream)pis);
                break;
            }
            case 7: {
                t = Type.IP_ADDRESS;
                pis.unread(tagCBit | 4);
                v = new ASN1OctetString((InputStream)pis);
                break;
            }
            case 8: {
                t = Type.REGISTERED_ID;
                pis.unread(tagCBit | 6);
                v = new ASN1ObjectID((InputStream)pis);
                break;
            }
            default: {
                throw new ASN1FormatException("Unrecognized tag for GeneralName");
            }
        }
        this.initialize(t, (ASN1Object)v);
    }

    private ASN1Object getContents() {
        if (this.contents == null) {
            switch (this.type.getTag()) {
                case 4: {
                    this.contents = new ASN1GenericConstructed(this.value, this.type.getTag());
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.contents = ASN1Utils.addImplicitTag((ASN1Object)this.value, (int)this.type.getTag());
                    break;
                }
            }
        }
        return this.contents;
    }

    public void output(OutputStream os) throws IOException {
        this.getContents().output(os);
    }

    public int length() {
        return this.getContents().length();
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }

    public static class Type {
        public static final Type OTHER_NAME = new Type(0, "otherName");
        public static final Type RFC822_NAME = new Type(1, "rfc822Name");
        public static final Type DNS_NAME = new Type(2, "dNSName");
        public static final Type X400_ADDRESS = new Type(3, "x400Address");
        public static final Type DIRECTORY_NAME = new Type(4, "directoryName");
        public static final Type EDI_PARTY_NAME = new Type(5, "ediPartyName");
        public static final Type URI = new Type(6, "uniformResourceIdentifier");
        public static final Type IP_ADDRESS = new Type(7, "iPAddress");
        public static final Type REGISTERED_ID = new Type(8, "registeredID");
        private int tag;
        private String name;

        private Type(int tag, String name) {
            this.tag = tag;
            this.name = name;
        }

        private int getTag() {
            return this.tag;
        }

        public String toString() {
            return this.name;
        }
    }
}

