/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class OpaqueString
implements Serializable,
AutoCloseable,
Monitor {
    public static final OpaqueString NULL = new OpaqueString((String)null);
    public static final OpaqueString EMPTY = new OpaqueString("");
    private char[] c;
    private Monitor.CloseableLock monitorLock = this.newDefaultLock();

    public static OpaqueString newOpaqueString(char[] cArray) {
        if (cArray == null) {
            return NULL;
        }
        if (cArray.length == 0) {
            return EMPTY;
        }
        return new OpaqueString(cArray);
    }

    public static OpaqueString newOpaqueString(String string) {
        if (string == null) {
            return NULL;
        }
        if ("".equals(string)) {
            return EMPTY;
        }
        return new OpaqueString(string);
    }

    private OpaqueString(String string) {
        if (string != null) {
            this.c = new char[string.length()];
            for (int i2 = 0; i2 < string.length(); ++i2) {
                this.c[i2] = string.charAt(i2);
            }
            this.xor();
        } else {
            this.c = null;
        }
    }

    private OpaqueString(char[] cArray) {
        this.c = new char[cArray.length];
        this.c = Arrays.copyOf(cArray, cArray.length);
        Arrays.fill(cArray, '\u0000');
        this.xor();
    }

    public String get() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            if (this.c == null) {
                String string = null;
                return string;
            }
            this.xor();
            String string = new String(this.c);
            this.xor();
            String string2 = string;
            return string2;
        }
    }

    public char[] getChars() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            if (this.c == null) {
                char[] cArray = null;
                return cArray;
            }
            char[] cArray = new char[this.c.length];
            this.xor();
            cArray = Arrays.copyOf(this.c, this.c.length);
            this.xor();
            char[] cArray2 = cArray;
            return cArray2;
        }
    }

    @Override
    public void close() {
        Random random = new Random();
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            this.c[i2] = (char)(this.c[i2] ^ (char)random.nextInt());
        }
    }

    private void xor() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            Random random = new Random(super.hashCode() + this.getClass().hashCode());
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                this.c[i2] = (char)(this.c[i2] ^ random.nextInt());
            }
        }
    }

    public boolean isNull() {
        return this.c == null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.monitorLock);
        short[] sArray = new short[this.c.length * 2];
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            sArray[i2] = (short)this.c[i2];
        }
        Random random = new Random(super.hashCode() + this.getClass().hashCode());
        int n2 = this.c.length;
        int n3 = 0;
        while (n2 < 2 * this.c.length) {
            sArray[n2] = (short)random.nextInt();
            ++n2;
            ++n3;
        }
        objectOutputStream.writeObject(sArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n2;
        this.monitorLock = (Monitor.CloseableLock)objectInputStream.readObject();
        short[] sArray = (short[])objectInputStream.readObject();
        this.c = new char[sArray.length / 2];
        char[] cArray = new char[sArray.length / 2];
        int n3 = sArray.length / 2;
        for (n2 = 0; n2 < n3; ++n2) {
            this.c[n2] = (char)sArray[n2];
        }
        n2 = n3;
        int n4 = 0;
        while (n2 < 2 * n3) {
            cArray[n4] = (char)sArray[n2];
            ++n2;
            ++n4;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.c[n2] = (char)(this.c[n2] ^ cArray[n2]);
        }
        this.xor();
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("Stream data required");
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof OpaqueString)) {
            return false;
        }
        OpaqueString opaqueString = (OpaqueString)object;
        return Arrays.equals(this.getChars(), opaqueString.getChars());
    }

    public int hashCode() {
        String string = this.get();
        int n2 = string == null ? "".hashCode() : string.hashCode();
        return n2;
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }
}

