/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import oracle.jdbc.driver.AbstractShardingConnection;
import oracle.jdbc.driver.AbstractShardingResultSet;
import oracle.jdbc.driver.AbstractShardingStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

@ProxyFor(value={OraclePreparedStatement.class})
@ProxyResult(value=ProxyResultPolicy.MANUAL)
public abstract class AbstractShardingPreparedStatement
extends AbstractShardingStatement {
    protected String originalSql;
    ConcurrentHashMap<Integer, AbstractShardingStatement.CallHistoryEntry> bindMap = new ConcurrentHashMap();
    private int autoGeneratedKeys;
    private int[] columnIndexes;
    private String[] columnNames;
    static final String AUTO_GENERATED_KEYS = "autoGeneratedKeys";
    String[] namedParameters = new String[8];
    int parameterCount = 0;
    List<ConcurrentHashMap<Integer, AbstractShardingStatement.CallHistoryEntry>> bindBatchList = new ArrayList<ConcurrentHashMap<Integer, AbstractShardingStatement.CallHistoryEntry>>();

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    @GetDelegate
    protected abstract Statement getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Statement var1);

    void initialize(AbstractShardingConnection abstractShardingConnection, String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        String string2;
        super.initialize(abstractShardingConnection, properties);
        this.originalSql = string;
        this.autoGeneratedKeys = -1;
        this.columnIndexes = null;
        this.columnNames = null;
        this.statementType = 1;
        if (properties != null && (string2 = properties.getProperty(AUTO_GENERATED_KEYS)) != null) {
            this.autoGeneratedKeys = Integer.parseInt(string2);
        }
    }

    void setColumnIndexes(int[] nArray) {
        this.columnIndexes = nArray;
    }

    void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public void setArray(int n2, Array array) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setArray";
            Class[] classArray = new Class[]{Integer.TYPE, Array.class};
            Object[] objectArray = new Object[]{n2, array};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBigDecimal";
            Class[] classArray = new Class[]{Integer.TYPE, BigDecimal.class};
            Object[] objectArray = new Object[]{n2, bigDecimal};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBlob(int n2, Blob blob) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBlob";
            Class[] classArray = new Class[]{Integer.TYPE, Blob.class};
            Object[] objectArray = new Object[]{n2, blob};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBoolean(int n2, boolean bl) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBoolean";
            Class[] classArray = new Class[]{Integer.TYPE, Boolean.TYPE};
            Object[] objectArray = new Object[]{n2, bl};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setByte(int n2, byte by) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setByte";
            Class[] classArray = new Class[]{Integer.TYPE, Byte.TYPE};
            Object[] objectArray = new Object[]{n2, by};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBytes";
            Class[] classArray = new Class[]{Integer.TYPE, byte[].class};
            Object[] objectArray = new Object[]{n2, byArray};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setClob(int n2, Clob clob) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setClob";
            Class[] classArray = new Class[]{Integer.TYPE, Clob.class};
            Object[] objectArray = new Object[]{n2, clob};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setDate(int n2, Date date) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setDate";
            Class[] classArray = new Class[]{Integer.TYPE, Date.class};
            Object[] objectArray = new Object[]{n2, date};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setDate";
            Class[] classArray = new Class[]{Integer.TYPE, Date.class, Calendar.class};
            Object[] objectArray = new Object[]{n2, date, calendar};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setDouble(int n2, double d2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setDouble";
            Class[] classArray = new Class[]{Integer.TYPE, Double.TYPE};
            Object[] objectArray = new Object[]{n2, d2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setFloat(int n2, float f2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setFloat";
            Class[] classArray = new Class[]{Integer.TYPE, Float.TYPE};
            Object[] objectArray = new Object[]{n2, Float.valueOf(f2)};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setInt(int n2, int n3) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setInt";
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
            Object[] objectArray = new Object[]{n2, n3};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setLong(int n2, long l2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setLong";
            Class[] classArray = new Class[]{Integer.TYPE, Long.TYPE};
            Object[] objectArray = new Object[]{n2, l2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setNClob(int n2, NClob nClob) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setNClob";
            Class[] classArray = new Class[]{Integer.TYPE, NClob.class};
            Object[] objectArray = new Object[]{n2, nClob};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setNString(int n2, String string) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setNString";
            Class[] classArray = new Class[]{Integer.TYPE, String.class};
            Object[] objectArray = new Object[]{n2, string};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setObject(int n2, Object object) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setObject";
            Class[] classArray = new Class[]{Integer.TYPE, Object.class};
            Object[] objectArray = new Object[]{n2, object};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setObject";
            Class[] classArray = new Class[]{Integer.TYPE, Object.class, Integer.TYPE};
            Object[] objectArray = new Object[]{n2, object, n3};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setRef(int n2, Ref ref) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setRef";
            Class[] classArray = new Class[]{Integer.TYPE, Ref.class};
            Object[] objectArray = new Object[]{n2, ref};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setRowId(int n2, RowId rowId) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setRowId";
            Class[] classArray = new Class[]{Integer.TYPE, RowId.class};
            Object[] objectArray = new Object[]{n2, rowId};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setShort(int n2, short s2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setShort";
            Class[] classArray = new Class[]{Integer.TYPE, Short.TYPE};
            Object[] objectArray = new Object[]{n2, s2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setSQLXML";
            Class[] classArray = new Class[]{Integer.TYPE, SQLXML.class};
            Object[] objectArray = new Object[]{n2, sQLXML};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setString(int n2, String string) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setString";
            Class[] classArray = new Class[]{Integer.TYPE, String.class};
            Object[] objectArray = new Object[]{n2, string};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setTime(int n2, Time time) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setTime";
            Class[] classArray = new Class[]{Integer.TYPE, Time.class};
            Object[] objectArray = new Object[]{n2, time};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setTime";
            Class[] classArray = new Class[]{Integer.TYPE, Time.class, Calendar.class};
            Object[] objectArray = new Object[]{n2, time, calendar};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setTimestamp";
            Class[] classArray = new Class[]{Integer.TYPE, Timestamp.class};
            Object[] objectArray = new Object[]{n2, timestamp};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setTimestamp";
            Class[] classArray = new Class[]{Integer.TYPE, Timestamp.class, Calendar.class};
            Object[] objectArray = new Object[]{n2, timestamp, calendar};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setURL(int n2, URL uRL) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setURL";
            Class[] classArray = new Class[]{Integer.TYPE, URL.class};
            Object[] objectArray = new Object[]{n2, uRL};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setARRAY(int n2, ARRAY aRRAY) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setARRAY";
            Class[] classArray = new Class[]{Integer.TYPE, ARRAY.class};
            Object[] objectArray = new Object[]{n2, aRRAY};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBFILE(int n2, BFILE bFILE) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBFILE";
            Class[] classArray = new Class[]{Integer.TYPE, BFILE.class};
            Object[] objectArray = new Object[]{n2, bFILE};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBfile(int n2, BFILE bFILE) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBfile";
            Class[] classArray = new Class[]{Integer.TYPE, BFILE.class};
            Object[] objectArray = new Object[]{n2, bFILE};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBinaryFloat(int n2, float f2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBinaryFloat";
            Class[] classArray = new Class[]{Integer.TYPE, Float.TYPE};
            Object[] objectArray = new Object[]{n2, Float.valueOf(f2)};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBinaryFloat(int n2, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBinaryFloat";
            Class[] classArray = new Class[]{Integer.TYPE, BINARY_FLOAT.class};
            Object[] objectArray = new Object[]{n2, bINARY_FLOAT};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBinaryDouble(int n2, double d2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBinaryDouble";
            Class[] classArray = new Class[]{Integer.TYPE, Double.TYPE};
            Object[] objectArray = new Object[]{n2, d2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBinaryDouble(int n2, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBinaryDouble";
            Class[] classArray = new Class[]{Integer.TYPE, BINARY_DOUBLE.class};
            Object[] objectArray = new Object[]{n2, bINARY_DOUBLE};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBLOB(int n2, BLOB bLOB) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBLOB";
            Class[] classArray = new Class[]{Integer.TYPE, BLOB.class};
            Object[] objectArray = new Object[]{n2, bLOB};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setCHAR(int n2, CHAR cHAR) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setCHAR";
            Class[] classArray = new Class[]{Integer.TYPE, CHAR.class};
            Object[] objectArray = new Object[]{n2, cHAR};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setCLOB(int n2, CLOB cLOB) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setCLOB";
            Class[] classArray = new Class[]{Integer.TYPE, CLOB.class};
            Object[] objectArray = new Object[]{n2, cLOB};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setCursor(int n2, ResultSet resultSet) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setCursor";
            Class[] classArray = new Class[]{Integer.TYPE, ResultSet.class};
            Object[] objectArray = new Object[]{n2, resultSet};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setDATE(int n2, DATE dATE) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setDATE";
            Class[] classArray = new Class[]{Integer.TYPE, DATE.class};
            Object[] objectArray = new Object[]{n2, dATE};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setFixedCHAR(int n2, String string) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setFixedCHAR";
            Class[] classArray = new Class[]{Integer.TYPE, String.class};
            Object[] objectArray = new Object[]{n2, string};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setINTERVALDS(int n2, INTERVALDS iNTERVALDS) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setINTERVALDS";
            Class[] classArray = new Class[]{Integer.TYPE, INTERVALDS.class};
            Object[] objectArray = new Object[]{n2, iNTERVALDS};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setINTERVALYM(int n2, INTERVALYM iNTERVALYM) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setINTERVALYM";
            Class[] classArray = new Class[]{Integer.TYPE, INTERVALYM.class};
            Object[] objectArray = new Object[]{n2, iNTERVALYM};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setNUMBER(int n2, NUMBER nUMBER) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setNUMBER";
            Class[] classArray = new Class[]{Integer.TYPE, NUMBER.class};
            Object[] objectArray = new Object[]{n2, nUMBER};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setOPAQUE(int n2, OPAQUE oPAQUE) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setOPAQUE";
            Class[] classArray = new Class[]{Integer.TYPE, OPAQUE.class};
            Object[] objectArray = new Object[]{n2, oPAQUE};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setOracleObject(int n2, Datum datum) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setOracleObject";
            Class[] classArray = new Class[]{Integer.TYPE, Datum.class};
            Object[] objectArray = new Object[]{n2, datum};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setORAData(int n2, ORAData oRAData) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setORAData";
            Class[] classArray = new Class[]{Integer.TYPE, ORAData.class};
            Object[] objectArray = new Object[]{n2, oRAData};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setRAW(int n2, RAW rAW) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setRAW";
            Class[] classArray = new Class[]{Integer.TYPE, RAW.class};
            Object[] objectArray = new Object[]{n2, rAW};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setREF(int n2, REF rEF) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setREF";
            Class[] classArray = new Class[]{Integer.TYPE, REF.class};
            Object[] objectArray = new Object[]{n2, rEF};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setRefType(int n2, REF rEF) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setRefType";
            Class[] classArray = new Class[]{Integer.TYPE, REF.class};
            Object[] objectArray = new Object[]{n2, rEF};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setROWID(int n2, ROWID rOWID) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setROWID";
            Class[] classArray = new Class[]{Integer.TYPE, ROWID.class};
            Object[] objectArray = new Object[]{n2, rOWID};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setSTRUCT(int n2, STRUCT sTRUCT) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setSTRUCT";
            Class[] classArray = new Class[]{Integer.TYPE, STRUCT.class};
            Object[] objectArray = new Object[]{n2, sTRUCT};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setTIMESTAMPLTZ(int n2, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setTIMESTAMPLTZ";
            Class[] classArray = new Class[]{Integer.TYPE, TIMESTAMPLTZ.class};
            Object[] objectArray = new Object[]{n2, tIMESTAMPLTZ};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setTIMESTAMPTZ(int n2, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setTIMESTAMPTZ";
            Class[] classArray = new Class[]{Integer.TYPE, TIMESTAMPTZ.class};
            Object[] objectArray = new Object[]{n2, tIMESTAMPTZ};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setTIMESTAMP(int n2, TIMESTAMP tIMESTAMP) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setTIMESTAMP";
            Class[] classArray = new Class[]{Integer.TYPE, TIMESTAMP.class};
            Object[] objectArray = new Object[]{n2, tIMESTAMP};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setCustomDatum(int n2, CustomDatum customDatum) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setCustomDatum";
            Class[] classArray = new Class[]{Integer.TYPE, CustomDatum.class};
            Object[] objectArray = new Object[]{n2, customDatum};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBlob(int n2, InputStream inputStream) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBlob";
            Class[] classArray = new Class[]{Integer.TYPE, InputStream.class};
            Object[] objectArray = new Object[]{n2, inputStream};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBlob";
            Class[] classArray = new Class[]{Integer.TYPE, InputStream.class, Long.TYPE};
            Object[] objectArray = new Object[]{n2, inputStream, l2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setClob(int n2, Reader reader) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setClob";
            Class[] classArray = new Class[]{Integer.TYPE, Reader.class};
            Object[] objectArray = new Object[]{n2, reader};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setClob(int n2, Reader reader, long l2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setClob";
            Class[] classArray = new Class[]{Integer.TYPE, Reader.class, Long.TYPE};
            Object[] objectArray = new Object[]{n2, reader, l2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setNClob(int n2, Reader reader) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setNClob";
            Class[] classArray = new Class[]{Integer.TYPE, Reader.class};
            Object[] objectArray = new Object[]{n2, reader};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setNClob(int n2, Reader reader, long l2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setNClob";
            Class[] classArray = new Class[]{Integer.TYPE, Reader.class, Long.TYPE};
            Object[] objectArray = new Object[]{n2, reader, l2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setAsciiStream(int n2, InputStream inputStream) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setAsciiStream";
            Class[] classArray = new Class[]{Integer.TYPE, InputStream.class};
            Object[] objectArray = new Object[]{n2, inputStream};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setAsciiStream";
            Class[] classArray = new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE};
            Object[] objectArray = new Object[]{n2, inputStream, n3};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setAsciiStream";
            Class[] classArray = new Class[]{Integer.TYPE, InputStream.class, Long.TYPE};
            Object[] objectArray = new Object[]{n2, inputStream, l2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBinaryStream(int n2, InputStream inputStream) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBinaryStream";
            Class[] classArray = new Class[]{Integer.TYPE, InputStream.class};
            Object[] objectArray = new Object[]{n2, inputStream};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBinaryStream";
            Class[] classArray = new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE};
            Object[] objectArray = new Object[]{n2, inputStream, n3};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBinaryStream";
            Class[] classArray = new Class[]{Integer.TYPE, InputStream.class, Long.TYPE};
            Object[] objectArray = new Object[]{n2, inputStream, l2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setCharacterStream(int n2, Reader reader) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setCharacterStream";
            Class[] classArray = new Class[]{Integer.TYPE, Reader.class};
            Object[] objectArray = new Object[]{n2, reader};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setCharacterStream";
            Class[] classArray = new Class[]{Integer.TYPE, Reader.class, Integer.TYPE};
            Object[] objectArray = new Object[]{n2, reader, n3};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setCharacterStream";
            Class[] classArray = new Class[]{Integer.TYPE, Reader.class, Long.TYPE};
            Object[] objectArray = new Object[]{n2, reader, l2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setNCharacterStream(int n2, Reader reader) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setNCharacterStream";
            Class[] classArray = new Class[]{Integer.TYPE, Reader.class};
            Object[] objectArray = new Object[]{n2, reader};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setNCharacterStream";
            Class[] classArray = new Class[]{Integer.TYPE, Reader.class, Long.TYPE};
            Object[] objectArray = new Object[]{n2, reader, l2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setUnicodeStream";
            Class[] classArray = new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE};
            Object[] objectArray = new Object[]{n2, inputStream, n3};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setStructDescriptor(int n2, StructDescriptor structDescriptor) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setStructDescriptor";
            Class[] classArray = new Class[]{Integer.TYPE, StructDescriptor.class};
            Object[] objectArray = new Object[]{n2, structDescriptor};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setStringForClob(int n2, String string) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setStringForClob";
            Class[] classArray = new Class[]{Integer.TYPE, String.class};
            Object[] objectArray = new Object[]{n2, string};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBytesForBlob(int n2, byte[] byArray) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setBytesForBlob";
            Class[] classArray = new Class[]{Integer.TYPE, byte[].class};
            Object[] objectArray = new Object[]{n2, byArray};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setNull";
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, String.class};
            Object[] objectArray = new Object[]{n2, n3, string};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setNull(int n2, int n3) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setNull";
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
            Object[] objectArray = new Object[]{n2, n3};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setInternalBytes(int n2, byte[] byArray, int n3) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setInternalBytes";
            Class[] classArray = new Class[]{Integer.TYPE, byte[].class, Integer.TYPE};
            Object[] objectArray = new Object[]{n2, byArray, n3};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setArrayAtName(String string, Array array) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setArrayAtName";
            Class[] classArray = new Class[]{String.class, Array.class};
            Object[] objectArray = new Object[]{string, array};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBigDecimalAtName(String string, BigDecimal bigDecimal) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBigDecimalAtName";
            Class[] classArray = new Class[]{String.class, BigDecimal.class};
            Object[] objectArray = new Object[]{string, bigDecimal};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBlobAtName(String string, Blob blob) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBlobAtName";
            Class[] classArray = new Class[]{String.class, Blob.class};
            Object[] objectArray = new Object[]{string, blob};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBooleanAtName(String string, boolean bl) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBooleanAtName";
            Class[] classArray = new Class[]{String.class, Boolean.TYPE};
            Object[] objectArray = new Object[]{string, bl};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setByteAtName(String string, byte by) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setByteAtName";
            Class[] classArray = new Class[]{String.class, Byte.TYPE};
            Object[] objectArray = new Object[]{string, by};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBytesAtName(String string, byte[] byArray) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBytesAtName";
            Class[] classArray = new Class[]{String.class, byte[].class};
            Object[] objectArray = new Object[]{string, byArray};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setClobAtName(String string, Clob clob) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setClobAtName";
            Class[] classArray = new Class[]{String.class, Clob.class};
            Object[] objectArray = new Object[]{string, clob};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setDateAtName(String string, Date date) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setDateAtName";
            Class[] classArray = new Class[]{String.class, Date.class};
            Object[] objectArray = new Object[]{string, date};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setDateAtName(String string, Date date, Calendar calendar) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setDateAtName";
            Class[] classArray = new Class[]{String.class, Date.class, Calendar.class};
            Object[] objectArray = new Object[]{string, date, calendar};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setDoubleAtName(String string, double d2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setDoubleAtName";
            Class[] classArray = new Class[]{String.class, Double.TYPE};
            Object[] objectArray = new Object[]{string, d2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setFloatAtName(String string, float f2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setFloatAtName";
            Class[] classArray = new Class[]{String.class, Float.TYPE};
            Object[] objectArray = new Object[]{string, Float.valueOf(f2)};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setIntAtName(String string, int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setIntAtName";
            Class[] classArray = new Class[]{String.class, Integer.TYPE};
            Object[] objectArray = new Object[]{string, n2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n3 = this.addNamedPara(string);
            this.bindMap.put(n3, callHistoryEntry);
        }
    }

    public void setLongAtName(String string, long l2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setLongAtName";
            Class[] classArray = new Class[]{String.class, Long.TYPE};
            Object[] objectArray = new Object[]{string, l2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setNClobAtName(String string, NClob nClob) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setNClobAtName";
            Class[] classArray = new Class[]{String.class, NClob.class};
            Object[] objectArray = new Object[]{string, nClob};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setNStringAtName(String string, String string2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string3 = "setNStringAtName";
            Class[] classArray = new Class[]{String.class, String.class};
            Object[] objectArray = new Object[]{string, string2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string3, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setObjectAtName(String string, Object object) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setObjectAtName";
            Class[] classArray = new Class[]{String.class, Object.class};
            Object[] objectArray = new Object[]{string, object};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setObjectAtName(String string, Object object, int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setObjectAtName";
            Class[] classArray = new Class[]{String.class, Object.class, Integer.TYPE};
            Object[] objectArray = new Object[]{string, object, n2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n3 = this.addNamedPara(string);
            this.bindMap.put(n3, callHistoryEntry);
        }
    }

    public void setRefAtName(String string, Ref ref) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setRefAtName";
            Class[] classArray = new Class[]{String.class, Ref.class};
            Object[] objectArray = new Object[]{string, ref};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setRowIdAtName(String string, RowId rowId) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setRowIdAtName";
            Class[] classArray = new Class[]{String.class, RowId.class};
            Object[] objectArray = new Object[]{string, rowId};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setShortAtName(String string, short s2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setShortAtName";
            Class[] classArray = new Class[]{String.class, Short.TYPE};
            Object[] objectArray = new Object[]{string, s2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setSQLXMLAtName(String string, SQLXML sQLXML) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setSQLXMLAtName";
            Class[] classArray = new Class[]{String.class, SQLXML.class};
            Object[] objectArray = new Object[]{string, sQLXML};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setStringAtName(String string, String string2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string3 = "setStringAtName";
            Class[] classArray = new Class[]{String.class, String.class};
            Object[] objectArray = new Object[]{string, string2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string3, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setTimeAtName(String string, Time time) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setTimeAtName";
            Class[] classArray = new Class[]{String.class, Time.class};
            Object[] objectArray = new Object[]{string, time};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setTimeAtName(String string, Time time, Calendar calendar) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setTimeAtName";
            Class[] classArray = new Class[]{String.class, Time.class, Calendar.class};
            Object[] objectArray = new Object[]{string, time, calendar};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setTimestampAtName(String string, Timestamp timestamp) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setTimestampAtName";
            Class[] classArray = new Class[]{String.class, Timestamp.class};
            Object[] objectArray = new Object[]{string, timestamp};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setTimestampAtName(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setTimestampAtName";
            Class[] classArray = new Class[]{String.class, Timestamp.class, Calendar.class};
            Object[] objectArray = new Object[]{string, timestamp, calendar};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setURLAtName(String string, URL uRL) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setURLAtName";
            Class[] classArray = new Class[]{String.class, URL.class};
            Object[] objectArray = new Object[]{string, uRL};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setARRAYAtName(String string, ARRAY aRRAY) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setARRAYAtName";
            Class[] classArray = new Class[]{String.class, ARRAY.class};
            Object[] objectArray = new Object[]{string, aRRAY};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBFILEAtName(String string, BFILE bFILE) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBFILEAtName";
            Class[] classArray = new Class[]{String.class, BFILE.class};
            Object[] objectArray = new Object[]{string, bFILE};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBfileAtName(String string, BFILE bFILE) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBfileAtName";
            Class[] classArray = new Class[]{String.class, BFILE.class};
            Object[] objectArray = new Object[]{string, bFILE};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBinaryFloatAtName(String string, float f2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBinaryFloatAtName";
            Class[] classArray = new Class[]{String.class, Float.TYPE};
            Object[] objectArray = new Object[]{string, Float.valueOf(f2)};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBinaryFloatAtName(String string, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBinaryFloatAtName";
            Class[] classArray = new Class[]{String.class, BINARY_FLOAT.class};
            Object[] objectArray = new Object[]{string, bINARY_FLOAT};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBinaryDoubleAtName(String string, double d2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBinaryDoubleAtName";
            Class[] classArray = new Class[]{String.class, Double.TYPE};
            Object[] objectArray = new Object[]{string, d2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBinaryDoubleAtName(String string, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBinaryDoubleAtName";
            Class[] classArray = new Class[]{String.class, BINARY_DOUBLE.class};
            Object[] objectArray = new Object[]{string, bINARY_DOUBLE};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBLOBAtName(String string, BLOB bLOB) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBLOBAtName";
            Class[] classArray = new Class[]{String.class, BLOB.class};
            Object[] objectArray = new Object[]{string, bLOB};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setCHARAtName(String string, CHAR cHAR) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setCHARAtName";
            Class[] classArray = new Class[]{String.class, CHAR.class};
            Object[] objectArray = new Object[]{string, cHAR};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setCLOBAtName(String string, CLOB cLOB) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setCLOBAtName";
            Class[] classArray = new Class[]{String.class, CLOB.class};
            Object[] objectArray = new Object[]{string, cLOB};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setCursorAtName(String string, ResultSet resultSet) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setCursorAtName";
            Class[] classArray = new Class[]{String.class, ResultSet.class};
            Object[] objectArray = new Object[]{string, resultSet};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setDATEAtName(String string, DATE dATE) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setDATEAtName";
            Class[] classArray = new Class[]{String.class, DATE.class};
            Object[] objectArray = new Object[]{string, dATE};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setFixedCHARAtName(String string, String string2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string3 = "setFixedCHARAtName";
            Class[] classArray = new Class[]{String.class, String.class};
            Object[] objectArray = new Object[]{string, string2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string3, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setINTERVALDSAtName(String string, INTERVALDS iNTERVALDS) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setINTERVALDSAtName";
            Class[] classArray = new Class[]{String.class, INTERVALDS.class};
            Object[] objectArray = new Object[]{string, iNTERVALDS};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setINTERVALYMAtName(String string, INTERVALYM iNTERVALYM) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setINTERVALYMAtName";
            Class[] classArray = new Class[]{String.class, INTERVALYM.class};
            Object[] objectArray = new Object[]{string, iNTERVALYM};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setNUMBERAtName(String string, NUMBER nUMBER) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setNUMBERAtName";
            Class[] classArray = new Class[]{String.class, NUMBER.class};
            Object[] objectArray = new Object[]{string, nUMBER};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setOPAQUEAtName(String string, OPAQUE oPAQUE) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setOPAQUEAtName";
            Class[] classArray = new Class[]{String.class, OPAQUE.class};
            Object[] objectArray = new Object[]{string, oPAQUE};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setOracleObjectAtName(String string, Datum datum) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setOracleObjectAtName";
            Class[] classArray = new Class[]{String.class, Datum.class};
            Object[] objectArray = new Object[]{string, datum};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setORADataAtName(String string, ORAData oRAData) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setORADataAtName";
            Class[] classArray = new Class[]{String.class, ORAData.class};
            Object[] objectArray = new Object[]{string, oRAData};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setRAWAtName(String string, RAW rAW) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setRAWAtName";
            Class[] classArray = new Class[]{String.class, RAW.class};
            Object[] objectArray = new Object[]{string, rAW};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setREFAtName(String string, REF rEF) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setREFAtName";
            Class[] classArray = new Class[]{String.class, REF.class};
            Object[] objectArray = new Object[]{string, rEF};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setRefTypeAtName(String string, REF rEF) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setRefTypeAtName";
            Class[] classArray = new Class[]{String.class, REF.class};
            Object[] objectArray = new Object[]{string, rEF};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setROWIDAtName(String string, ROWID rOWID) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setROWIDAtName";
            Class[] classArray = new Class[]{String.class, ROWID.class};
            Object[] objectArray = new Object[]{string, rOWID};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setSTRUCTAtName(String string, STRUCT sTRUCT) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setSTRUCTAtName";
            Class[] classArray = new Class[]{String.class, STRUCT.class};
            Object[] objectArray = new Object[]{string, sTRUCT};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setTIMESTAMPLTZAtName(String string, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setTIMESTAMPLTZAtName";
            Class[] classArray = new Class[]{String.class, TIMESTAMPLTZ.class};
            Object[] objectArray = new Object[]{string, tIMESTAMPLTZ};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setTIMESTAMPTZAtName(String string, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setTIMESTAMPTZAtName";
            Class[] classArray = new Class[]{String.class, TIMESTAMPTZ.class};
            Object[] objectArray = new Object[]{string, tIMESTAMPTZ};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setTIMESTAMPAtName(String string, TIMESTAMP tIMESTAMP) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setTIMESTAMPAtName";
            Class[] classArray = new Class[]{String.class, TIMESTAMP.class};
            Object[] objectArray = new Object[]{string, tIMESTAMP};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setCustomDatumAtName(String string, CustomDatum customDatum) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setCustomDatumAtName";
            Class[] classArray = new Class[]{String.class, CustomDatum.class};
            Object[] objectArray = new Object[]{string, customDatum};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBlobAtName(String string, InputStream inputStream) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBlobAtName";
            Class[] classArray = new Class[]{String.class, InputStream.class};
            Object[] objectArray = new Object[]{string, inputStream};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBlobAtName(String string, InputStream inputStream, long l2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBlobAtName";
            Class[] classArray = new Class[]{String.class, InputStream.class, Long.TYPE};
            Object[] objectArray = new Object[]{string, inputStream, l2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setClobAtName(String string, Reader reader) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setClobAtName";
            Class[] classArray = new Class[]{String.class, Reader.class};
            Object[] objectArray = new Object[]{string, reader};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setClobAtName(String string, Reader reader, long l2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setClobAtName";
            Class[] classArray = new Class[]{String.class, Reader.class, Long.TYPE};
            Object[] objectArray = new Object[]{string, reader, l2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setNClobAtName(String string, Reader reader) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setNClobAtName";
            Class[] classArray = new Class[]{String.class, Reader.class};
            Object[] objectArray = new Object[]{string, reader};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setNClobAtName(String string, Reader reader, long l2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setNClobAtName";
            Class[] classArray = new Class[]{String.class, Reader.class, Long.TYPE};
            Object[] objectArray = new Object[]{string, reader, l2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setAsciiStreamAtName(String string, InputStream inputStream) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setAsciiStreamAtName";
            Class[] classArray = new Class[]{String.class, InputStream.class};
            Object[] objectArray = new Object[]{string, inputStream};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setAsciiStreamAtName(String string, InputStream inputStream, int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setAsciiStreamAtName";
            Class[] classArray = new Class[]{String.class, InputStream.class, Integer.TYPE};
            Object[] objectArray = new Object[]{string, inputStream, n2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n3 = this.addNamedPara(string);
            this.bindMap.put(n3, callHistoryEntry);
        }
    }

    public void setAsciiStreamAtName(String string, InputStream inputStream, long l2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setAsciiStreamAtName";
            Class[] classArray = new Class[]{String.class, InputStream.class, Long.TYPE};
            Object[] objectArray = new Object[]{string, inputStream, l2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBinaryStreamAtName(String string, InputStream inputStream) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBinaryStreamAtName";
            Class[] classArray = new Class[]{String.class, InputStream.class};
            Object[] objectArray = new Object[]{string, inputStream};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBinaryStreamAtName(String string, InputStream inputStream, int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBinaryStreamAtName";
            Class[] classArray = new Class[]{String.class, InputStream.class, Integer.TYPE};
            Object[] objectArray = new Object[]{string, inputStream, n2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n3 = this.addNamedPara(string);
            this.bindMap.put(n3, callHistoryEntry);
        }
    }

    public void setBinaryStreamAtName(String string, InputStream inputStream, long l2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBinaryStreamAtName";
            Class[] classArray = new Class[]{String.class, InputStream.class, Long.TYPE};
            Object[] objectArray = new Object[]{string, inputStream, l2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setCharacterStreamAtName(String string, Reader reader) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setCharacterStreamAtName";
            Class[] classArray = new Class[]{String.class, Reader.class};
            Object[] objectArray = new Object[]{string, reader};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setCharacterStreamAtName(String string, Reader reader, int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setCharacterStreamAtName";
            Class[] classArray = new Class[]{String.class, Reader.class, Integer.TYPE};
            Object[] objectArray = new Object[]{string, reader, n2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n3 = this.addNamedPara(string);
            this.bindMap.put(n3, callHistoryEntry);
        }
    }

    public void setCharacterStreamAtName(String string, Reader reader, long l2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setCharacterStreamAtName";
            Class[] classArray = new Class[]{String.class, Reader.class, Long.TYPE};
            Object[] objectArray = new Object[]{string, reader, l2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setNCharacterStreamAtName(String string, Reader reader) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setNCharacterStreamAtName";
            Class[] classArray = new Class[]{String.class, Reader.class};
            Object[] objectArray = new Object[]{string, reader};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setNCharacterStreamAtName(String string, Reader reader, long l2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setNCharacterStreamAtName";
            Class[] classArray = new Class[]{String.class, Reader.class, Long.TYPE};
            Object[] objectArray = new Object[]{string, reader, l2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setUnicodeStreamAtName(String string, InputStream inputStream, int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setUnicodeStreamAtName";
            Class[] classArray = new Class[]{String.class, InputStream.class, Integer.TYPE};
            Object[] objectArray = new Object[]{string, inputStream, n2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n3 = this.addNamedPara(string);
            this.bindMap.put(n3, callHistoryEntry);
        }
    }

    public void setNullAtName(String string, int n2, String string2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string3 = "setNullAtName";
            Class[] classArray = new Class[]{String.class, Integer.TYPE, String.class};
            Object[] objectArray = new Object[]{string, n2, string2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string3, classArray, objectArray);
            int n3 = this.addNamedPara(string);
            this.bindMap.put(n3, callHistoryEntry);
        }
    }

    public void setNullAtName(String string, int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setNullAtName";
            Class[] classArray = new Class[]{String.class, Integer.TYPE};
            Object[] objectArray = new Object[]{string, n2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n3 = this.addNamedPara(string);
            this.bindMap.put(n3, callHistoryEntry);
        }
    }

    public void setStructDescriptorAtName(String string, StructDescriptor structDescriptor) throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
        String string2 = "setStructDescriptorAtName";
        Class[] classArray = new Class[]{String.class, StructDescriptor.class};
        Object[] objectArray = new Object[]{string, structDescriptor};
        AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
        int n2 = this.addNamedPara(string);
        this.bindMap.put(n2, callHistoryEntry);
    }

    public void setStringForClobAtName(String string, String string2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string3 = "setStringForClobAtName";
            Class[] classArray = new Class[]{String.class, String.class};
            Object[] objectArray = new Object[]{string, string2};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string3, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setBytesForBlobAtName(String string, byte[] byArray) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setBytesForBlobAtName";
            Class[] classArray = new Class[]{String.class, byte[].class};
            Object[] objectArray = new Object[]{string, byArray};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n2 = this.addNamedPara(string);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void registerReturnParameter(int n2, int n3) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "registerReturnParameter";
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
            Object[] objectArray = new Object[]{n2, n3};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void registerReturnParameter(int n2, int n3, int n4) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "registerReturnParameter";
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] objectArray = new Object[]{n2, n3, n4};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void registerReturnParameter(int n2, int n3, String string) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "registerReturnParameter";
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, String.class};
            Object[] objectArray = new Object[]{n2, n3, string};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setCheckBindTypes(boolean bl) throws SQLException {
        AbstractShardingConnection abstractShardingConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock closeableLock = abstractShardingConnection.acquireConnectionCloseableLock();){
            OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getDelegate();
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.setCheckBindTypes(bl);
            } else {
                Class[] classArray = new Class[]{Boolean.TYPE};
                Object[] objectArray = new Object[]{bl};
                AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry("setCheckBindTypes", classArray, objectArray);
                this.appendCallEntry(callHistoryEntry);
            }
        }
    }

    public void setFormOfUse(int n2, short s2) throws SQLException {
        AbstractShardingConnection abstractShardingConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock closeableLock = abstractShardingConnection.acquireConnectionCloseableLock();){
            OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getDelegate();
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.setFormOfUse(n2, s2);
            } else {
                Class[] classArray = new Class[]{Integer.TYPE, Short.TYPE};
                Object[] objectArray = new Object[]{n2, s2};
                AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry("setFormOfUse", classArray, objectArray);
                this.appendCallEntry(callHistoryEntry);
            }
        }
    }

    public void defineParameterTypeBytes(int n2, int n3, int n4) throws SQLException {
        AbstractShardingConnection abstractShardingConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock closeableLock = abstractShardingConnection.acquireConnectionCloseableLock();){
            OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getDelegate();
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.defineParameterTypeBytes(n2, n3, n4);
            } else {
                Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
                Object[] objectArray = new Object[]{n2, n3, n4};
                AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry("defineParameterTypeBytes", classArray, objectArray);
                this.appendCallEntry(callHistoryEntry);
            }
        }
    }

    public void defineParameterTypeChars(int n2, int n3, int n4) throws SQLException {
        AbstractShardingConnection abstractShardingConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock closeableLock = abstractShardingConnection.acquireConnectionCloseableLock();){
            OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getDelegate();
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.defineParameterTypeChars(n2, n3, n4);
            } else {
                Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
                Object[] objectArray = new Object[]{n2, n3, n4};
                AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry("defineParameterTypeChars", classArray, objectArray);
                this.appendCallEntry(callHistoryEntry);
            }
        }
    }

    public void defineParameterType(int n2, int n3, int n4) throws SQLException {
        AbstractShardingConnection abstractShardingConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock closeableLock = abstractShardingConnection.acquireConnectionCloseableLock();){
            OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getDelegate();
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.defineParameterType(n2, n3, n4);
            } else {
                Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
                Object[] objectArray = new Object[]{n2, n3, n4};
                AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry("defineParameterType", classArray, objectArray);
                this.appendCallEntry(callHistoryEntry);
            }
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        AbstractShardingConnection abstractShardingConnection = (AbstractShardingConnection)this.getCreator();
        Throwable throwable = null;
        try (Monitor.CloseableLock closeableLock = abstractShardingConnection.acquireConnectionCloseableLock();){
            OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getDelegate();
            if (oraclePreparedStatement != null) {
                ResultSetMetaData resultSetMetaData = oraclePreparedStatement.getMetaData();
                return resultSetMetaData;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setObject";
            Class[] classArray = new Class[]{Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE};
            Object[] objectArray = new Object[]{n2, object, n3, n4};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    public void setObjectAtName(String string, Object object, int n2, int n3) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string2 = "setObjectAtName";
            Class[] classArray = new Class[]{String.class, Object.class, Integer.TYPE, Integer.TYPE};
            Object[] objectArray = new Object[]{string, object, n2, n3};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string2, classArray, objectArray);
            int n4 = this.addNamedPara(string);
            this.bindMap.put(n4, callHistoryEntry);
        }
    }

    @Deprecated
    public void setPlsqlIndexTable(int n2, Object object, int n3, int n4, int n5, int n6) throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String string = "setPlsqlIndexTable";
            Class[] classArray = new Class[]{Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] objectArray = new Object[]{n2, object, n3, n4, n5, n6};
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = new AbstractShardingStatement.CallHistoryEntry(string, classArray, objectArray);
            this.bindMap.put(n2, callHistoryEntry);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="execute", args={}), @Signature(name="executeUpdate", args={})})
    protected void prePstmtExecuteQuery(Method method, Object object, Object ... objectArray) {
        try {
            ((AbstractShardingConnection)this.getCreator()).acquireConnectionLock();
            this.ensureOpen();
            this.closeDatabaseStatement();
            OraclePreparedStatement oraclePreparedStatement = this.checkForKeyTokensAndGetUCPPreparedStatement(this.originalSql);
            this.delegatesBindCalls(oraclePreparedStatement, this.bindMap);
            this.delegatesBeforePstmtExecuteCalls(oraclePreparedStatement);
        }
        catch (SQLException sQLException) {
            ((AbstractShardingConnection)this.getCreator()).releaseConnectionLock();
            throw new RuntimeException(sQLException);
        }
    }

    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={})})
    protected ResultSet postPstmtExecuteQuery(Method method, ResultSet resultSet) {
        try {
            OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getDelegate();
            resultSet = this.createResultSetProxy(resultSet);
            this.currentResultSet = (AbstractShardingResultSet)((Object)resultSet);
            this.setShardingKeyRpnTokens(oraclePreparedStatement, oraclePreparedStatement.getOriginalSql());
            this.makeDatabaseConnectionSticky((AbstractShardingConnection)this.getCreator(), (OracleConnection)oraclePreparedStatement.getConnection());
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        finally {
            ((AbstractShardingConnection)this.getCreator()).releaseConnectionLock();
        }
        return resultSet;
    }

    @Post
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="executeUpdate", args={})})
    protected Object postPstmtExecuteUpdate(Method method, Object object) {
        try {
            OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getDelegate();
            this.setShardingKeyRpnTokens(oraclePreparedStatement, oraclePreparedStatement.getOriginalSql());
            this.makeDatabaseConnectionSticky((AbstractShardingConnection)this.getCreator(), (OracleConnection)oraclePreparedStatement.getConnection());
            Object object2 = object;
            return object2;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        finally {
            ((AbstractShardingConnection)this.getCreator()).releaseConnectionLock();
        }
    }

    @OnError(value=SQLException.class)
    protected Object onErrorPstmt(Method method, SQLException sQLException) throws SQLException {
        ((AbstractShardingConnection)this.getCreator()).checkAndReleaseConnectionLock();
        throw sQLException;
    }

    @Override
    @Pre
    @Methods(signatures={@Signature(name="executeQuery", args={String.class}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected void preStmtExecuteQuery(Method method, Object object, Object ... objectArray) {
        super.preStmtExecuteQuery(method, object, objectArray);
    }

    @Override
    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={String.class})})
    protected ResultSet postStmtExecuteQuery(Method method, ResultSet resultSet) {
        return super.postStmtExecuteQuery(method, resultSet);
    }

    @Override
    @Post
    @Methods(signatures={@Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected Object postStmtExecuteUpdate(Method method, Object object) {
        return super.postStmtExecuteUpdate(method, object);
    }

    public ResultSet getReturnResultSet() throws SQLException {
        ResultSet resultSet;
        block14: {
            resultSet = null;
            AbstractShardingConnection abstractShardingConnection = (AbstractShardingConnection)this.getCreator();
            try (Monitor.CloseableLock closeableLock = abstractShardingConnection.acquireConnectionCloseableLock();){
                OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getDelegate();
                if (oraclePreparedStatement != null) {
                    resultSet = oraclePreparedStatement.getReturnResultSet();
                    if (resultSet != null) {
                        resultSet = this.createResultSetProxy(resultSet);
                        this.currentResultSet = (AbstractShardingResultSet)((Object)resultSet);
                    }
                    break block14;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
        }
        return resultSet;
    }

    public void setExecuteBatch(int n2) throws SQLException {
    }

    public int getExecuteBatch() {
        return 1;
    }

    public void clearParameters() throws SQLException {
        AbstractShardingConnection abstractShardingConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock closeableLock = abstractShardingConnection.acquireConnectionCloseableLock();){
            OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getDelegate();
            if (oraclePreparedStatement != null) {
                oraclePreparedStatement.clearParameters();
            }
            this.clearBindParams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterMetaData getParameterMetaData() throws SQLException {
        AbstractShardingConnection abstractShardingConnection = (AbstractShardingConnection)this.getCreator();
        OracleConnection oracleConnection = null;
        OraclePreparedStatement oraclePreparedStatement = null;
        Throwable throwable = null;
        try (Monitor.CloseableLock closeableLock = abstractShardingConnection.acquireConnectionCloseableLock();){
            ParameterMetaData parameterMetaData;
            block20: {
                oraclePreparedStatement = (OraclePreparedStatement)this.getDelegate();
                if (oraclePreparedStatement != null) {
                    ParameterMetaData parameterMetaData2 = oraclePreparedStatement.getParameterMetaData();
                    return parameterMetaData2;
                }
                try {
                    oracleConnection = (OracleConnection)abstractShardingConnection.getCatalogDatabaseConnection();
                    oraclePreparedStatement = (OraclePreparedStatement)this.createDatabaseStatement(oracleConnection, this.originalSql);
                    this.delegatesBindCalls(oraclePreparedStatement, this.bindMap);
                    parameterMetaData = oraclePreparedStatement.getParameterMetaData();
                    if (oraclePreparedStatement == null) break block20;
                }
                catch (Throwable throwable2) {
                    try {
                        if (oraclePreparedStatement != null) {
                            oraclePreparedStatement.close();
                        }
                        abstractShardingConnection.closeDatabaseConnection(oracleConnection);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                oraclePreparedStatement.close();
            }
            abstractShardingConnection.closeDatabaseConnection(oracleConnection);
            return parameterMetaData;
        }
    }

    public String getOriginalSql() throws SQLException {
        return this.originalSql;
    }

    public void addBatch() throws SQLException {
        try (Monitor.CloseableLock closeableLock = ((AbstractShardingConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.bindBatchList.add(this.bindMap);
            this.bindMap = new ConcurrentHashMap();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public int[] executeBatch() throws SQLException {
        AbstractShardingConnection abstractShardingConnection = (AbstractShardingConnection)this.getCreator();
        OracleConnection oracleConnection = null;
        OraclePreparedStatement oraclePreparedStatement = null;
        try {
            try (Monitor.CloseableLock closeableLock = abstractShardingConnection.acquireConnectionCloseableLock();){
                oracleConnection = (OracleConnection)abstractShardingConnection.getCatalogDatabaseConnection();
                oraclePreparedStatement = (OraclePreparedStatement)this.createDatabaseStatement(oracleConnection, this.originalSql);
                this.setDelegate(oraclePreparedStatement);
                this.delegatesBindBatchCalls(oraclePreparedStatement);
                int[] nArray = oraclePreparedStatement.executeBatch();
                return nArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.clearBatchItems();
        }
    }

    @Override
    public void close() throws SQLException {
        AbstractShardingConnection abstractShardingConnection = (AbstractShardingConnection)this.getCreator();
        try (Monitor.CloseableLock closeableLock = abstractShardingConnection.acquireConnectionCloseableLock();){
            this.clearBindParams();
            this.clearBatchItems();
            super.close();
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="enterImplicitCache", args={}), @Signature(name="enterExplicitCache", args={}), @Signature(name="exitImplicitCacheToActive", args={}), @Signature(name="exitExplicitCacheToActive", args={}), @Signature(name="exitImplicitCacheToClose", args={}), @Signature(name="exitExplicitCacheToClose", args={}), @Signature(name="setDisableStmtCaching", args={boolean.class}), @Signature(name="OracleGetParameterMetaData", args={})})
    protected void preUnsupportedPreparedStatementMethods(Method method, Object object, Object ... objectArray) {
        throw new RuntimeException((SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace());
    }

    @Override
    @Pre
    @Methods(signatures={@Signature(name="creationState", args={}), @Signature(name="setACProxy", args={Object.class}), @Signature(name="getACProxy", args={}), @Signature(name="setShardingKeyRpnTokens", args={byte[].class}), @Signature(name="getShardingKeyRpnTokens", args={}), @Signature(name="setCursorName", args={String.class}), @Signature(name="getserverCursor", args={})})
    protected void preUnsupportedStatementMethods(Method method, Object object, Object ... objectArray) {
        super.preUnsupportedStatementMethods(method, object, objectArray);
    }

    private OraclePreparedStatement checkForKeyTokensAndGetUCPPreparedStatement(String string) throws SQLException {
        OracleConnection oracleConnection = this.checkForKeyTokensAndGetUCPConnection(string);
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.createDatabaseStatement(oracleConnection, string);
        this.setDelegate(oraclePreparedStatement);
        return oraclePreparedStatement;
    }

    protected OracleStatement createDatabaseStatement(OracleConnection oracleConnection, String string) throws SQLException {
        OraclePreparedStatement oraclePreparedStatement = null;
        oraclePreparedStatement = this.autoGeneratedKeys != -1 ? (OraclePreparedStatement)oracleConnection.prepareStatement(string, this.autoGeneratedKeys) : (this.columnIndexes != null ? (OraclePreparedStatement)oracleConnection.prepareStatement(string, this.columnIndexes) : (this.columnNames != null ? (OraclePreparedStatement)oracleConnection.prepareStatement(string, this.columnNames) : (OraclePreparedStatement)oracleConnection.prepareStatement(string, this.userResultSetType, this.userResultSetConcur)));
        return oraclePreparedStatement;
    }

    void delegatesBindCalls(OraclePreparedStatement oraclePreparedStatement, ConcurrentHashMap<Integer, AbstractShardingStatement.CallHistoryEntry> concurrentHashMap) throws SQLException {
        try {
            for (AbstractShardingStatement.CallHistoryEntry callHistoryEntry : concurrentHashMap.values()) {
                Method method = oraclePreparedStatement.getClass().getMethod(callHistoryEntry.methodName, callHistoryEntry.argsType);
                method.invoke((Object)oraclePreparedStatement, callHistoryEntry.args);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            throw new SQLException(exception);
        }
    }

    void delegatesBindBatchCalls(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        for (ConcurrentHashMap<Integer, AbstractShardingStatement.CallHistoryEntry> concurrentHashMap : this.bindBatchList) {
            this.delegatesBindCalls(oraclePreparedStatement, concurrentHashMap);
            oraclePreparedStatement.addBatch();
        }
    }

    void delegatesBeforePstmtExecuteCalls(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        try {
            AbstractShardingStatement.CallHistoryEntry callHistoryEntry = this.head;
            while (callHistoryEntry != this.tail) {
                Method method = oraclePreparedStatement.getClass().getMethod(callHistoryEntry.methodName, callHistoryEntry.argsType);
                method.invoke((Object)oraclePreparedStatement, callHistoryEntry.args);
                callHistoryEntry = callHistoryEntry.nextEntry;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            throw new SQLException(exception);
        }
    }

    Object getBindValue(int n2, int n3) {
        AbstractShardingStatement.CallHistoryEntry callHistoryEntry = this.bindMap.get(n2);
        if (callHistoryEntry != null) {
            return callHistoryEntry.args[1];
        }
        return null;
    }

    int addNamedPara(String string) throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        String string2 = string.toUpperCase().intern();
        for (int i2 = 0; i2 < this.parameterCount; ++i2) {
            if (string2 != this.namedParameters[i2]) continue;
            return i2 + 1;
        }
        if (this.parameterCount >= this.namedParameters.length) {
            String[] stringArray = new String[this.namedParameters.length * 2];
            System.arraycopy(this.namedParameters, 0, stringArray, 0, this.namedParameters.length);
            this.namedParameters = stringArray;
        }
        this.namedParameters[this.parameterCount++] = string2;
        return this.parameterCount;
    }

    void clearBindParams() {
        this.namedParameters = new String[8];
        this.parameterCount = 0;
        this.bindMap.clear();
    }

    @Override
    void clearBatchItems() {
        this.bindBatchList.clear();
    }
}

