/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.simple.extend.form;

import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.simple.extend.XhtmlForm;
import com.openhtmltopdf.simple.extend.form.ButtonField;
import com.openhtmltopdf.simple.extend.form.CheckboxField;
import com.openhtmltopdf.simple.extend.form.FileField;
import com.openhtmltopdf.simple.extend.form.FormField;
import com.openhtmltopdf.simple.extend.form.HiddenField;
import com.openhtmltopdf.simple.extend.form.ImageField;
import com.openhtmltopdf.simple.extend.form.PasswordField;
import com.openhtmltopdf.simple.extend.form.RadioButtonField;
import com.openhtmltopdf.simple.extend.form.ResetField;
import com.openhtmltopdf.simple.extend.form.SelectField;
import com.openhtmltopdf.simple.extend.form.SubmitField;
import com.openhtmltopdf.simple.extend.form.TextAreaField;
import com.openhtmltopdf.simple.extend.form.TextField;
import org.w3c.dom.Element;

public class FormFieldFactory {
    private FormFieldFactory() {
    }

    public static FormField create(XhtmlForm form, LayoutContext context, BlockBox box) {
        String typeKey = null;
        Element e = box.getElement();
        if (e.getNodeName().equals("input")) {
            typeKey = e.getAttribute("type");
        } else if (e.getNodeName().equals("textarea")) {
            typeKey = "textarea";
        } else if (e.getNodeName().equals("select")) {
            typeKey = "select";
        } else {
            return null;
        }
        if (typeKey.equals("submit")) {
            return new SubmitField(e, form, context, box);
        }
        if (typeKey.equals("reset")) {
            return new ResetField(e, form, context, box);
        }
        if (typeKey.equals("button")) {
            return new ButtonField(e, form, context, box);
        }
        if (typeKey.equals("image")) {
            return new ImageField(e, form, context, box);
        }
        if (typeKey.equals("hidden")) {
            return new HiddenField(e, form, context, box);
        }
        if (typeKey.equals("password")) {
            return new PasswordField(e, form, context, box);
        }
        if (typeKey.equals("checkbox")) {
            return new CheckboxField(e, form, context, box);
        }
        if (typeKey.equals("radio")) {
            return new RadioButtonField(e, form, context, box);
        }
        if (typeKey.equals("file")) {
            return new FileField(e, form, context, box);
        }
        if (typeKey.equals("textarea")) {
            return new TextAreaField(e, form, context, box);
        }
        if (typeKey.equals("select")) {
            return new SelectField(e, form, context, box);
        }
        return new TextField(e, form, context, box);
    }
}

