/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.jcip.annotations.Immutable;

@Immutable
public class UserInfoRequest
extends ProtectedResourceRequest {
    private final HTTPRequest.Method httpMethod;

    public UserInfoRequest(URI uri, BearerAccessToken accessToken) {
        this(uri, HTTPRequest.Method.GET, accessToken);
    }

    public UserInfoRequest(URI uri, HTTPRequest.Method httpMethod, BearerAccessToken accessToken) {
        super(uri, accessToken);
        if (httpMethod == null) {
            throw new IllegalArgumentException("The HTTP method must not be null");
        }
        this.httpMethod = httpMethod;
        if (accessToken == null) {
            throw new IllegalArgumentException("The access token must not be null");
        }
    }

    public HTTPRequest.Method getMethod() {
        return this.httpMethod;
    }

    @Override
    public HTTPRequest toHTTPRequest() throws SerializeException {
        URL endpointURL;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        try {
            endpointURL = this.getEndpointURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new SerializeException(e.getMessage(), e);
        }
        HTTPRequest httpRequest = new HTTPRequest(this.httpMethod, endpointURL);
        switch (this.httpMethod) {
            case GET: {
                httpRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
                break;
            }
            case POST: {
                httpRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
                httpRequest.setQuery("access_token=" + this.getAccessToken().getValue());
                break;
            }
            default: {
                throw new SerializeException("Unexpected HTTP method: " + (Object)((Object)this.httpMethod));
            }
        }
        return httpRequest;
    }

    public static UserInfoRequest parse(HTTPRequest httpRequest) throws ParseException {
        URI endpointURI;
        HTTPRequest.Method httpMethod = httpRequest.getMethod();
        BearerAccessToken accessToken = BearerAccessToken.parse(httpRequest);
        try {
            endpointURI = httpRequest.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), e);
        }
        return new UserInfoRequest(endpointURI, httpMethod, accessToken);
    }
}

