/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.client;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class ClientInformation {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final ClientID id;
    private final Date issueDate;
    private final ClientMetadata metadata;
    private final Secret secret;
    private final URI registrationURI;
    private final BearerAccessToken accessToken;

    public ClientInformation(ClientID id, Date issueDate, ClientMetadata metadata, Secret secret) {
        this(id, issueDate, metadata, secret, null, null);
    }

    public ClientInformation(ClientID id, Date issueDate, ClientMetadata metadata, Secret secret, URI registrationURI, BearerAccessToken accessToken) {
        if (id == null) {
            throw new IllegalArgumentException("The client identifier must not be null");
        }
        this.id = id;
        this.issueDate = issueDate;
        if (metadata == null) {
            throw new IllegalArgumentException("The client metadata must not be null");
        }
        this.metadata = metadata;
        this.secret = secret;
        this.registrationURI = registrationURI;
        this.accessToken = accessToken;
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public ClientID getID() {
        return this.id;
    }

    public Date getIDIssueDate() {
        return this.issueDate;
    }

    public ClientMetadata getMetadata() {
        return this.metadata;
    }

    public Secret getSecret() {
        return this.secret;
    }

    public URI getRegistrationURI() {
        return this.registrationURI;
    }

    public BearerAccessToken getRegistrationAccessToken() {
        return this.accessToken;
    }

    public JSONObject toJSONObject() {
        JSONObject o = this.metadata.toJSONObject();
        o.put((Object)"client_id", (Object)this.id.getValue());
        if (this.issueDate != null) {
            o.put((Object)"client_id_issued_at", (Object)(this.issueDate.getTime() / 1000L));
        }
        if (this.secret != null) {
            o.put((Object)"client_secret", (Object)this.secret.getValue());
            if (this.secret.getExpirationDate() != null) {
                o.put((Object)"client_secret_expires_at", (Object)(this.secret.getExpirationDate().getTime() / 1000L));
            } else {
                o.put((Object)"client_secret_expires_at", (Object)0L);
            }
        }
        if (this.registrationURI != null) {
            o.put((Object)"registration_client_uri", (Object)this.registrationURI.toString());
        }
        if (this.accessToken != null) {
            o.put((Object)"registration_access_token", (Object)this.accessToken.getValue());
        }
        return o;
    }

    public static ClientInformation parse(JSONObject jsonObject) throws ParseException {
        ClientID id = new ClientID(JSONObjectUtils.getString(jsonObject, "client_id"));
        Date issueDate = null;
        if (jsonObject.containsKey((Object)"client_id_issued_at")) {
            issueDate = new Date(JSONObjectUtils.getLong(jsonObject, "client_id_issued_at") * 1000L);
        }
        ClientMetadata metadata = ClientMetadata.parse(jsonObject);
        Secret secret = null;
        if (jsonObject.containsKey((Object)"client_secret")) {
            long t;
            String value = JSONObjectUtils.getString(jsonObject, "client_secret");
            Date exp = null;
            if (jsonObject.containsKey((Object)"client_secret_expires_at") && (t = JSONObjectUtils.getLong(jsonObject, "client_secret_expires_at")) > 0L) {
                exp = new Date(t * 1000L);
            }
            secret = new Secret(value, exp);
        }
        URI registrationURI = null;
        if (jsonObject.containsKey((Object)"registration_client_uri")) {
            registrationURI = JSONObjectUtils.getURI(jsonObject, "registration_client_uri");
        }
        BearerAccessToken accessToken = null;
        if (jsonObject.containsKey((Object)"registration_access_token")) {
            accessToken = new BearerAccessToken(JSONObjectUtils.getString(jsonObject, "registration_access_token"));
        }
        return new ClientInformation(id, issueDate, metadata, secret, registrationURI, accessToken);
    }

    static {
        HashSet<String> p = new HashSet<String>(ClientMetadata.getRegisteredParameterNames());
        p.add("client_id");
        p.add("client_id_issued_at");
        p.add("client_secret");
        p.add("client_secret_expires_at");
        p.add("registration_access_token");
        p.add("registration_client_uri");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(p);
    }
}

