/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;

final class Datapoint {
    static final Datapoint UNKNOWN = new Datapoint(0L, -1L);
    private final long timestamp;
    private final long value;

    Datapoint(long timestamp, long value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    boolean isUnknown() {
        return this.timestamp == 0L;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    long getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.timestamp, this.value});
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Datapoint)) {
            return false;
        }
        Datapoint dp = (Datapoint)obj;
        return this.timestamp == dp.timestamp && this.value == dp.value;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("timestamp", this.timestamp).add("value", this.value).toString();
    }
}

