/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.utils;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.exception.FallbackDefinitionException;
import com.netflix.hystrix.contrib.javanica.utils.TypeHelper;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class FallbackMethod {
    private final Method method;
    private final boolean extended;
    private final boolean defaultFallback;
    private ExecutionType executionType;
    public static final FallbackMethod ABSENT = new FallbackMethod(null, false, false);
    private static final Result SUCCESS = Result.success();

    public FallbackMethod(Method method) {
        this(method, false, false);
    }

    public FallbackMethod(Method method, boolean extended, boolean defaultFallback) {
        this.method = method;
        this.extended = extended;
        this.defaultFallback = defaultFallback;
        if (method != null) {
            this.executionType = ExecutionType.getExecutionType(method.getReturnType());
        }
    }

    public boolean isCommand() {
        return this.method.isAnnotationPresent(HystrixCommand.class);
    }

    public boolean isPresent() {
        return this.method != null;
    }

    public Method getMethod() {
        return this.method;
    }

    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean isDefault() {
        return this.defaultFallback;
    }

    public void validateReturnType(Method commandMethod) throws FallbackDefinitionException {
        if (this.isPresent()) {
            Class<?> commandReturnType = commandMethod.getReturnType();
            if (ExecutionType.OBSERVABLE == ExecutionType.getExecutionType(commandReturnType)) {
                if (ExecutionType.OBSERVABLE != this.getExecutionType()) {
                    Type commandParametrizedType = commandMethod.getGenericReturnType();
                    if (TypeHelper.isReturnTypeParametrized(commandMethod)) {
                        commandParametrizedType = this.getFirstParametrizedType(commandMethod);
                    }
                    this.validateParametrizedType(commandParametrizedType, this.method.getGenericReturnType(), commandMethod, this.method);
                } else {
                    this.validateReturnType(commandMethod, this.method);
                }
            } else if (ExecutionType.ASYNCHRONOUS == ExecutionType.getExecutionType(commandReturnType)) {
                if (this.isCommand() && ExecutionType.ASYNCHRONOUS == this.getExecutionType()) {
                    this.validateReturnType(commandMethod, this.method);
                }
                if (ExecutionType.ASYNCHRONOUS != this.getExecutionType()) {
                    Type commandParametrizedType = commandMethod.getGenericReturnType();
                    if (TypeHelper.isReturnTypeParametrized(commandMethod)) {
                        commandParametrizedType = this.getFirstParametrizedType(commandMethod);
                    }
                    this.validateParametrizedType(commandParametrizedType, this.method.getGenericReturnType(), commandMethod, this.method);
                }
                if (!this.isCommand() && ExecutionType.ASYNCHRONOUS == this.getExecutionType()) {
                    throw new FallbackDefinitionException(this.createErrorMsg(commandMethod, this.method, "fallback cannot return Future if the fallback isn't command when the command is async."));
                }
            } else {
                if (ExecutionType.ASYNCHRONOUS == this.getExecutionType()) {
                    throw new FallbackDefinitionException(this.createErrorMsg(commandMethod, this.method, "fallback cannot return Future if command isn't asynchronous."));
                }
                if (ExecutionType.OBSERVABLE == this.getExecutionType()) {
                    throw new FallbackDefinitionException(this.createErrorMsg(commandMethod, this.method, "fallback cannot return Observable if command isn't observable."));
                }
                this.validateReturnType(commandMethod, this.method);
            }
        }
    }

    private Type getFirstParametrizedType(Method m) {
        Type gtype = m.getGenericReturnType();
        if (gtype instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)gtype;
            return pType.getActualTypeArguments()[0];
        }
        return null;
    }

    private void validateReturnType(Method commandMethod, Method fallbackMethod) {
        if (TypeHelper.isGenericReturnType(commandMethod)) {
            List<Type> commandParametrizedTypes = TypeHelper.flattenTypeVariables(commandMethod.getGenericReturnType());
            List<Type> fallbackParametrizedTypes = TypeHelper.flattenTypeVariables(fallbackMethod.getGenericReturnType());
            Result result = this.equalsParametrizedTypes(commandParametrizedTypes, fallbackParametrizedTypes);
            if (!result.success) {
                ArrayList<String> msg = new ArrayList<String>();
                for (Error error : result.errors) {
                    Type parentKind;
                    Optional<Type> parentKindOpt = FallbackMethod.getParentKind(error.commandType, commandParametrizedTypes);
                    String extraHint = "";
                    if (parentKindOpt.isPresent() && TypeHelper.isParametrizedType(parentKind = (Type)parentKindOpt.get())) {
                        extraHint = "--> " + ((ParameterizedType)parentKind).getRawType().toString() + "<Ooops!>\n";
                    }
                    msg.add(String.format(error.reason + "\n" + extraHint + "Command type literal pos: %s; Fallback type literal pos: %s", FallbackMethod.positionAsString(error.commandType, commandParametrizedTypes), FallbackMethod.positionAsString(error.fallbackType, fallbackParametrizedTypes)));
                }
                throw new FallbackDefinitionException(this.createErrorMsg(commandMethod, this.method, StringUtils.join(msg, (String)"\n")));
            }
        }
        this.validatePlainReturnType(commandMethod, fallbackMethod);
    }

    private void validatePlainReturnType(Method commandMethod, Method fallbackMethod) {
        this.validatePlainReturnType(commandMethod.getReturnType(), fallbackMethod.getReturnType(), commandMethod, fallbackMethod);
    }

    private void validatePlainReturnType(Class<?> commandReturnType, Class<?> fallbackReturnType, Method commandMethod, Method fallbackMethod) {
        if (!commandReturnType.isAssignableFrom(fallbackReturnType)) {
            throw new FallbackDefinitionException(this.createErrorMsg(commandMethod, fallbackMethod, "Fallback method '" + fallbackMethod + "' must return: " + commandReturnType + " or its subclass"));
        }
    }

    private void validateParametrizedType(Type commandReturnType, Type fallbackReturnType, Method commandMethod, Method fallbackMethod) {
        if (!commandReturnType.equals(fallbackReturnType)) {
            throw new FallbackDefinitionException(this.createErrorMsg(commandMethod, fallbackMethod, "Fallback method '" + fallbackMethod + "' must return: " + commandReturnType + " or its subclass"));
        }
    }

    private String createErrorMsg(Method commandMethod, Method fallbackMethod, String hint) {
        return "Incompatible return types. \nCommand method: " + commandMethod + ";\nFallback method: " + fallbackMethod + ";\n" + (StringUtils.isNotBlank((CharSequence)hint) ? "Hint: " + hint : "");
    }

    private Result equalsParametrizedTypes(List<Type> commandParametrizedTypes, List<Type> fallbackParametrizedTypes) {
        if (commandParametrizedTypes.size() != fallbackParametrizedTypes.size()) {
            return Result.failure(Collections.singletonList(new Error("Different size of types variables.\nCommand  type literals size = " + commandParametrizedTypes.size() + ": " + commandParametrizedTypes + "\nFallback type literals size = " + fallbackParametrizedTypes.size() + ": " + fallbackParametrizedTypes + "\n")));
        }
        for (int i = 0; i < commandParametrizedTypes.size(); ++i) {
            Type commandParametrizedType = commandParametrizedTypes.get(i);
            Type fallbackParametrizedType = fallbackParametrizedTypes.get(i);
            Result result = FallbackMethod.equals(commandParametrizedType, fallbackParametrizedType);
            if (result.success) continue;
            return result;
        }
        return SUCCESS;
    }

    private static Result equals(Type commandType, Type fallbackType) {
        if (TypeHelper.isParametrizedType(commandType) && TypeHelper.isParametrizedType(fallbackType)) {
            final ParameterizedType pt1 = (ParameterizedType)commandType;
            final ParameterizedType pt2 = (ParameterizedType)fallbackType;
            Result result = FallbackMethod.regularEquals(pt1.getRawType(), pt2.getRawType());
            return result.andThen(new Supplier<Result>(){

                public Result get() {
                    return FallbackMethod.equals(pt1.getActualTypeArguments(), pt2.getActualTypeArguments());
                }
            });
        }
        if (TypeHelper.isTypeVariable(commandType) && TypeHelper.isTypeVariable(fallbackType)) {
            final TypeVariable tv1 = (TypeVariable)commandType;
            final TypeVariable tv2 = (TypeVariable)fallbackType;
            if (tv1.getGenericDeclaration() instanceof Method && tv2.getGenericDeclaration() instanceof Method) {
                Result result = FallbackMethod.equals(tv1.getBounds(), tv2.getBounds());
                return result.append(new Supplier<List<Error>>(){

                    public List<Error> get() {
                        return Collections.singletonList(FallbackMethod.boundsError(tv1, tv1.getBounds(), "", tv2, tv2.getBounds()));
                    }
                });
            }
            return FallbackMethod.regularEquals(tv1, tv2);
        }
        if (TypeHelper.isWildcardType(commandType) && TypeHelper.isWildcardType(fallbackType)) {
            final WildcardType wt1 = (WildcardType)commandType;
            final WildcardType wt2 = (WildcardType)fallbackType;
            Result result = FallbackMethod.equals(wt1.getLowerBounds(), wt2.getLowerBounds());
            if ((result = result.append(new Supplier<List<Error>>(){

                public List<Error> get() {
                    return Collections.singletonList(FallbackMethod.boundsError(wt1, wt1.getLowerBounds(), "lower", wt2, wt2.getLowerBounds()));
                }
            })).isFailure()) {
                return result;
            }
            result = FallbackMethod.equals(wt1.getUpperBounds(), wt2.getUpperBounds());
            return result.append(new Supplier<List<Error>>(){

                public List<Error> get() {
                    return Collections.singletonList(FallbackMethod.boundsError(wt1, wt1.getUpperBounds(), "upper", wt2, wt2.getUpperBounds()));
                }
            });
        }
        return FallbackMethod.regularEquals(commandType, fallbackType);
    }

    private static Result regularEquals(final Type commandType, final Type fallbackType) {
        return Result.of(Objects.equal((Object)commandType, (Object)fallbackType), new Supplier<List<Error>>(){

            public List<Error> get() {
                return Collections.singletonList(new Error(commandType, String.format("Different types. Command type: '%s'; fallback type: '%s'", commandType, fallbackType), fallbackType));
            }
        });
    }

    private static Optional<Type> getParentKind(Type type, List<Type> types) {
        int pos = FallbackMethod.position(type, types);
        if (pos <= 0) {
            return Optional.absent();
        }
        return Optional.of((Object)types.get(pos - 1));
    }

    private static String positionAsString(Type type, List<Type> types) {
        int pos = FallbackMethod.position(type, types);
        if (pos < 0) {
            return "unknown";
        }
        return String.valueOf(pos);
    }

    private static int position(Type type, List<Type> types) {
        if (type == null) {
            return -1;
        }
        if (types == null || types.isEmpty()) {
            return -1;
        }
        return types.indexOf(type);
    }

    private static Error boundsError(Type t1, Type[] b1, String boundType, Type t2, Type[] b2) {
        return new Error(t1, String.format("Different %s bounds. Command bounds: '%s'; Fallback bounds: '%s'", boundType, StringUtils.join((Object[])b1, (String)", "), StringUtils.join((Object[])b2, (String)", ")), t2);
    }

    private static Result equals(Type[] t1, Type[] t2) {
        if (t1 == null && t2 == null) {
            return SUCCESS;
        }
        if (t1 == null) {
            return Result.failure();
        }
        if (t2 == null) {
            return Result.failure();
        }
        if (t1.length != t2.length) {
            return Result.failure(new Error(String.format("Different size of type literals. Command size = %d, fallback size = %d", t1.length, t2.length)));
        }
        Result result = SUCCESS;
        for (int i = 0; i < t1.length; ++i) {
            if (!(result = result.combine(FallbackMethod.equals(t1[i], t2[i]))).isFailure()) continue;
            return result;
        }
        return result;
    }

    private static class Error {
        @Nullable
        Type commandType;
        String reason;
        @Nullable
        Type fallbackType;

        Error(String reason) {
            this.reason = reason;
        }

        Error(Type commandType, String reason, Type fallbackType) {
            this.commandType = commandType;
            this.reason = reason;
            this.fallbackType = fallbackType;
        }
    }

    private static class Result {
        boolean success;
        List<Error> errors = Collections.emptyList();

        boolean isSuccess() {
            return this.success;
        }

        boolean isFailure() {
            return !this.success;
        }

        static Result of(boolean res, Supplier<List<Error>> errors) {
            if (res) {
                return Result.success();
            }
            return Result.failure((List)errors.get());
        }

        static Result success() {
            return new Result(true);
        }

        static Result failure() {
            return new Result(false);
        }

        static Result failure(Error ... errors) {
            return new Result(false, Arrays.asList(errors));
        }

        static Result failure(List<Error> errors) {
            return new Result(false, errors);
        }

        Result combine(Result r) {
            return new Result(this.success && r.success, Result.merge(this.errors, r.errors));
        }

        Result andThen(Supplier<Result> resultSupplier) {
            if (!this.success) {
                return this;
            }
            return (Result)resultSupplier.get();
        }

        Result append(List<Error> errors) {
            if (this.success) {
                return this;
            }
            return Result.failure(Result.merge(this.errors, errors));
        }

        Result append(Supplier<List<Error>> errors) {
            if (this.success) {
                return this;
            }
            return this.append((List)errors.get());
        }

        static List<Error> merge(@Nonnull List<Error> e1, @Nonnull List<Error> e2) {
            ArrayList<Error> res = new ArrayList<Error>(e1.size() + e2.size());
            res.addAll(e1);
            res.addAll(e2);
            return Collections.unmodifiableList(res);
        }

        Result(boolean success, List<Error> errors) {
            Validate.notNull(errors, (String)"errors cannot be null", (Object[])new Object[0]);
            this.success = success;
            this.errors = errors;
        }

        Result(boolean success) {
            this.success = success;
            this.errors = Collections.emptyList();
        }
    }
}

