/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.contrib.javanica.command.CommandAction;

public class CommandActions {
    private final CommandAction commandAction;
    private final CommandAction fallbackAction;

    public CommandActions(Builder builder) {
        this.commandAction = builder.commandAction;
        this.fallbackAction = builder.fallbackAction;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CommandAction getCommandAction() {
        return this.commandAction;
    }

    public CommandAction getFallbackAction() {
        return this.fallbackAction;
    }

    public boolean hasFallbackAction() {
        return this.fallbackAction != null;
    }

    public static class Builder {
        private CommandAction commandAction;
        private CommandAction fallbackAction;

        public Builder commandAction(CommandAction pCommandAction) {
            this.commandAction = pCommandAction;
            return this;
        }

        public Builder fallbackAction(CommandAction pFallbackAction) {
            this.fallbackAction = pFallbackAction;
            return this;
        }

        public CommandActions build() {
            return new CommandActions(this);
        }
    }
}

