/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.collapser;

import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.collapser.CollapsedRequestSubject;
import com.netflix.hystrix.collapser.HystrixCollapserBridge;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Action1;

public class RequestBatch<BatchReturnType, ResponseType, RequestArgumentType> {
    private static final Logger logger = LoggerFactory.getLogger(RequestBatch.class);
    private final HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser;
    private final int maxBatchSize;
    private final AtomicBoolean batchStarted = new AtomicBoolean();
    private final ConcurrentMap<RequestArgumentType, HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>> argumentMap = new ConcurrentHashMap<RequestArgumentType, HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>>();
    private final HystrixCollapserProperties properties;
    private ReentrantReadWriteLock batchLock = new ReentrantReadWriteLock();

    public RequestBatch(HystrixCollapserProperties properties, HystrixCollapserBridge<BatchReturnType, ResponseType, RequestArgumentType> commandCollapser, int maxBatchSize) {
        this.properties = properties;
        this.commandCollapser = commandCollapser;
        this.maxBatchSize = maxBatchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Observable<ResponseType> offer(RequestArgumentType arg) {
        if (this.batchStarted.get()) {
            return null;
        }
        if (this.batchLock.readLock().tryLock()) {
            try {
                if (this.batchStarted.get()) {
                    Observable<ResponseType> observable = null;
                    return observable;
                }
                if (this.argumentMap.size() >= this.maxBatchSize) {
                    Observable<ResponseType> observable = null;
                    return observable;
                }
                CollapsedRequestSubject collapsedRequest = new CollapsedRequestSubject(arg, this);
                CollapsedRequestSubject existing = this.argumentMap.putIfAbsent(arg, collapsedRequest);
                if (existing != null) {
                    boolean requestCachingEnabled = this.properties.requestCacheEnabled().get();
                    if (requestCachingEnabled) {
                        Observable observable = existing.toObservable();
                        return observable;
                    }
                    Observable observable = Observable.error((Throwable)new IllegalArgumentException("Duplicate argument in collapser batch : [" + arg + "]  This is not supported.  Please turn request-caching on for HystrixCollapser:" + this.commandCollapser.getCollapserKey().name() + " or prevent duplicates from making it into the batch!"));
                    return observable;
                }
                Observable observable = collapsedRequest.toObservable();
                return observable;
            }
            finally {
                this.batchLock.readLock().unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(RequestArgumentType arg) {
        if (this.batchStarted.get()) {
            return;
        }
        if (this.batchLock.readLock().tryLock()) {
            try {
                if (this.batchStarted.get()) {
                    return;
                }
                this.argumentMap.remove(arg);
            }
            finally {
                this.batchLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatchIfNotAlreadyStarted() {
        if (this.batchStarted.compareAndSet(false, true)) {
            this.batchLock.writeLock().lock();
            try {
                Collection<Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>>> shards = this.commandCollapser.shardRequests(this.argumentMap.values());
                for (final Collection<HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType>> shardRequests : shards) {
                    try {
                        Observable<BatchReturnType> o = this.commandCollapser.createObservableCommand(shardRequests);
                        this.commandCollapser.mapResponseToRequests(o, shardRequests).doOnError((Action1)new Action1<Throwable>(){

                            public void call(Throwable e) {
                                Exception ee = e instanceof Exception ? (Exception)e : new RuntimeException("Throwable caught while executing batch and mapping responses.", e);
                                logger.debug("Exception mapping responses to requests.", e);
                                for (HystrixCollapser.CollapsedRequest request : RequestBatch.this.argumentMap.values()) {
                                    try {
                                        ((CollapsedRequestSubject)request).setExceptionIfResponseNotReceived(ee);
                                    }
                                    catch (IllegalStateException e2) {
                                        logger.error("Partial success of 'mapResponseToRequests' resulted in IllegalStateException while setting Exception. Continuing ... ", (Throwable)e2);
                                    }
                                }
                            }
                        }).doOnCompleted(new Action0(){

                            public void call() {
                                Exception e = null;
                                for (HystrixCollapser.CollapsedRequest request : shardRequests) {
                                    try {
                                        e = ((CollapsedRequestSubject)request).setExceptionIfResponseNotReceived(e, "No response set by " + RequestBatch.this.commandCollapser.getCollapserKey().name() + " 'mapResponseToRequests' implementation.");
                                    }
                                    catch (IllegalStateException e2) {
                                        logger.debug("Partial success of 'mapResponseToRequests' resulted in IllegalStateException while setting 'No response set' Exception. Continuing ... ", (Throwable)e2);
                                    }
                                }
                            }
                        }).subscribe();
                    }
                    catch (Exception e) {
                        logger.error("Exception while creating and queueing command with batch.", (Throwable)e);
                        for (HystrixCollapser.CollapsedRequest<ResponseType, RequestArgumentType> request : shardRequests) {
                            try {
                                request.setException(e);
                            }
                            catch (IllegalStateException e2) {
                                logger.debug("Failed trying to setException on CollapsedRequest", (Throwable)e2);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("Exception while sharding requests.", (Throwable)e);
                for (HystrixCollapser.CollapsedRequest request : this.argumentMap.values()) {
                    try {
                        request.setException(e);
                    }
                    catch (IllegalStateException e2) {
                        logger.debug("Failed trying to setException on CollapsedRequest", (Throwable)e2);
                    }
                }
            }
            finally {
                this.batchLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        block7: {
            if (this.batchStarted.compareAndSet(false, true)) {
                this.batchLock.writeLock().lock();
                try {
                    if (this.argumentMap.size() <= 0) break block7;
                    logger.warn("Requests still exist in queue but will not be executed due to RequestCollapser shutdown: " + this.argumentMap.size(), (Throwable)new IllegalStateException());
                    for (HystrixCollapser.CollapsedRequest request : this.argumentMap.values()) {
                        try {
                            ((CollapsedRequestSubject)request).setExceptionIfResponseNotReceived(new IllegalStateException("Requests not executed before shutdown."));
                        }
                        catch (Exception e) {
                            logger.debug("Failed to setException on CollapsedRequestFutureImpl instances.", (Throwable)e);
                        }
                        logger.warn("Request still in queue but not be executed due to RequestCollapser shutdown. Argument => " + request.getArgument() + "   Request Object => " + request, (Throwable)new IllegalStateException());
                    }
                }
                finally {
                    this.batchLock.writeLock().unlock();
                }
            }
        }
    }

    public int getSize() {
        return this.argumentMap.size();
    }
}

