/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.registry;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.Version;
import com.netflix.eureka.cluster.PeerEurekaNode;
import com.netflix.eureka.cluster.PeerEurekaNodes;
import com.netflix.eureka.registry.AbstractInstanceRegistry;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.registry.RemoteRegionRegistry;
import com.netflix.eureka.registry.rule.DownOrStartingRule;
import com.netflix.eureka.registry.rule.FirstMatchWinsCompositeRule;
import com.netflix.eureka.registry.rule.InstanceStatusOverrideRule;
import com.netflix.eureka.registry.rule.LeaseExistsRule;
import com.netflix.eureka.registry.rule.OverrideExistsRule;
import com.netflix.eureka.resources.ASGResource;
import com.netflix.eureka.resources.CurrentRequestVersion;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.util.MeasuredRate;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TimerTask;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PeerAwareInstanceRegistryImpl
extends AbstractInstanceRegistry
implements PeerAwareInstanceRegistry {
    private static final Logger logger = LoggerFactory.getLogger(PeerAwareInstanceRegistryImpl.class);
    private static final String US_EAST_1 = "us-east-1";
    private static final int PRIME_PEER_NODES_RETRY_MS = 30000;
    private long startupTime = 0L;
    private boolean peerInstancesTransferEmptyOnStartup = true;
    private static final Comparator<Application> APP_COMPARATOR = new Comparator<Application>(){

        @Override
        public int compare(Application l, Application r) {
            return l.getName().compareTo(r.getName());
        }
    };
    private final MeasuredRate numberOfReplicationsLastMin;
    protected final EurekaClient eurekaClient;
    protected volatile PeerEurekaNodes peerEurekaNodes;
    private final InstanceStatusOverrideRule instanceStatusOverrideRule;
    private java.util.Timer timer = new java.util.Timer("ReplicaAwareInstanceRegistry - RenewalThresholdUpdater", true);

    @Inject
    public PeerAwareInstanceRegistryImpl(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, EurekaClient eurekaClient) {
        super(serverConfig, clientConfig, serverCodecs);
        this.eurekaClient = eurekaClient;
        this.numberOfReplicationsLastMin = new MeasuredRate(60000L);
        this.instanceStatusOverrideRule = new FirstMatchWinsCompositeRule(new DownOrStartingRule(), new OverrideExistsRule(this.overriddenInstanceStatusMap), new LeaseExistsRule());
    }

    @Override
    protected InstanceStatusOverrideRule getInstanceInfoOverrideRule() {
        return this.instanceStatusOverrideRule;
    }

    @Override
    public void init(PeerEurekaNodes peerEurekaNodes) throws Exception {
        this.numberOfReplicationsLastMin.start();
        this.peerEurekaNodes = peerEurekaNodes;
        this.initializedResponseCache();
        this.scheduleRenewalThresholdUpdateTask();
        this.initRemoteRegionRegistry();
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register the JMX monitor for the InstanceRegistry :", e);
        }
    }

    @Override
    public void shutdown() {
        try {
            DefaultMonitorRegistry.getInstance().unregister((Monitor)Monitors.newObjectMonitor((Object)this));
        }
        catch (Throwable t) {
            logger.error("Cannot shutdown monitor registry", t);
        }
        try {
            this.peerEurekaNodes.shutdown();
        }
        catch (Throwable t) {
            logger.error("Cannot shutdown ReplicaAwareInstanceRegistry", t);
        }
        this.numberOfReplicationsLastMin.stop();
        super.shutdown();
    }

    private void scheduleRenewalThresholdUpdateTask() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PeerAwareInstanceRegistryImpl.this.updateRenewalThreshold();
            }
        }, this.serverConfig.getRenewalThresholdUpdateIntervalMs(), (long)this.serverConfig.getRenewalThresholdUpdateIntervalMs());
    }

    @Override
    public int syncUp() {
        int count = 0;
        for (int i = 0; i < this.serverConfig.getRegistrySyncRetries() && count == 0; ++i) {
            if (i > 0) {
                try {
                    Thread.sleep(this.serverConfig.getRegistrySyncRetryWaitMs());
                }
                catch (InterruptedException e) {
                    logger.warn("Interrupted during registry transfer..");
                    break;
                }
            }
            Applications apps = this.eurekaClient.getApplications();
            for (Application app : apps.getRegisteredApplications()) {
                for (InstanceInfo instance : app.getInstances()) {
                    try {
                        if (!this.isRegisterable(instance)) continue;
                        this.register(instance, instance.getLeaseInfo().getDurationInSecs(), true);
                        ++count;
                    }
                    catch (Throwable t) {
                        logger.error("During DS init copy", t);
                    }
                }
            }
        }
        return count;
    }

    @Override
    public void openForTraffic(ApplicationInfoManager applicationInfoManager, int count) {
        DataCenterInfo.Name selfName;
        boolean isAws;
        this.expectedNumberOfClientsSendingRenews = count;
        this.updateRenewsPerMinThreshold();
        logger.info("Got {} instances from neighboring DS node", (Object)count);
        logger.info("Renew threshold is: {}", (Object)this.numberOfRenewsPerMinThreshold);
        this.startupTime = System.currentTimeMillis();
        if (count > 0) {
            this.peerInstancesTransferEmptyOnStartup = false;
        }
        boolean bl = isAws = DataCenterInfo.Name.Amazon == (selfName = applicationInfoManager.getInfo().getDataCenterInfo().getName());
        if (isAws && this.serverConfig.shouldPrimeAwsReplicaConnections()) {
            logger.info("Priming AWS connections for all replicas..");
            this.primeAwsReplicas(applicationInfoManager);
        }
        logger.info("Changing status to UP");
        applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.UP);
        super.postInit();
    }

    private void primeAwsReplicas(ApplicationInfoManager applicationInfoManager) {
        boolean areAllPeerNodesPrimed = false;
        while (!areAllPeerNodesPrimed) {
            String peerHostName = null;
            try {
                Application eurekaApps = this.getApplication(applicationInfoManager.getInfo().getAppName(), false);
                if (eurekaApps == null) {
                    areAllPeerNodesPrimed = true;
                    logger.info("No peers needed to prime.");
                    return;
                }
                for (PeerEurekaNode node : this.peerEurekaNodes.getPeerEurekaNodes()) {
                    for (InstanceInfo peerInstanceInfo : eurekaApps.getInstances()) {
                        LeaseInfo leaseInfo = peerInstanceInfo.getLeaseInfo();
                        if (System.currentTimeMillis() > leaseInfo.getRenewalTimestamp() + (long)(leaseInfo.getDurationInSecs() * 1000) + 120000L) continue;
                        peerHostName = peerInstanceInfo.getHostName();
                        logger.info("Trying to send heartbeat for the eureka server at {} to make sure the network channels are open", (Object)peerHostName);
                        if (!peerHostName.equalsIgnoreCase(new URI(node.getServiceUrl()).getHost())) continue;
                        node.heartbeat(peerInstanceInfo.getAppName(), peerInstanceInfo.getId(), peerInstanceInfo, null, true);
                    }
                }
                areAllPeerNodesPrimed = true;
            }
            catch (Throwable e) {
                logger.error("Could not contact {}", peerHostName, (Object)e);
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e1) {
                    logger.warn("Interrupted while priming : ", (Throwable)e1);
                    areAllPeerNodesPrimed = true;
                }
            }
        }
    }

    @Override
    public boolean shouldAllowAccess(boolean remoteRegionRequired) {
        if (this.peerInstancesTransferEmptyOnStartup && System.currentTimeMillis() <= this.startupTime + (long)this.serverConfig.getWaitTimeInMsWhenSyncEmpty()) {
            return false;
        }
        if (remoteRegionRequired) {
            for (RemoteRegionRegistry remoteRegionRegistry : this.regionNameVSRemoteRegistry.values()) {
                if (remoteRegionRegistry.isReadyForServingData()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean shouldAllowAccess() {
        return this.shouldAllowAccess(true);
    }

    @Deprecated
    public List<PeerEurekaNode> getReplicaNodes() {
        return Collections.unmodifiableList(this.peerEurekaNodes.getPeerEurekaNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(String appName, String id, boolean isReplication) {
        if (super.cancel(appName, id, isReplication)) {
            this.replicateToPeers(Action.Cancel, appName, id, null, null, isReplication);
            Object object = this.lock;
            synchronized (object) {
                if (this.expectedNumberOfClientsSendingRenews > 0) {
                    --this.expectedNumberOfClientsSendingRenews;
                    this.updateRenewsPerMinThreshold();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void register(InstanceInfo info, boolean isReplication) {
        int leaseDuration = 90;
        if (info.getLeaseInfo() != null && info.getLeaseInfo().getDurationInSecs() > 0) {
            leaseDuration = info.getLeaseInfo().getDurationInSecs();
        }
        super.register(info, leaseDuration, isReplication);
        this.replicateToPeers(Action.Register, info.getAppName(), info.getId(), info, null, isReplication);
    }

    @Override
    public boolean renew(String appName, String id, boolean isReplication) {
        if (super.renew(appName, id, isReplication)) {
            this.replicateToPeers(Action.Heartbeat, appName, id, null, null, isReplication);
            return true;
        }
        return false;
    }

    @Override
    public boolean statusUpdate(String appName, String id, InstanceInfo.InstanceStatus newStatus, String lastDirtyTimestamp, boolean isReplication) {
        if (super.statusUpdate(appName, id, newStatus, lastDirtyTimestamp, isReplication)) {
            this.replicateToPeers(Action.StatusUpdate, appName, id, null, newStatus, isReplication);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteStatusOverride(String appName, String id, InstanceInfo.InstanceStatus newStatus, String lastDirtyTimestamp, boolean isReplication) {
        if (super.deleteStatusOverride(appName, id, newStatus, lastDirtyTimestamp, isReplication)) {
            this.replicateToPeers(Action.DeleteStatusOverride, appName, id, null, null, isReplication);
            return true;
        }
        return false;
    }

    @Override
    public void statusUpdate(String asgName, ASGResource.ASGStatus newStatus, boolean isReplication) {
        if (isReplication) {
            return;
        }
        for (PeerEurekaNode node : this.peerEurekaNodes.getPeerEurekaNodes()) {
            this.replicateASGInfoToReplicaNodes(asgName, newStatus, node);
        }
    }

    @Override
    public boolean isLeaseExpirationEnabled() {
        if (!this.isSelfPreservationModeEnabled()) {
            return true;
        }
        return this.numberOfRenewsPerMinThreshold > 0 && this.getNumOfRenewsInLastMin() > (long)this.numberOfRenewsPerMinThreshold;
    }

    @Override
    public boolean isSelfPreservationModeEnabled() {
        return this.serverConfig.shouldEnableSelfPreservation();
    }

    public InstanceInfo getNextServerFromEureka(String virtualHostname, boolean secure) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRenewalThreshold() {
        try {
            Applications apps = this.eurekaClient.getApplications();
            int count = 0;
            for (Application app : apps.getRegisteredApplications()) {
                for (InstanceInfo instance : app.getInstances()) {
                    if (!this.isRegisterable(instance)) continue;
                    ++count;
                }
            }
            Object object = this.lock;
            synchronized (object) {
                if ((double)count > this.serverConfig.getRenewalPercentThreshold() * (double)this.expectedNumberOfClientsSendingRenews || !this.isSelfPreservationModeEnabled()) {
                    this.expectedNumberOfClientsSendingRenews = count;
                    this.updateRenewsPerMinThreshold();
                }
            }
            logger.info("Current renewal threshold is : {}", (Object)this.numberOfRenewsPerMinThreshold);
        }
        catch (Throwable e) {
            logger.error("Cannot update renewal threshold", e);
        }
    }

    @Override
    public List<Application> getSortedApplications() {
        ArrayList<Application> apps = new ArrayList<Application>(this.getApplications().getRegisteredApplications());
        Collections.sort(apps, APP_COMPARATOR);
        return apps;
    }

    @com.netflix.servo.annotations.Monitor(name="numOfReplicationsInLastMin", description="Number of total replications received in the last minute", type=DataSourceType.GAUGE)
    public long getNumOfReplicationsInLastMin() {
        return this.numberOfReplicationsLastMin.getCount();
    }

    @Override
    @com.netflix.servo.annotations.Monitor(name="isBelowRenewThreshold", description="0 = false, 1 = true", type=DataSourceType.GAUGE)
    public int isBelowRenewThresold() {
        if (this.getNumOfRenewsInLastMin() <= (long)this.numberOfRenewsPerMinThreshold && this.startupTime > 0L && System.currentTimeMillis() > this.startupTime + (long)this.serverConfig.getWaitTimeInMsWhenSyncEmpty()) {
            return 1;
        }
        return 0;
    }

    public boolean isRegisterable(InstanceInfo instanceInfo) {
        DataCenterInfo datacenterInfo = instanceInfo.getDataCenterInfo();
        String serverRegion = this.clientConfig.getRegion();
        if (AmazonInfo.class.isInstance(datacenterInfo)) {
            AmazonInfo info = (AmazonInfo)AmazonInfo.class.cast(instanceInfo.getDataCenterInfo());
            String availabilityZone = info.get(AmazonInfo.MetaDataKey.availabilityZone);
            if (availabilityZone == null && US_EAST_1.equalsIgnoreCase(serverRegion)) {
                return true;
            }
            if (availabilityZone != null && availabilityZone.contains(serverRegion)) {
                return true;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicateToPeers(Action action, String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus newStatus, boolean isReplication) {
        Stopwatch tracer = action.getTimer().start();
        try {
            if (isReplication) {
                this.numberOfReplicationsLastMin.increment();
            }
            if (this.peerEurekaNodes == Collections.EMPTY_LIST || isReplication) {
                return;
            }
            for (PeerEurekaNode node : this.peerEurekaNodes.getPeerEurekaNodes()) {
                if (this.peerEurekaNodes.isThisMyUrl(node.getServiceUrl())) continue;
                this.replicateInstanceActionsToPeers(action, appName, id, info, newStatus, node);
            }
        }
        finally {
            tracer.stop();
        }
    }

    private void replicateInstanceActionsToPeers(Action action, String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus newStatus, PeerEurekaNode node) {
        try {
            InstanceInfo infoFromRegistry = null;
            CurrentRequestVersion.set(Version.V2);
            switch (action) {
                case Cancel: {
                    node.cancel(appName, id);
                    break;
                }
                case Heartbeat: {
                    InstanceInfo.InstanceStatus overriddenStatus = (InstanceInfo.InstanceStatus)this.overriddenInstanceStatusMap.get(id);
                    infoFromRegistry = this.getInstanceByAppAndId(appName, id, false);
                    node.heartbeat(appName, id, infoFromRegistry, overriddenStatus, false);
                    break;
                }
                case Register: {
                    node.register(info);
                    break;
                }
                case StatusUpdate: {
                    infoFromRegistry = this.getInstanceByAppAndId(appName, id, false);
                    node.statusUpdate(appName, id, newStatus, infoFromRegistry);
                    break;
                }
                case DeleteStatusOverride: {
                    infoFromRegistry = this.getInstanceByAppAndId(appName, id, false);
                    node.deleteStatusOverride(appName, id, infoFromRegistry);
                }
            }
        }
        catch (Throwable t) {
            logger.error("Cannot replicate information to {} for action {}", new Object[]{node.getServiceUrl(), action.name(), t});
        }
    }

    private void replicateASGInfoToReplicaNodes(String asgName, ASGResource.ASGStatus newStatus, PeerEurekaNode node) {
        CurrentRequestVersion.set(Version.V2);
        try {
            node.statusUpdate(asgName, newStatus);
        }
        catch (Throwable e) {
            logger.error("Cannot replicate ASG status information to {}", (Object)node.getServiceUrl(), (Object)e);
        }
    }

    @Override
    @com.netflix.servo.annotations.Monitor(name="localRegistrySize", description="Current registry size", type=DataSourceType.GAUGE)
    public long getLocalRegistrySize() {
        return super.getLocalRegistrySize();
    }

    public static enum Action {
        Heartbeat,
        Register,
        Cancel,
        StatusUpdate,
        DeleteStatusOverride;

        private Timer timer = Monitors.newTimer((String)this.name());

        public Timer getTimer() {
            return this.timer;
        }
    }
}

