/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka;

import com.google.common.base.Strings;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerContext;
import com.netflix.servo.monitor.DynamicCounter;
import com.netflix.servo.monitor.MonitorConfig;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

@Singleton
public class ServerRequestAuthFilter
implements Filter {
    public static final String UNKNOWN = "unknown";
    private static final String NAME_PREFIX = "DiscoveryServerRequestAuth_Name_";
    private EurekaServerConfig serverConfig;

    @Inject
    public ServerRequestAuthFilter(EurekaServerContext server) {
        this.serverConfig = server.getServerConfig();
    }

    public ServerRequestAuthFilter() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.serverConfig == null) {
            EurekaServerContext serverContext = (EurekaServerContext)filterConfig.getServletContext().getAttribute(EurekaServerContext.class.getName());
            this.serverConfig = serverContext.getServerConfig();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.logAuth(request);
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    protected void logAuth(ServletRequest request) {
        if (this.serverConfig.shouldLogIdentityHeaders() && request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String clientName = this.getHeader(httpRequest, "DiscoveryIdentity-Name");
            String clientVersion = this.getHeader(httpRequest, "DiscoveryIdentity-Version");
            DynamicCounter.increment((MonitorConfig)MonitorConfig.builder((String)(NAME_PREFIX + clientName + "-" + clientVersion)).build());
        }
    }

    protected String getHeader(HttpServletRequest request, String headerKey) {
        String value = request.getHeader(headerKey);
        return Strings.isNullOrEmpty((String)value) ? UNKNOWN : value;
    }
}

