/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.resources.ApplicationResource;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/xml", "application/json"})
public class InstanceResource {
    private static final Logger logger = LoggerFactory.getLogger(InstanceResource.class);
    private final PeerAwareInstanceRegistry registry;
    private final EurekaServerConfig serverConfig;
    private final String id;
    private final ApplicationResource app;

    InstanceResource(ApplicationResource app, String id, EurekaServerConfig serverConfig, PeerAwareInstanceRegistry registry) {
        this.app = app;
        this.id = id;
        this.serverConfig = serverConfig;
        this.registry = registry;
    }

    @GET
    public Response getInstanceInfo() {
        InstanceInfo appInfo = this.registry.getInstanceByAppAndId(this.app.getName(), this.id);
        if (appInfo != null) {
            logger.debug("Found: {} - {}", (Object)this.app.getName(), (Object)this.id);
            return Response.ok((Object)appInfo).build();
        }
        logger.debug("Not Found: {} - {}", (Object)this.app.getName(), (Object)this.id);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @PUT
    public Response renewLease(@HeaderParam(value="x-netflix-discovery-replication") String isReplication, @QueryParam(value="overriddenstatus") String overriddenStatus, @QueryParam(value="status") String status, @QueryParam(value="lastDirtyTimestamp") String lastDirtyTimestamp) {
        boolean isFromReplicaNode = "true".equals(isReplication);
        boolean isSuccess = this.registry.renew(this.app.getName(), this.id, isFromReplicaNode);
        if (!isSuccess) {
            logger.warn("Not Found (Renew): {} - {}", (Object)this.app.getName(), (Object)this.id);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Response response = null;
        if (lastDirtyTimestamp != null && this.serverConfig.shouldSyncWhenTimestampDiffers()) {
            response = this.validateDirtyTimestamp(Long.valueOf(lastDirtyTimestamp), isFromReplicaNode);
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode() && overriddenStatus != null && !InstanceInfo.InstanceStatus.UNKNOWN.name().equals(overriddenStatus) && isFromReplicaNode) {
                this.registry.storeOverriddenStatusIfRequired(this.app.getAppName(), this.id, InstanceInfo.InstanceStatus.valueOf((String)overriddenStatus));
            }
        } else {
            response = Response.ok().build();
        }
        logger.debug("Found (Renew): {} - {}; reply status={}", new Object[]{this.app.getName(), this.id, response.getStatus()});
        return response;
    }

    @PUT
    @Path(value="status")
    public Response statusUpdate(@QueryParam(value="value") String newStatus, @HeaderParam(value="x-netflix-discovery-replication") String isReplication, @QueryParam(value="lastDirtyTimestamp") String lastDirtyTimestamp) {
        try {
            if (this.registry.getInstanceByAppAndId(this.app.getName(), this.id) == null) {
                logger.warn("Instance not found: {}/{}", (Object)this.app.getName(), (Object)this.id);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            boolean isSuccess = this.registry.statusUpdate(this.app.getName(), this.id, InstanceInfo.InstanceStatus.valueOf((String)newStatus), lastDirtyTimestamp, "true".equals(isReplication));
            if (isSuccess) {
                logger.info("Status updated: {} - {} - {}", new Object[]{this.app.getName(), this.id, newStatus});
                return Response.ok().build();
            }
            logger.warn("Unable to update status: {} - {} - {}", new Object[]{this.app.getName(), this.id, newStatus});
            return Response.serverError().build();
        }
        catch (Throwable e) {
            logger.error("Error updating instance {} for status {}", (Object)this.id, (Object)newStatus);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="status")
    public Response deleteStatusUpdate(@HeaderParam(value="x-netflix-discovery-replication") String isReplication, @QueryParam(value="value") String newStatusValue, @QueryParam(value="lastDirtyTimestamp") String lastDirtyTimestamp) {
        try {
            if (this.registry.getInstanceByAppAndId(this.app.getName(), this.id) == null) {
                logger.warn("Instance not found: {}/{}", (Object)this.app.getName(), (Object)this.id);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            InstanceInfo.InstanceStatus newStatus = newStatusValue == null ? InstanceInfo.InstanceStatus.UNKNOWN : InstanceInfo.InstanceStatus.valueOf((String)newStatusValue);
            boolean isSuccess = this.registry.deleteStatusOverride(this.app.getName(), this.id, newStatus, lastDirtyTimestamp, "true".equals(isReplication));
            if (isSuccess) {
                logger.info("Status override removed: {} - {}", (Object)this.app.getName(), (Object)this.id);
                return Response.ok().build();
            }
            logger.warn("Unable to remove status override: {} - {}", (Object)this.app.getName(), (Object)this.id);
            return Response.serverError().build();
        }
        catch (Throwable e) {
            logger.error("Error removing instance's {} status override", (Object)this.id);
            return Response.serverError().build();
        }
    }

    @PUT
    @Path(value="metadata")
    public Response updateMetadata(@Context UriInfo uriInfo) {
        try {
            InstanceInfo instanceInfo = this.registry.getInstanceByAppAndId(this.app.getName(), this.id);
            if (instanceInfo == null) {
                logger.error("Cannot find instance while updating metadata for instance {}", (Object)this.id);
                return Response.serverError().build();
            }
            MultivaluedMap queryParams = uriInfo.getQueryParameters();
            Set entrySet = queryParams.entrySet();
            ConcurrentHashMap metadataMap = instanceInfo.getMetadata();
            if (Collections.emptyMap().getClass().equals(metadataMap.getClass())) {
                metadataMap = new ConcurrentHashMap();
                InstanceInfo.Builder builder = new InstanceInfo.Builder(instanceInfo);
                builder.setMetadata(metadataMap);
                instanceInfo = builder.build();
            }
            for (Map.Entry entry : entrySet) {
                metadataMap.put(entry.getKey(), ((List)entry.getValue()).get(0));
            }
            this.registry.register(instanceInfo, false);
            return Response.ok().build();
        }
        catch (Throwable e) {
            logger.error("Error updating metadata for instance {}", (Object)this.id, (Object)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    public Response cancelLease(@HeaderParam(value="x-netflix-discovery-replication") String isReplication) {
        try {
            boolean isSuccess = this.registry.cancel(this.app.getName(), this.id, "true".equals(isReplication));
            if (isSuccess) {
                logger.debug("Found (Cancel): {} - {}", (Object)this.app.getName(), (Object)this.id);
                return Response.ok().build();
            }
            logger.info("Not Found (Cancel): {} - {}", (Object)this.app.getName(), (Object)this.id);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Throwable e) {
            logger.error("Error (cancel): {} - {}", new Object[]{this.app.getName(), this.id, e});
            return Response.serverError().build();
        }
    }

    private Response validateDirtyTimestamp(Long lastDirtyTimestamp, boolean isReplication) {
        InstanceInfo appInfo = this.registry.getInstanceByAppAndId(this.app.getName(), this.id, false);
        if (appInfo != null && lastDirtyTimestamp != null && !lastDirtyTimestamp.equals(appInfo.getLastDirtyTimestamp())) {
            Object[] args = new Object[]{this.id, appInfo.getLastDirtyTimestamp(), lastDirtyTimestamp, isReplication};
            if (lastDirtyTimestamp > appInfo.getLastDirtyTimestamp()) {
                logger.debug("Time to sync, since the last dirty timestamp differs - ReplicationInstance id : {},Registry : {} Incoming: {} Replication: {}", args);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (appInfo.getLastDirtyTimestamp() > lastDirtyTimestamp) {
                if (isReplication) {
                    logger.debug("Time to sync, since the last dirty timestamp differs - ReplicationInstance id : {},Registry : {} Incoming: {} Replication: {}", args);
                    return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)appInfo).build();
                }
                return Response.ok().build();
            }
        }
        return Response.ok().build();
    }
}

