/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.registry.rule;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.lease.Lease;
import com.netflix.eureka.registry.rule.InstanceStatusOverrideRule;
import com.netflix.eureka.registry.rule.StatusOverrideResult;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverrideExistsRule
implements InstanceStatusOverrideRule {
    private static final Logger logger = LoggerFactory.getLogger(OverrideExistsRule.class);
    private Map<String, InstanceInfo.InstanceStatus> statusOverrides;

    public OverrideExistsRule(Map<String, InstanceInfo.InstanceStatus> statusOverrides) {
        this.statusOverrides = statusOverrides;
    }

    @Override
    public StatusOverrideResult apply(InstanceInfo instanceInfo, Lease<InstanceInfo> existingLease, boolean isReplication) {
        InstanceInfo.InstanceStatus overridden = this.statusOverrides.get(instanceInfo.getId());
        if (overridden != null) {
            logger.debug("The instance specific override for instance {} and the value is {}", (Object)instanceInfo.getId(), (Object)overridden.name());
            return StatusOverrideResult.matchingStatus(overridden);
        }
        return StatusOverrideResult.NO_MATCH;
    }

    public String toString() {
        return OverrideExistsRule.class.getName();
    }
}

