/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.netflix.appinfo.AmazonInfoConfig;
import com.netflix.appinfo.Archaius1AmazonInfoConfig;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.UniqueIdentifier;
import com.netflix.discovery.converters.jackson.builder.StringInterningAmazonInfoBuilder;
import com.netflix.discovery.internal.util.AmazonInfoUtils;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=StringInterningAmazonInfoBuilder.class)
public class AmazonInfo
implements DataCenterInfo,
UniqueIdentifier {
    private Map<String, String> metadata = new HashMap<String, String>();
    private static final String AWS_API_VERSION = "latest";
    private static final String AWS_METADATA_URL = "http://169.254.169.254/latest/meta-data/";

    public AmazonInfo() {
    }

    @JsonCreator
    public AmazonInfo(@JsonProperty(value="name") String name, @JsonProperty(value="metadata") HashMap<String, String> metadata) {
        this.metadata = metadata;
    }

    @Override
    public DataCenterInfo.Name getName() {
        return DataCenterInfo.Name.Amazon;
    }

    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadataMap) {
        this.metadata = metadataMap;
    }

    public String get(MetaDataKey key) {
        return this.metadata.get(key.getName());
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.get(MetaDataKey.instanceId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AmazonInfo)) {
            return false;
        }
        AmazonInfo that = (AmazonInfo)o;
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return this.metadata != null ? this.metadata.hashCode() : 0;
    }

    public String toString() {
        return "AmazonInfo{metadata=" + this.metadata + '}';
    }

    public static final class Builder {
        private static final Logger logger = LoggerFactory.getLogger(Builder.class);
        private static final int SLEEP_TIME_MS = 100;
        @XStreamOmitField
        private AmazonInfo result = new AmazonInfo();
        @XStreamOmitField
        private AmazonInfoConfig config;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder addMetadata(MetaDataKey key, String value) {
            this.result.metadata.put(key.getName(), value);
            return this;
        }

        public Builder withAmazonInfoConfig(AmazonInfoConfig config) {
            this.config = config;
            return this;
        }

        public AmazonInfo build() {
            return this.result;
        }

        public AmazonInfo autoBuild(String namespace) {
            if (this.config == null) {
                this.config = new Archaius1AmazonInfoConfig(namespace);
            }
            for (MetaDataKey key : MetaDataKey.values()) {
                int numOfRetries = this.config.getNumRetries();
                while (numOfRetries-- > 0) {
                    try {
                        URL url;
                        String value;
                        String mac = null;
                        if (key == MetaDataKey.vpcId) {
                            mac = (String)this.result.metadata.get(MetaDataKey.mac.getName());
                        }
                        if ((value = AmazonInfoUtils.readEc2MetadataUrl(key, url = key.getURL(null, mac), this.config.getConnectTimeout(), this.config.getReadTimeout())) == null) break;
                        this.result.metadata.put(key.getName(), value);
                        break;
                    }
                    catch (Throwable e) {
                        if (this.config.shouldLogAmazonMetadataErrors()) {
                            logger.warn("Cannot get the value for the metadata key :" + (Object)((Object)key) + " Reason :", e);
                        }
                        if (numOfRetries < 0) continue;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (key != MetaDataKey.instanceId || !this.config.shouldFailFastOnFirstLoad() || this.result.metadata.containsKey(MetaDataKey.instanceId.getName())) continue;
                logger.warn("Skipping the rest of AmazonInfo init as we were not able to load instanceId after the configured number of retries: {}, per fail fast configuration: {}", (Object)this.config.getNumRetries(), (Object)this.config.shouldFailFastOnFirstLoad());
                break;
            }
            return this.result;
        }
    }

    public static enum MetaDataKey {
        instanceId("instance-id"),
        amiId("ami-id"),
        instanceType("instance-type"),
        localIpv4("local-ipv4"),
        localHostname("local-hostname"),
        availabilityZone("availability-zone", "placement/"),
        publicHostname("public-hostname"),
        publicIpv4("public-ipv4"),
        mac("mac"),
        vpcId("vpc-id", "network/interfaces/macs/"){

            @Override
            public URL getURL(String prepend, String mac) throws MalformedURLException {
                return new URL(AmazonInfo.AWS_METADATA_URL + this.path + mac + "/" + this.name);
            }
        }
        ,
        accountId("accountId"){
            private Pattern pattern = Pattern.compile("\"accountId\"\\s?:\\s?\\\"([A-Za-z0-9]*)\\\"");

            @Override
            public URL getURL(String prepend, String append) throws MalformedURLException {
                return new URL("http://169.254.169.254/latest/dynamic/instance-identity/document");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String read(InputStream inputStream) throws IOException {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
                    String inputLine;
                    String toReturn = null;
                    while ((inputLine = br.readLine()) != null) {
                        Matcher matcher = this.pattern.matcher(inputLine);
                        if (toReturn != null || !matcher.find()) continue;
                        toReturn = matcher.group(1);
                    }
                    String string = toReturn;
                    return string;
                }
            }
        };

        protected String name;
        protected String path;

        private MetaDataKey(String name) {
            this(name, "");
        }

        private MetaDataKey(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public URL getURL(String prepend, String append) throws MalformedURLException {
            return new URL(AmazonInfo.AWS_METADATA_URL + this.path + this.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String read(InputStream inputStream) throws IOException {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                String toReturn = line = br.readLine();
                while (line != null) {
                    line = br.readLine();
                }
                String string = toReturn;
                return string;
            }
        }

        public String toString() {
            return this.getName();
        }
    }
}

