/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.jersey;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.protocol.HttpContext;

public class SSLSocketFactoryAdapter
extends org.apache.http.conn.ssl.SSLSocketFactory {
    private final SSLConnectionSocketFactory factory;

    public SSLSocketFactoryAdapter(SSLConnectionSocketFactory factory) {
        super((SSLSocketFactory)DummySSLSocketFactory.INSTANCE, (X509HostnameVerifier)DummyX509HostnameVerifier.INSTANCE);
        this.factory = factory;
    }

    public SSLSocketFactoryAdapter(SSLConnectionSocketFactory factory, HostnameVerifier hostnameVerifier) {
        super((SSLSocketFactory)DummySSLSocketFactory.INSTANCE, (X509HostnameVerifier)new WrappedX509HostnameVerifier(hostnameVerifier));
        this.factory = factory;
    }

    public Socket createSocket(HttpContext context) throws IOException {
        return this.factory.createSocket(context);
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        return this.factory.connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, context);
    }

    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        return this.factory.createLayeredSocket(socket, target, port, context);
    }

    private static class WrappedX509HostnameVerifier
    extends DummyX509HostnameVerifier {
        HostnameVerifier hostnameVerifier;

        private WrappedX509HostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return this.hostnameVerifier.verify(hostname, session);
        }
    }

    private static class DummyX509HostnameVerifier
    implements X509HostnameVerifier {
        private static final DummyX509HostnameVerifier INSTANCE = new DummyX509HostnameVerifier();

        private DummyX509HostnameVerifier() {
        }

        public boolean verify(String hostname, SSLSession session) {
            throw new UnsupportedOperationException();
        }

        public void verify(String host, SSLSocket ssl) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void verify(String host, X509Certificate cert) throws SSLException {
            throw new UnsupportedOperationException();
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            throw new UnsupportedOperationException();
        }
    }

    private static class DummySSLSocketFactory
    extends SSLSocketFactory {
        private static final DummySSLSocketFactory INSTANCE = new DummySSLSocketFactory();

        private DummySSLSocketFactory() {
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getDefaultCipherSuites() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

