/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TimeoutTimer;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class TDSCommand {
    static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.TDS.Command");
    private final String logContext;
    private String traceID;
    private final TimeoutTimer timeoutTimer;
    private volatile TDSWriter tdsWriter;
    private volatile TDSReader tdsReader;
    private final Object interruptLock = new Object();
    private volatile boolean interruptsEnabled = false;
    private volatile boolean wasInterrupted = false;
    private volatile String interruptReason = null;
    private volatile boolean requestComplete;
    private volatile boolean attentionPending = false;
    private volatile boolean processedResponse;
    private volatile boolean readingResponse;
    private boolean interruptChecked = false;

    abstract boolean doExecute() throws SQLServerException;

    final String getLogContext() {
        return this.logContext;
    }

    public final String toString() {
        if (this.traceID == null) {
            this.traceID = "TDSCommand@" + Integer.toHexString(this.hashCode()) + " (" + this.logContext + ")";
        }
        return this.traceID;
    }

    final void log(Level level, String message) {
        logger.log(level, this.toString() + ": " + message);
    }

    protected boolean getInterruptsEnabled() {
        return this.interruptsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInterruptsEnabled(boolean interruptsEnabled) {
        Object object = this.interruptLock;
        synchronized (object) {
            this.interruptsEnabled = interruptsEnabled;
        }
    }

    private boolean wasInterrupted() {
        return this.wasInterrupted;
    }

    protected boolean getRequestComplete() {
        return this.requestComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRequestComplete(boolean requestComplete) {
        Object object = this.interruptLock;
        synchronized (object) {
            this.requestComplete = requestComplete;
        }
    }

    boolean attentionPending() {
        return this.attentionPending;
    }

    protected boolean getProcessedResponse() {
        return this.processedResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProcessedResponse(boolean processedResponse) {
        Object object = this.interruptLock;
        synchronized (object) {
            this.processedResponse = processedResponse;
        }
    }

    final boolean readingResponse() {
        return this.readingResponse;
    }

    TDSCommand(String logContext, int timeoutSeconds) {
        this.logContext = logContext;
        this.timeoutTimer = timeoutSeconds > 0 ? new TimeoutTimer(timeoutSeconds, this) : null;
    }

    boolean execute(TDSWriter tdsWriter, TDSReader tdsReader) throws SQLServerException {
        this.tdsWriter = tdsWriter;
        this.tdsReader = tdsReader;
        assert (null != tdsReader);
        try {
            return this.doExecute();
        }
        catch (SQLServerException e) {
            block6: {
                try {
                    if (!this.requestComplete && !tdsReader.getConnection().isClosed()) {
                        this.interrupt(e.getMessage());
                        this.onRequestComplete();
                        this.close();
                    }
                }
                catch (SQLServerException interruptException) {
                    if (!logger.isLoggable(Level.FINE)) break block6;
                    logger.fine(this.toString() + ": Ignoring error in sending attention: " + interruptException.getMessage());
                }
            }
            throw e;
        }
    }

    void processResponse(TDSReader tdsReader) throws SQLServerException {
        block4: {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + ": Processing response");
            }
            try {
                TDSParser.parse(tdsReader, this.getLogContext());
            }
            catch (SQLServerException e) {
                if (2 != e.getDriverErrorCode()) {
                    throw e;
                }
                if (!logger.isLoggable(Level.FINEST)) break block4;
                logger.finest(this.toString() + ": Ignoring error from database: " + e.getMessage());
            }
        }
    }

    final void detach() throws SQLServerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this + ": detaching...");
        }
        while (this.tdsReader.readPacket()) {
        }
        assert (!this.readingResponse);
    }

    final void close() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this + ": closing...");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this + ": processing response...");
        }
        while (!this.processedResponse) {
            try {
                this.processResponse(this.tdsReader);
            }
            catch (SQLServerException e) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this + ": close ignoring error processing response: " + e.getMessage());
                }
                if (!this.tdsReader.getConnection().isSessionUnAvailable()) continue;
                this.processedResponse = true;
                this.attentionPending = false;
            }
        }
        if (this.attentionPending) {
            block18: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this + ": processing attention ack...");
                }
                try {
                    TDSParser.parse(this.tdsReader, "attention ack");
                }
                catch (SQLServerException e) {
                    if (this.tdsReader.getConnection().isSessionUnAvailable()) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(this + ": giving up on attention ack after connection closed by exception: " + e);
                        }
                        this.attentionPending = false;
                    }
                    if (!logger.isLoggable(Level.FINEST)) break block18;
                    logger.finest(this + ": ignored exception: " + e);
                }
            }
            if (this.attentionPending) {
                logger.severe(this + ": expected attn ack missing or not processed; terminating connection...");
                try {
                    this.tdsReader.throwInvalidTDS();
                }
                catch (SQLServerException e) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this + ": ignored expected invalid TDS exception: " + e);
                    }
                    assert (this.tdsReader.getConnection().isSessionUnAvailable());
                    this.attentionPending = false;
                }
            }
        }
        assert (this.processedResponse && !this.attentionPending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interrupt(String reason) throws SQLServerException {
        Object object = this.interruptLock;
        synchronized (object) {
            if (this.interruptsEnabled && !this.wasInterrupted()) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this + ": Raising interrupt for reason:" + reason);
                }
                this.wasInterrupted = true;
                this.interruptReason = reason;
                if (this.requestComplete) {
                    this.attentionPending = this.tdsWriter.sendAttention();
                }
            }
        }
    }

    final void checkForInterrupt() throws SQLServerException {
        if (this.wasInterrupted() && !this.interruptChecked) {
            this.interruptChecked = true;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this + ": throwing interrupt exception, reason: " + this.interruptReason);
            }
            throw new SQLServerException(this.interruptReason, SQLState.STATEMENT_CANCELED, DriverError.NOT_SET, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onRequestComplete() throws SQLServerException {
        assert (!this.requestComplete);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this + ": request complete");
        }
        Object object = this.interruptLock;
        synchronized (object) {
            this.requestComplete = true;
            if (!this.interruptsEnabled) {
                assert (!this.attentionPending);
                assert (!this.processedResponse);
                assert (!this.readingResponse);
                this.processedResponse = true;
            } else if (this.wasInterrupted()) {
                if (this.tdsWriter.isEOMSent()) {
                    this.readingResponse = this.attentionPending = this.tdsWriter.sendAttention();
                } else {
                    assert (!this.attentionPending);
                    this.readingResponse = this.tdsWriter.ignoreMessage();
                }
                this.processedResponse = !this.readingResponse;
            } else {
                assert (!this.attentionPending);
                assert (!this.processedResponse);
                this.readingResponse = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onResponseEOM() throws SQLServerException {
        boolean readAttentionAck = false;
        Object object = this.interruptLock;
        synchronized (object) {
            if (this.interruptsEnabled) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this + ": disabling interrupts");
                }
                readAttentionAck = this.attentionPending;
                this.interruptsEnabled = false;
            }
        }
        if (readAttentionAck) {
            this.tdsReader.readPacket();
        }
        this.readingResponse = false;
    }

    final void onTokenEOF() {
        this.processedResponse = true;
    }

    final void onAttentionAck() {
        assert (this.attentionPending);
        this.attentionPending = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TDSWriter startRequest(byte tdsMessageType) throws SQLServerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this + ": starting request...");
        }
        try {
            this.tdsWriter.startMessage(this, tdsMessageType);
        }
        catch (SQLServerException e) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this + ": starting request: exception: " + e.getMessage());
            }
            throw e;
        }
        Object object = this.interruptLock;
        synchronized (object) {
            this.requestComplete = false;
            this.readingResponse = false;
            this.processedResponse = false;
            this.attentionPending = false;
            this.wasInterrupted = false;
            this.interruptReason = null;
            this.interruptsEnabled = true;
        }
        return this.tdsWriter;
    }

    final TDSReader startResponse() throws SQLServerException {
        return this.startResponse(false);
    }

    final TDSReader startResponse(boolean isAdaptive) throws SQLServerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this + ": finishing request");
        }
        try {
            this.tdsWriter.endMessage();
        }
        catch (SQLServerException e) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this + ": finishing request: endMessage threw exception: " + e.getMessage());
            }
            throw e;
        }
        if (null != this.timeoutTimer) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + ": Starting timer...");
            }
            this.timeoutTimer.start();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + ": Reading response...");
        }
        try {
            if (isAdaptive) {
                this.tdsReader.readPacket();
            } else {
                while (this.tdsReader.readPacket()) {
                }
            }
        }
        catch (SQLServerException e) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + ": Exception reading response: " + e.getMessage());
            }
            throw e;
        }
        finally {
            if (null != this.timeoutTimer) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toString() + ": Stopping timer...");
                }
                this.timeoutTimer.stop();
            }
        }
        return this.tdsReader;
    }
}

