/**
 *
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

// Warning: This code was generated by a tool.
//
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.keyvault;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;

import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.StreamUtils;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;

/**
 * Operations for secrets in a vault
 */
class SecretOperationsImpl implements ServiceOperations<KeyVaultInternalClientImpl>, SecretOperations {
    /**
     * Initializes a new instance of the SecretOperationsImpl class.
     *
     * @param client
     *            Reference to the service client.
     */
    SecretOperationsImpl(KeyVaultInternalClientImpl client) {
        this.client = client;
    }

    private KeyVaultInternalClientImpl client;

    /**
     * Gets a reference to the
     * microsoft.azure.keyvault.internal.KeyVaultInternalClientImpl.
     *
     * @return The Client value.
     */
    @Override
    public KeyVaultInternalClientImpl getClient() {
        return client;
    }

    /**
     * Delete the specified secret
     *
     * @param secretIdentifier
     *            Required.
     * @return Represents the response to a secret operation request.
     */
    @Override
    public Future<SecretResponseMessageWithRawJsonContent> deleteAsync(final String secretIdentifier) {
        return getClient().getExecutorService().submit(new Callable<SecretResponseMessageWithRawJsonContent>() {
            @Override
            public SecretResponseMessageWithRawJsonContent call() throws Exception {
                return delete(secretIdentifier);
            }
        });
    }

    /**
     * Delete the specified secret
     *
     * @param secretIdentifier
     *            Required.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred. This
     *             class is the general class of exceptions produced by failed
     *             or interrupted I/O operations.
     * @throws ServiceException
     *             Thrown if an unexpected response is found.
     * @return Represents the response to a secret operation request.
     */
    @Override
    public SecretResponseMessageWithRawJsonContent delete(String secretIdentifier) throws IOException, ServiceException {
        // Validate
        if (secretIdentifier == null) {
            throw new NullPointerException("secretIdentifier");
        }

        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("secretIdentifier", secretIdentifier);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }

        // Construct URL
        String url = "";
        url = url + secretIdentifier;
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        url = url.replace(" ", "%20");

        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);

        // Set Headers
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");

        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.create(httpRequest, null, httpResponse, httpResponse.getEntity(), "Json");
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }

            // Create Result
            SecretResponseMessageWithRawJsonContent result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new SecretResponseMessageWithRawJsonContent();
            result.setResponse(StreamUtils.toString(responseContent));

            result.setStatusCode(statusCode);

            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    /**
     * Gets a secret
     *
     * @param secretIdentifier
     *            Required.
     * @return Represents the response to a secret operation request.
     */
    @Override
    public Future<SecretResponseMessageWithRawJsonContent> getAsync(final String secretIdentifier) {
        return getClient().getExecutorService().submit(new Callable<SecretResponseMessageWithRawJsonContent>() {
            @Override
            public SecretResponseMessageWithRawJsonContent call() throws Exception {
                return get(secretIdentifier);
            }
        });
    }

    /**
     * Gets a secret
     *
     * @param secretIdentifier
     *            Required.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred. This
     *             class is the general class of exceptions produced by failed
     *             or interrupted I/O operations.
     * @throws ServiceException
     *             Thrown if an unexpected response is found.
     * @return Represents the response to a secret operation request.
     */
    @Override
    public SecretResponseMessageWithRawJsonContent get(String secretIdentifier) throws IOException, ServiceException {
        // Validate
        if (secretIdentifier == null) {
            throw new NullPointerException("secretIdentifier");
        }

        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("secretIdentifier", secretIdentifier);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }

        // Construct URL
        String url = "";
        url = url + secretIdentifier;
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        url = url.replace(" ", "%20");

        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);

        // Set Headers
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");

        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.create(httpRequest, null, httpResponse, httpResponse.getEntity(), "Json");
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }

            // Create Result
            SecretResponseMessageWithRawJsonContent result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new SecretResponseMessageWithRawJsonContent();
            result.setResponse(StreamUtils.toString(responseContent));

            result.setStatusCode(statusCode);

            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    /**
     * List the secrets in the specified vault
     *
     * @param vault
     *            Required.
     * @param top
     *            Required.
     * @return Represents the response to a secret operation request.
     */
    @Override
    public Future<SecretResponseMessageWithRawJsonContent> listAsync(final String vault, final Integer top) {
        return getClient().getExecutorService().submit(new Callable<SecretResponseMessageWithRawJsonContent>() {
            @Override
            public SecretResponseMessageWithRawJsonContent call() throws Exception {
                return list(vault, top);
            }
        });
    }

    /**
     * List the secrets in the specified vault
     *
     * @param vault
     *            Required.
     * @param top
     *            Required.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred. This
     *             class is the general class of exceptions produced by failed
     *             or interrupted I/O operations.
     * @throws ServiceException
     *             Thrown if an unexpected response is found.
     * @return Represents the response to a secret operation request.
     */
    @Override
    public SecretResponseMessageWithRawJsonContent list(String vault, Integer top) throws IOException, ServiceException {
        // Validate
        if (vault == null) {
            throw new NullPointerException("vault");
        }

        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vault", vault);
            tracingParameters.put("top", top);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }

        // Construct URL
        String url = "";
        url = url + vault;
        url = url + "/secrets/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + getClient().getApiVersion());
        if (top != null) {
            queryParameters.add("maxresults=" + URLEncoder.encode(Integer.toString(top), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        url = url.replace(" ", "%20");

        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);

        // Set Headers
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());

        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.create(httpRequest, null, httpResponse, httpResponse.getEntity(), "Json");
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }

            // Create Result
            SecretResponseMessageWithRawJsonContent result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new SecretResponseMessageWithRawJsonContent();
            result.setResponse(StreamUtils.toString(responseContent));

            result.setStatusCode(statusCode);

            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    /**
     * List the next page of secrets in the specified vault
     *
     * @param nextLink
     *            Required.
     * @return Represents the response to a secret operation request.
     */
    @Override
    public Future<SecretResponseMessageWithRawJsonContent> listNextAsync(final String nextLink) {
        return getClient().getExecutorService().submit(new Callable<SecretResponseMessageWithRawJsonContent>() {
            @Override
            public SecretResponseMessageWithRawJsonContent call() throws Exception {
                return listNext(nextLink);
            }
        });
    }

    /**
     * List the next page of secrets in the specified vault
     *
     * @param nextLink
     *            Required.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred. This
     *             class is the general class of exceptions produced by failed
     *             or interrupted I/O operations.
     * @throws ServiceException
     *             Thrown if an unexpected response is found.
     * @return Represents the response to a secret operation request.
     */
    @Override
    public SecretResponseMessageWithRawJsonContent listNext(String nextLink) throws IOException, ServiceException {
        // Validate
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }

        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter(invocationId, this, "listNextAsync", tracingParameters);
        }

        // Construct URL
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");

        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);

        // Set Headers
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());

        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.create(httpRequest, null, httpResponse, httpResponse.getEntity(), "Json");
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }

            // Create Result
            SecretResponseMessageWithRawJsonContent result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new SecretResponseMessageWithRawJsonContent();
            result.setResponse(StreamUtils.toString(responseContent));

            result.setStatusCode(statusCode);

            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    /**
     * List the versions of a secret in the specified vault
     *
     * @param vault
     *            Required.
     * @param secretName
     *            Required.
     * @param top
     *            Required.
     * @return Represents the response to a secret operation request.
     */
    @Override
    public Future<SecretResponseMessageWithRawJsonContent> listVersionsAsync(final String vault, final String secretName, final Integer top) {
        return getClient().getExecutorService().submit(new Callable<SecretResponseMessageWithRawJsonContent>() {
            @Override
            public SecretResponseMessageWithRawJsonContent call() throws Exception {
                return listVersions(vault, secretName, top);
            }
        });
    }

    /**
     * List the versions of a secret in the specified vault
     *
     * @param vault
     *            Required.
     * @param secretName
     *            Required.
     * @param top
     *            Required.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred. This
     *             class is the general class of exceptions produced by failed
     *             or interrupted I/O operations.
     * @throws ServiceException
     *             Thrown if an unexpected response is found.
     * @return Represents the response to a secret operation request.
     */
    @Override
    public SecretResponseMessageWithRawJsonContent listVersions(String vault, String secretName, Integer top) throws IOException, ServiceException {
        // Validate
        if (vault == null) {
            throw new NullPointerException("vault");
        }
        if (secretName == null) {
            throw new NullPointerException("secretName");
        }

        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vault", vault);
            tracingParameters.put("secretName", secretName);
            tracingParameters.put("top", top);
            CloudTracing.enter(invocationId, this, "listVersionsAsync", tracingParameters);
        }

        // Construct URL
        String url = "";
        url = url + vault;
        url = url + "/secrets/";
        url = url + URLEncoder.encode(secretName, "UTF-8");
        url = url + "/versions";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + getClient().getApiVersion());
        if (top != null) {
            queryParameters.add("maxresults=" + URLEncoder.encode(Integer.toString(top), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        url = url.replace(" ", "%20");

        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);

        // Set Headers
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());

        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.create(httpRequest, null, httpResponse, httpResponse.getEntity(), "Json");
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }

            // Create Result
            SecretResponseMessageWithRawJsonContent result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new SecretResponseMessageWithRawJsonContent();
            result.setResponse(StreamUtils.toString(responseContent));

            result.setStatusCode(statusCode);

            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    /**
     * List the versions of a secret in the specified vault
     *
     * @param nextLink
     *            Required.
     * @return Represents the response to a secret operation request.
     */
    @Override
    public Future<SecretResponseMessageWithRawJsonContent> listVersionsNextAsync(final String nextLink) {
        return getClient().getExecutorService().submit(new Callable<SecretResponseMessageWithRawJsonContent>() {
            @Override
            public SecretResponseMessageWithRawJsonContent call() throws Exception {
                return listVersionsNext(nextLink);
            }
        });
    }

    /**
     * List the versions of a secret in the specified vault
     *
     * @param nextLink
     *            Required.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred. This
     *             class is the general class of exceptions produced by failed
     *             or interrupted I/O operations.
     * @throws ServiceException
     *             Thrown if an unexpected response is found.
     * @return Represents the response to a secret operation request.
     */
    @Override
    public SecretResponseMessageWithRawJsonContent listVersionsNext(String nextLink) throws IOException, ServiceException {
        // Validate
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }

        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter(invocationId, this, "listVersionsNextAsync", tracingParameters);
        }

        // Construct URL
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");

        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);

        // Set Headers
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());

        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.create(httpRequest, null, httpResponse, httpResponse.getEntity(), "Json");
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }

            // Create Result
            SecretResponseMessageWithRawJsonContent result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new SecretResponseMessageWithRawJsonContent();
            result.setResponse(StreamUtils.toString(responseContent));

            result.setStatusCode(statusCode);

            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    /**
     * Sets a secret in the specified vault.
     *
     * @param secretIdentifier
     *            Required.
     * @param request
     *            Required.
     * @return Represents the response to a secret operation request.
     */
    @Override
    public Future<SecretResponseMessageWithRawJsonContent> setAsync(final String secretIdentifier, final SecretRequestMessageWithRawJsonContent request) {
        return getClient().getExecutorService().submit(new Callable<SecretResponseMessageWithRawJsonContent>() {
            @Override
            public SecretResponseMessageWithRawJsonContent call() throws Exception {
                return set(secretIdentifier, request);
            }
        });
    }

    /**
     * Sets a secret in the specified vault.
     *
     * @param secretIdentifier
     *            Required.
     * @param request
     *            Required.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred. This
     *             class is the general class of exceptions produced by failed
     *             or interrupted I/O operations.
     * @throws ServiceException
     *             Thrown if an unexpected response is found.
     * @return Represents the response to a secret operation request.
     */
    @Override
    public SecretResponseMessageWithRawJsonContent set(String secretIdentifier, SecretRequestMessageWithRawJsonContent request) throws IOException, ServiceException {
        // Validate
        if (secretIdentifier == null) {
            throw new NullPointerException("secretIdentifier");
        }
        if (request == null) {
            throw new NullPointerException("request");
        }

        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("secretIdentifier", secretIdentifier);
            tracingParameters.put("request", request);
            CloudTracing.enter(invocationId, this, "setAsync", tracingParameters);
        }

        // Construct URL
        String url = "";
        url = url + secretIdentifier;
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        url = url.replace(" ", "%20");

        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);

        // Set Headers
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");

        // Serialize Request
        String requestContent = request.getRawJsonRequest();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");

        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.create(httpRequest, requestContent, httpResponse, httpResponse.getEntity(), "Json");
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }

            // Create Result
            SecretResponseMessageWithRawJsonContent result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new SecretResponseMessageWithRawJsonContent();
            result.setResponse(StreamUtils.toString(responseContent));

            result.setStatusCode(statusCode);

            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    /**
     * Update the specified secret
     *
     * @param secretIdentifier
     *            Required.
     * @param request
     *            Required.
     * @return Represents the response to a secret operation request.
     */
    @Override
    public Future<SecretResponseMessageWithRawJsonContent> updateAsync(final String secretIdentifier, final SecretRequestMessageWithRawJsonContent request) {
        return getClient().getExecutorService().submit(new Callable<SecretResponseMessageWithRawJsonContent>() {
            @Override
            public SecretResponseMessageWithRawJsonContent call() throws Exception {
                return update(secretIdentifier, request);
            }
        });
    }

    /**
     * Update the specified secret
     *
     * @param secretIdentifier
     *            Required.
     * @param request
     *            Required.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred. This
     *             class is the general class of exceptions produced by failed
     *             or interrupted I/O operations.
     * @throws ServiceException
     *             Thrown if an unexpected response is found.
     * @return Represents the response to a secret operation request.
     */
    @Override
    public SecretResponseMessageWithRawJsonContent update(String secretIdentifier, SecretRequestMessageWithRawJsonContent request) throws IOException, ServiceException {
        // Validate
        if (secretIdentifier == null) {
            throw new NullPointerException("secretIdentifier");
        }
        if (request == null) {
            throw new NullPointerException("request");
        }

        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("secretIdentifier", secretIdentifier);
            tracingParameters.put("request", request);
            CloudTracing.enter(invocationId, this, "updateAsync", tracingParameters);
        }

        // Construct URL
        String url = "";
        url = url + secretIdentifier;
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        url = url.replace(" ", "%20");

        // Create HTTP transport objects
        HttpPatch httpRequest = new HttpPatch(url);

        // Set Headers
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");

        // Serialize Request
        String requestContent = request.getRawJsonRequest();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");

        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.create(httpRequest, requestContent, httpResponse, httpResponse.getEntity(), "Json");
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }

            // Create Result
            SecretResponseMessageWithRawJsonContent result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new SecretResponseMessageWithRawJsonContent();
            result.setResponse(StreamUtils.toString(responseContent));

            result.setStatusCode(statusCode);

            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
