/**
 *
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

// Warning: This code was generated by a tool.
//
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.keyvault;

import java.io.IOException;
import java.util.concurrent.Future;

import com.microsoft.windowsazure.exception.ServiceException;

/**
 * Operations for secrets in a vault
 */
interface SecretOperations {
    /**
     * Delete the specified secret
     *
     * @param secretIdentifier
     *            Required.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred. This
     *             class is the general class of exceptions produced by failed
     *             or interrupted I/O operations.
     * @throws ServiceException
     *             Thrown if an unexpected response is found.
     * @return Represents the response to a secret operation request.
     */
    SecretResponseMessageWithRawJsonContent delete(String secretIdentifier) throws IOException, ServiceException;

    /**
     * Delete the specified secret
     *
     * @param secretIdentifier
     *            Required.
     * @return Represents the response to a secret operation request.
     */
    Future<SecretResponseMessageWithRawJsonContent> deleteAsync(String secretIdentifier);

    /**
     * Gets a secret
     *
     * @param secretIdentifier
     *            Required.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred. This
     *             class is the general class of exceptions produced by failed
     *             or interrupted I/O operations.
     * @throws ServiceException
     *             Thrown if an unexpected response is found.
     * @return Represents the response to a secret operation request.
     */
    SecretResponseMessageWithRawJsonContent get(String secretIdentifier) throws IOException, ServiceException;

    /**
     * Gets a secret
     *
     * @param secretIdentifier
     *            Required.
     * @return Represents the response to a secret operation request.
     */
    Future<SecretResponseMessageWithRawJsonContent> getAsync(String secretIdentifier);

    /**
     * List the secrets in the specified vault
     *
     * @param vault
     *            Required.
     * @param top
     *            Required.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred. This
     *             class is the general class of exceptions produced by failed
     *             or interrupted I/O operations.
     * @throws ServiceException
     *             Thrown if an unexpected response is found.
     * @return Represents the response to a secret operation request.
     */
    SecretResponseMessageWithRawJsonContent list(String vault, Integer top) throws IOException, ServiceException;

    /**
     * List the secrets in the specified vault
     *
     * @param vault
     *            Required.
     * @param top
     *            Required.
     * @return Represents the response to a secret operation request.
     */
    Future<SecretResponseMessageWithRawJsonContent> listAsync(String vault, Integer top);

    /**
     * List the next page of secrets in the specified vault
     *
     * @param nextLink
     *            Required.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred. This
     *             class is the general class of exceptions produced by failed
     *             or interrupted I/O operations.
     * @throws ServiceException
     *             Thrown if an unexpected response is found.
     * @return Represents the response to a secret operation request.
     */
    SecretResponseMessageWithRawJsonContent listNext(String nextLink) throws IOException, ServiceException;

    /**
     * List the next page of secrets in the specified vault
     *
     * @param nextLink
     *            Required.
     * @return Represents the response to a secret operation request.
     */
    Future<SecretResponseMessageWithRawJsonContent> listNextAsync(String nextLink);

    /**
     * List the versions of a secret in the specified vault
     *
     * @param vault
     *            Required.
     * @param secretName
     *            Required.
     * @param top
     *            Required.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred. This
     *             class is the general class of exceptions produced by failed
     *             or interrupted I/O operations.
     * @throws ServiceException
     *             Thrown if an unexpected response is found.
     * @return Represents the response to a secret operation request.
     */
    SecretResponseMessageWithRawJsonContent listVersions(String vault, String secretName, Integer top) throws IOException, ServiceException;

    /**
     * List the versions of a secret in the specified vault
     *
     * @param vault
     *            Required.
     * @param secretName
     *            Required.
     * @param top
     *            Required.
     * @return Represents the response to a secret operation request.
     */
    Future<SecretResponseMessageWithRawJsonContent> listVersionsAsync(String vault, String secretName, Integer top);

    /**
     * List the versions of a secret in the specified vault
     *
     * @param nextLink
     *            Required.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred. This
     *             class is the general class of exceptions produced by failed
     *             or interrupted I/O operations.
     * @throws ServiceException
     *             Thrown if an unexpected response is found.
     * @return Represents the response to a secret operation request.
     */
    SecretResponseMessageWithRawJsonContent listVersionsNext(String nextLink) throws IOException, ServiceException;

    /**
     * List the versions of a secret in the specified vault
     *
     * @param nextLink
     *            Required.
     * @return Represents the response to a secret operation request.
     */
    Future<SecretResponseMessageWithRawJsonContent> listVersionsNextAsync(String nextLink);

    /**
     * Sets a secret in the specified vault.
     *
     * @param secretIdentifier
     *            Required.
     * @param request
     *            Required.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred. This
     *             class is the general class of exceptions produced by failed
     *             or interrupted I/O operations.
     * @throws ServiceException
     *             Thrown if an unexpected response is found.
     * @return Represents the response to a secret operation request.
     */
    SecretResponseMessageWithRawJsonContent set(String secretIdentifier, SecretRequestMessageWithRawJsonContent request) throws IOException, ServiceException;

    /**
     * Sets a secret in the specified vault.
     *
     * @param secretIdentifier
     *            Required.
     * @param request
     *            Required.
     * @return Represents the response to a secret operation request.
     */
    Future<SecretResponseMessageWithRawJsonContent> setAsync(String secretIdentifier, SecretRequestMessageWithRawJsonContent request);

    /**
     * Update the specified secret
     *
     * @param secretIdentifier
     *            Required.
     * @param request
     *            Required.
     * @throws IOException
     *             Signals that an I/O exception of some sort has occurred. This
     *             class is the general class of exceptions produced by failed
     *             or interrupted I/O operations.
     * @throws ServiceException
     *             Thrown if an unexpected response is found.
     * @return Represents the response to a secret operation request.
     */
    SecretResponseMessageWithRawJsonContent update(String secretIdentifier, SecretRequestMessageWithRawJsonContent request) throws IOException, ServiceException;

    /**
     * Update the specified secret
     *
     * @param secretIdentifier
     *            Required.
     * @param request
     *            Required.
     * @return Represents the response to a secret operation request.
     */
    Future<SecretResponseMessageWithRawJsonContent> updateAsync(String secretIdentifier, SecretRequestMessageWithRawJsonContent request);
}
