/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.core;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final Pattern FIRST_PATH_FRAGMENT_REGEX = Pattern.compile("^([/]?[\\w\\-\\.]+[/]?)");

    public static String splitCamelCase(String s, String separator) {
        if (Strings.isNullOrEmpty((String)s)) {
            return "";
        }
        return s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), separator);
    }

    public static String maybeChompLeadingSlash(String anyString) {
        if (Strings.isNullOrEmpty((String)anyString) || !anyString.startsWith("/")) {
            return anyString;
        }
        return anyString.replaceFirst("^/", "");
    }

    public static String maybeChompTrailingSlash(String anyString) {
        if (Strings.isNullOrEmpty((String)anyString) || !anyString.endsWith("/")) {
            return anyString;
        }
        return anyString.replaceFirst("/$", "");
    }

    public static String firstPathSegment(String anyString) {
        if (Strings.isNullOrEmpty((String)anyString)) {
            return anyString;
        }
        Matcher matcher = FIRST_PATH_FRAGMENT_REGEX.matcher(anyString);
        if (matcher.find()) {
            return StringUtils.maybeChompTrailingSlash(matcher.group());
        }
        return anyString;
    }
}

