/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models.property.bean;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.common.base.Optional;
import com.mangofactory.swagger.models.Annotations;
import com.mangofactory.swagger.models.alternates.AlternateTypeProvider;
import com.mangofactory.swagger.models.property.BaseModelProperty;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Type;

public class BeanModelProperty
extends BaseModelProperty {
    private final ResolvedMethod method;
    private final boolean isGetter;
    private TypeResolver typeResolver;

    public BeanModelProperty(String propertyName, BeanPropertyDefinition beanPropertyDefinition, ResolvedMethod method, boolean isGetter, TypeResolver typeResolver, AlternateTypeProvider alternateTypeProvider) {
        super(propertyName, alternateTypeProvider, (Optional<ApiModelProperty>)Optional.fromNullable((Object)Annotations.findPropertyAnnotation(beanPropertyDefinition, ApiModelProperty.class)));
        this.method = method;
        this.isGetter = isGetter;
        this.typeResolver = typeResolver;
    }

    @Override
    protected ResolvedType realType() {
        if (this.isGetter) {
            if (this.method.getReturnType().getErasedType().getTypeParameters().length > 0) {
                return this.method.getReturnType();
            }
            return this.typeResolver.resolve((Type)this.method.getReturnType().getErasedType(), new Type[0]);
        }
        if (this.method.getArgumentType(0).getErasedType().getTypeParameters().length > 0) {
            return this.method.getArgumentType(0);
        }
        return this.typeResolver.resolve((Type)this.method.getArgumentType(0).getErasedType(), new Type[0]);
    }

    public static boolean accessorMemberIs(ResolvedMember method, String methodName) {
        return method.getRawMember().getName().equals(methodName);
    }
}

