/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.spring;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.Service;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.util.ReflectionUtils;

final class ThriftServiceUtils {
    @Nullable
    private static final Class<?> thriftServiceClass = ThriftServiceUtils.findClass("com.linecorp.armeria.server.thrift.THttpService");
    @Nullable
    private static final Method entriesMethod = thriftServiceClass != null ? ReflectionUtils.findMethod(thriftServiceClass, (String)"entries") : null;
    @Nullable
    private static final Method interfacesMethod;

    private ThriftServiceUtils() {
    }

    @Nullable
    private static Class<?> findClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static Set<String> serviceNames(Service<HttpRequest, HttpResponse> service) {
        if (thriftServiceClass == null || entriesMethod == null || interfacesMethod == null) {
            return ImmutableSet.of();
        }
        return service.as(thriftServiceClass).map(s -> {
            Map entries = (Map)ReflectionUtils.invokeMethod((Method)entriesMethod, (Object)s);
            assert (entries != null);
            return ThriftServiceUtils.toServiceName(entries.values());
        }).orElse((Set)ImmutableSet.of());
    }

    private static Set<String> toServiceName(Collection<?> entries) {
        return (Set)entries.stream().flatMap(entry -> {
            Set ifaces = (Set)ReflectionUtils.invokeMethod((Method)interfacesMethod, (Object)entry);
            assert (ifaces != null);
            return ifaces.stream();
        }).map(iface -> iface.getEnclosingClass().getName()).collect(ImmutableSet.toImmutableSet());
    }

    static {
        Class<?> thriftServiceEntryClass = ThriftServiceUtils.findClass("com.linecorp.armeria.server.thrift.ThriftServiceEntry");
        interfacesMethod = thriftServiceEntryClass != null ? ReflectionUtils.findMethod(thriftServiceEntryClass, (String)"interfaces") : null;
    }
}

