/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logback;

import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public enum BuiltInProperty {
    REMOTE_HOST("remote.host"),
    REMOTE_IP("remote.ip"),
    REMOTE_PORT("remote.port"),
    LOCAL_HOST("local.host"),
    LOCAL_IP("local.ip"),
    LOCAL_PORT("local.port"),
    CLIENT_IP("client.ip"),
    SCHEME("scheme"),
    ELAPSED_NANOS("elapsed_nanos"),
    REQ_DIRECTION("req.direction"),
    REQ_AUTHORITY("req.authority"),
    REQ_PATH("req.path"),
    REQ_QUERY("req.query"),
    REQ_METHOD("req.method"),
    REQ_RPC_METHOD("req.rpc_method"),
    REQ_RPC_PARAMS("req.rpc_params"),
    REQ_CONTENT_LENGTH("req.content_length"),
    RES_STATUS_CODE("res.status_code"),
    RES_RPC_RESULT("res.rpc_result"),
    RES_CONTENT_LENGTH("res.content_length"),
    TLS_SESSION_ID("tls.session_id"),
    TLS_CIPHER("tls.cipher"),
    TLS_PROTO("tls.proto");

    private static final Map<String, BuiltInProperty> mdcKeyToEnum;
    static final String WILDCARD_STR = "*";
    static final String WILDCARD_REGEX = "\\*";
    final String mdcKey;

    static List<BuiltInProperty> findByMdcKeyPattern(String mdcKeyPattern) {
        Pattern pattern = Pattern.compile(("\\Q" + mdcKeyPattern + "\\E").replaceAll(WILDCARD_REGEX, "\\\\E.*\\\\Q"));
        return (List)mdcKeyToEnum.entrySet().stream().filter(e -> pattern.matcher((CharSequence)e.getKey()).matches()).map(Map.Entry::getValue).collect(ImmutableList.toImmutableList());
    }

    private BuiltInProperty(String mdcKey) {
        this.mdcKey = mdcKey;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BuiltInProperty k : BuiltInProperty.values()) {
            builder.put((Object)k.mdcKey, (Object)k);
        }
        mdcKeyToEnum = builder.build();
    }
}

