/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logback;

import com.linecorp.armeria.common.logback.BuiltInProperty;

final class BuiltInProperties {
    private static final BuiltInProperty[] allValues = BuiltInProperty.values();
    private static final long MASK_ADDRESSES = BuiltInProperties.mask(BuiltInProperty.REMOTE_HOST, BuiltInProperty.REMOTE_IP, BuiltInProperty.REMOTE_PORT, BuiltInProperty.LOCAL_HOST, BuiltInProperty.LOCAL_IP, BuiltInProperty.LOCAL_PORT, BuiltInProperty.CLIENT_IP);
    private static final long MASK_RPC = BuiltInProperties.mask(BuiltInProperty.REQ_RPC_METHOD, BuiltInProperty.REQ_RPC_PARAMS, BuiltInProperty.RES_RPC_RESULT);
    private static final long MASK_SSL = BuiltInProperties.mask(BuiltInProperty.TLS_SESSION_ID, BuiltInProperty.TLS_CIPHER, BuiltInProperty.TLS_PROTO);
    private long elements;

    BuiltInProperties() {
    }

    void add(BuiltInProperty e) {
        this.elements |= 1L << e.ordinal();
    }

    boolean contains(BuiltInProperty e) {
        return (this.elements & BuiltInProperties.mask(e)) != 0L;
    }

    boolean containsAddresses() {
        return (this.elements & MASK_ADDRESSES) != 0L;
    }

    boolean containsRpc() {
        return (this.elements & MASK_RPC) != 0L;
    }

    boolean containsSsl() {
        return (this.elements & MASK_SSL) != 0L;
    }

    private static long mask(BuiltInProperty e) {
        return 1L << e.ordinal();
    }

    private static long mask(BuiltInProperty ... elems) {
        long mask = 0L;
        for (BuiltInProperty e : elems) {
            mask |= BuiltInProperties.mask(e);
        }
        return mask;
    }
}

