/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ValueCompareException;
import com.jayway.jsonpath.internal.Path;
import com.jayway.jsonpath.internal.PathCompiler;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.internal.token.PredicateContextImpl;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Criteria
implements Predicate {
    private static final Logger logger = LoggerFactory.getLogger(Criteria.class);
    private static final String[] OPERATORS = new String[]{CriteriaType.EQ.toString(), CriteriaType.GTE.toString(), CriteriaType.LTE.toString(), CriteriaType.NE.toString(), CriteriaType.LT.toString(), CriteriaType.GT.toString(), CriteriaType.REGEX.toString()};
    private Object left;
    private CriteriaType criteriaType;
    private Object right;
    private final List<Criteria> criteriaChain;

    private Criteria(List<Criteria> criteriaChain, Object left) {
        this.left = left;
        this.criteriaChain = criteriaChain;
        this.criteriaChain.add(this);
    }

    private Criteria(Object left) {
        this(new LinkedList<Criteria>(), left);
    }

    private Criteria(Object left, CriteriaType criteriaType, Object right) {
        this(new LinkedList<Criteria>(), left);
        this.criteriaType = criteriaType;
        this.right = right;
    }

    @Override
    public boolean apply(Predicate.PredicateContext ctx) {
        for (Criteria criteria : this.criteriaChain) {
            if (criteria.eval(ctx)) continue;
            return false;
        }
        return true;
    }

    private Object evaluateIfPath(Object target, Predicate.PredicateContext ctx) {
        Object res = target;
        if (res instanceof Path) {
            Path leftPath = (Path)target;
            if (ctx instanceof PredicateContextImpl) {
                PredicateContextImpl ctxi = (PredicateContextImpl)ctx;
                res = ctxi.evaluate(leftPath);
            } else {
                Object doc = leftPath.isRootPath() ? ctx.root() : ctx.item();
                res = leftPath.evaluate(doc, ctx.root(), ctx.configuration()).getValue();
            }
        }
        return res == null ? null : ctx.configuration().jsonProvider().unwrap(res);
    }

    private boolean eval(Predicate.PredicateContext ctx) {
        if (CriteriaType.EXISTS == this.criteriaType) {
            boolean exists = (Boolean)this.right;
            try {
                Configuration c = Configuration.builder().jsonProvider(ctx.configuration().jsonProvider()).options(Option.REQUIRE_PROPERTIES).build();
                Object value = ((Path)this.left).evaluate(ctx.item(), ctx.root(), c).getValue();
                if (exists) {
                    return value != null;
                }
                return value == null;
            }
            catch (PathNotFoundException e) {
                return !exists;
            }
        }
        try {
            Object leftVal = this.evaluateIfPath(this.left, ctx);
            Object rightVal = this.evaluateIfPath(this.right, ctx);
            return this.criteriaType.eval(rightVal, leftVal, ctx);
        }
        catch (ValueCompareException e) {
            return false;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    public static Criteria where(Path key) {
        return new Criteria(key);
    }

    public static Criteria where(String key) {
        if (!key.startsWith("$") && !key.startsWith("@")) {
            key = "@." + key;
        }
        return Criteria.where(PathCompiler.compile(key, new Predicate[0]));
    }

    public Criteria and(String key) {
        if (!key.startsWith("$") && !key.startsWith("@")) {
            key = "@." + key;
        }
        return new Criteria(this.criteriaChain, PathCompiler.compile(key, new Predicate[0]));
    }

    public Criteria is(Object o) {
        this.criteriaType = CriteriaType.EQ;
        this.right = o;
        return this;
    }

    public Criteria eq(Object o) {
        return this.is(o);
    }

    public Criteria ne(Object o) {
        this.criteriaType = CriteriaType.NE;
        this.right = o;
        return this;
    }

    public Criteria lt(Object o) {
        this.criteriaType = CriteriaType.LT;
        this.right = o;
        return this;
    }

    public Criteria lte(Object o) {
        this.criteriaType = CriteriaType.LTE;
        this.right = o;
        return this;
    }

    public Criteria gt(Object o) {
        this.criteriaType = CriteriaType.GT;
        this.right = o;
        return this;
    }

    public Criteria gte(Object o) {
        this.criteriaType = CriteriaType.GTE;
        this.right = o;
        return this;
    }

    public Criteria regex(Pattern pattern) {
        Utils.notNull(pattern, "pattern can not be null", new Object[0]);
        this.criteriaType = CriteriaType.REGEX;
        this.right = pattern;
        return this;
    }

    public Criteria in(Object ... o) {
        return this.in(Arrays.asList(o));
    }

    public Criteria in(Collection<?> c) {
        Utils.notNull(c, "collection can not be null", new Object[0]);
        this.criteriaType = CriteriaType.IN;
        this.right = c;
        return this;
    }

    public Criteria contains(Object o) {
        this.criteriaType = CriteriaType.CONTAINS;
        this.right = o;
        return this;
    }

    public Criteria nin(Object ... o) {
        return this.nin(Arrays.asList(o));
    }

    public Criteria nin(Collection<?> c) {
        Utils.notNull(c, "collection can not be null", new Object[0]);
        this.criteriaType = CriteriaType.NIN;
        this.right = c;
        return this;
    }

    public Criteria all(Object ... o) {
        return this.all(Arrays.asList(o));
    }

    public Criteria all(Collection<?> c) {
        Utils.notNull(c, "collection can not be null", new Object[0]);
        this.criteriaType = CriteriaType.ALL;
        this.right = c;
        return this;
    }

    public Criteria size(int size) {
        this.criteriaType = CriteriaType.SIZE;
        this.right = size;
        return this;
    }

    public Criteria exists(boolean b) {
        this.criteriaType = CriteriaType.EXISTS;
        this.right = b;
        return this;
    }

    public Criteria type(Class<?> t) {
        Utils.notNull(t, "type can not be null", new Object[0]);
        this.criteriaType = CriteriaType.TYPE;
        this.right = t;
        return this;
    }

    public Criteria notEmpty() {
        this.criteriaType = CriteriaType.NOT_EMPTY;
        this.right = null;
        return this;
    }

    public Criteria matches(Predicate p) {
        this.criteriaType = CriteriaType.MATCHES;
        this.right = p;
        return this;
    }

    private static boolean isPath(String string) {
        return string != null && (string.startsWith("$") || string.startsWith("@") || string.startsWith("!@"));
    }

    private static boolean isString(String string) {
        return string != null && !string.isEmpty() && string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'';
    }

    private static boolean isPattern(String string) {
        return string != null && !string.isEmpty() && string.charAt(0) == '/' && (string.charAt(string.length() - 1) == '/' || string.charAt(string.length() - 2) == '/' && string.charAt(string.length() - 1) == 'i');
    }

    private static Pattern compilePattern(String string) {
        int lastIndex = string.lastIndexOf(47);
        boolean ignoreCase = string.endsWith("i");
        String regex = string.substring(1, lastIndex);
        int flags = ignoreCase ? 2 : 0;
        return Pattern.compile(regex, flags);
    }

    public static Criteria parse(String criteria) {
        int operatorIndex = -1;
        String left = "";
        String operator = "";
        String right = "";
        for (int y = 0; y < OPERATORS.length; ++y) {
            operatorIndex = criteria.indexOf(OPERATORS[y]);
            if (operatorIndex == -1) continue;
            operator = OPERATORS[y];
            break;
        }
        if (!operator.isEmpty()) {
            left = criteria.substring(0, operatorIndex).trim();
            right = criteria.substring(operatorIndex + operator.length()).trim();
        } else {
            left = criteria.trim();
        }
        return Criteria.create(left, operator, right);
    }

    public static Criteria create(String left, String operator, String right) {
        Object leftPrepared = left;
        Object rightPrepared = right;
        Path leftPath = null;
        Path rightPath = null;
        boolean existsCheck = true;
        if (Criteria.isPath(left)) {
            if (left.charAt(0) == '!') {
                existsCheck = false;
                left = left.substring(1);
            }
            if (!(leftPath = PathCompiler.compile(left, new Predicate[0])).isDefinite()) {
                throw new InvalidPathException("the predicate path: " + left + " is not definite");
            }
            leftPrepared = leftPath;
        } else if (Criteria.isString(left)) {
            leftPrepared = left.substring(1, left.length() - 1);
        } else if (Criteria.isPattern(left)) {
            leftPrepared = Criteria.compilePattern(left);
        }
        if (Criteria.isPath(right)) {
            if (right.charAt(0) == '!') {
                throw new InvalidPathException("Invalid negation! Can only be used for existence check e.g [?(!@.foo)]");
            }
            rightPath = PathCompiler.compile(right, new Predicate[0]);
            if (!rightPath.isDefinite()) {
                throw new InvalidPathException("the predicate path: " + right + " is not definite");
            }
            rightPrepared = rightPath;
        } else if (Criteria.isString(right)) {
            rightPrepared = right.substring(1, right.length() - 1);
        } else if (Criteria.isPattern(right)) {
            rightPrepared = Criteria.compilePattern(right);
        }
        if (leftPath != null && operator.isEmpty()) {
            return Criteria.where(leftPath).exists(existsCheck);
        }
        return new Criteria(leftPrepared, CriteriaType.parse(operator), rightPrepared);
    }

    private static int safeCompare(Object left, Object right) throws ValueCompareException {
        if (left == right) {
            return 0;
        }
        boolean leftNullish = Criteria.isNullish(left);
        boolean rightNullish = Criteria.isNullish(right);
        if (leftNullish && !rightNullish) {
            return -1;
        }
        if (!leftNullish && rightNullish) {
            return 1;
        }
        if (leftNullish && rightNullish) {
            return 0;
        }
        if (left instanceof String && right instanceof String) {
            String exp = (String)left;
            if (exp.contains("'")) {
                exp = exp.replace("\\'", "'");
            }
            return exp.compareTo((String)right);
        }
        if (left instanceof Number && right instanceof Number) {
            return new BigDecimal(left.toString()).compareTo(new BigDecimal(right.toString()));
        }
        if (left instanceof String && right instanceof Number) {
            return new BigDecimal(left.toString()).compareTo(new BigDecimal(right.toString()));
        }
        if (left instanceof String && right instanceof Boolean) {
            Boolean e = Boolean.valueOf((String)left);
            Boolean a = (Boolean)right;
            return e.compareTo(a);
        }
        if (left instanceof Boolean && right instanceof Boolean) {
            Boolean e = (Boolean)left;
            Boolean a = (Boolean)right;
            return e.compareTo(a);
        }
        logger.debug("Can not compare a {} with a {}", (Object)left.getClass().getName(), (Object)right.getClass().getName());
        throw new ValueCompareException();
    }

    private static boolean isNullish(Object o) {
        return o == null || o instanceof String && "null".equals(o);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.left.toString()).append(this.criteriaType.toString()).append(Criteria.wrapString(this.right));
        return sb.toString();
    }

    private static String wrapString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return "'" + o.toString() + "'";
        }
        return o.toString();
    }

    private static enum CriteriaType {
        EQ{

            @Override
            boolean eval(Object expected, Object model, Predicate.PredicateContext ctx) {
                boolean res;
                boolean bl = res = 0 == Criteria.safeCompare(expected, model);
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", new Object[]{model, this.name(), expected, res});
                }
                return res;
            }

            public String toString() {
                return "==";
            }
        }
        ,
        NE{

            @Override
            boolean eval(Object expected, Object model, Predicate.PredicateContext ctx) {
                boolean res;
                boolean bl = res = 0 != Criteria.safeCompare(expected, model);
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", new Object[]{model, this.name(), expected, res});
                }
                return res;
            }

            public String toString() {
                return "!=";
            }
        }
        ,
        GT{

            @Override
            boolean eval(Object expected, Object model, Predicate.PredicateContext ctx) {
                boolean res;
                if (expected == null ^ model == null) {
                    return false;
                }
                boolean bl = res = 0 > Criteria.safeCompare(expected, model);
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", new Object[]{model, this.name(), expected, res});
                }
                return res;
            }

            public String toString() {
                return ">";
            }
        }
        ,
        GTE{

            @Override
            boolean eval(Object expected, Object model, Predicate.PredicateContext ctx) {
                boolean res;
                if (expected == null ^ model == null) {
                    return false;
                }
                boolean bl = res = 0 >= Criteria.safeCompare(expected, model);
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", new Object[]{model, this.name(), expected, res});
                }
                return res;
            }

            public String toString() {
                return ">=";
            }
        }
        ,
        LT{

            @Override
            boolean eval(Object expected, Object model, Predicate.PredicateContext ctx) {
                boolean res;
                if (expected == null ^ model == null) {
                    return false;
                }
                boolean bl = res = 0 < Criteria.safeCompare(expected, model);
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", new Object[]{model, this.name(), expected, res});
                }
                return res;
            }

            public String toString() {
                return "<";
            }
        }
        ,
        LTE{

            @Override
            boolean eval(Object expected, Object model, Predicate.PredicateContext ctx) {
                boolean res;
                if (expected == null ^ model == null) {
                    return false;
                }
                boolean bl = res = 0 <= Criteria.safeCompare(expected, model);
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", new Object[]{model, this.name(), expected, res});
                }
                return res;
            }

            public String toString() {
                return "<=";
            }
        }
        ,
        IN{

            @Override
            boolean eval(Object expected, Object model, Predicate.PredicateContext ctx) {
                boolean res = false;
                Collection exps = (Collection)expected;
                for (Object exp : exps) {
                    if (0 != Criteria.safeCompare(exp, model)) continue;
                    res = true;
                    break;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", new Object[]{model, this.name(), Utils.join(", ", exps), res});
                }
                return res;
            }
        }
        ,
        NIN{

            @Override
            boolean eval(Object expected, Object model, Predicate.PredicateContext ctx) {
                boolean res;
                Collection nexps = (Collection)expected;
                boolean bl = res = !nexps.contains(model);
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", new Object[]{model, this.name(), Utils.join(", ", nexps), res});
                }
                return res;
            }
        }
        ,
        CONTAINS{

            @Override
            boolean eval(Object expected, Object model, Predicate.PredicateContext ctx) {
                boolean res = false;
                if (ctx.configuration().jsonProvider().isArray(model)) {
                    for (Object o : ctx.configuration().jsonProvider().toIterable(model)) {
                        if (!expected.equals(o)) continue;
                        res = true;
                        break;
                    }
                } else if (model instanceof String) {
                    res = Criteria.isNullish(expected) || !(expected instanceof String) ? false : ((String)model).contains((String)expected);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", new Object[]{model, this.name(), expected, res});
                }
                return res;
            }
        }
        ,
        ALL{

            @Override
            boolean eval(Object expected, Object model, Predicate.PredicateContext ctx) {
                boolean res = true;
                Collection exps = (Collection)expected;
                if (ctx.configuration().jsonProvider().isArray(model)) {
                    for (Object exp : exps) {
                        boolean found = false;
                        for (Object check : ctx.configuration().jsonProvider().toIterable(model)) {
                            if (0 != Criteria.safeCompare(exp, check)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        res = false;
                        break;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("[{}] {} [{}] => {}", new Object[]{Utils.join(", ", ctx.configuration().jsonProvider().toIterable(model)), this.name(), Utils.join(", ", exps), res});
                    }
                } else {
                    res = false;
                    if (logger.isDebugEnabled()) {
                        logger.debug("[{}] {} [{}] => {}", new Object[]{"<NOT AN ARRAY>", this.name(), Utils.join(", ", exps), res});
                    }
                }
                return res;
            }
        }
        ,
        SIZE{

            @Override
            boolean eval(Object expected, Object model, Predicate.PredicateContext ctx) {
                boolean res;
                int size = (Integer)expected;
                if (ctx.configuration().jsonProvider().isArray(model)) {
                    int length = ctx.configuration().jsonProvider().length(model);
                    boolean bl = res = length == size;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Array with size {} {} {} => {}", new Object[]{length, this.name(), size, res});
                    }
                } else if (model instanceof String) {
                    int length = ((String)model).length();
                    boolean bl = res = length == size;
                    if (logger.isDebugEnabled()) {
                        logger.debug("String with length {} {} {} => {}", new Object[]{length, this.name(), size, res});
                    }
                } else {
                    res = false;
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} {} {} => {}", new Object[]{model == null ? "null" : model.getClass().getName(), this.name(), size, res});
                    }
                }
                return res;
            }
        }
        ,
        EXISTS{

            @Override
            boolean eval(Object expected, Object model, Predicate.PredicateContext ctx) {
                throw new UnsupportedOperationException();
            }
        }
        ,
        TYPE{

            @Override
            boolean eval(Object expected, Object model, Predicate.PredicateContext ctx) {
                Class expType = (Class)expected;
                Class<?> actType = model == null ? null : model.getClass();
                return actType != null && expType.isAssignableFrom(actType);
            }
        }
        ,
        REGEX{

            @Override
            boolean eval(Object expected, Object model, Predicate.PredicateContext ctx) {
                Object target;
                Pattern pattern;
                boolean res = false;
                if (model instanceof Pattern) {
                    pattern = (Pattern)model;
                    target = expected;
                } else {
                    pattern = (Pattern)expected;
                    target = model;
                }
                if (target != null) {
                    res = pattern.matcher(target.toString()).matches();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("[{}] {} [{}] => {}", new Object[]{model == null ? "null" : model.toString(), this.name(), expected == null ? "null" : expected.toString(), res});
                }
                return res;
            }

            public String toString() {
                return "=~";
            }
        }
        ,
        MATCHES{

            @Override
            boolean eval(Object expected, Object model, Predicate.PredicateContext ctx) {
                PredicateContextImpl pci = (PredicateContextImpl)ctx;
                Predicate exp = (Predicate)expected;
                return exp.apply(new PredicateContextImpl(model, ctx.root(), ctx.configuration(), pci.documentPathCache()));
            }
        }
        ,
        NOT_EMPTY{

            @Override
            boolean eval(Object expected, Object model, Predicate.PredicateContext ctx) {
                boolean res = false;
                if (model != null) {
                    if (ctx.configuration().jsonProvider().isArray(model)) {
                        int len = ctx.configuration().jsonProvider().length(model);
                        boolean bl = res = 0 != len;
                        if (logger.isDebugEnabled()) {
                            logger.debug("array length = {} {} => {}", new Object[]{len, this.name(), res});
                        }
                    } else if (model instanceof String) {
                        int len = ((String)model).length();
                        boolean bl = res = 0 != len;
                        if (logger.isDebugEnabled()) {
                            logger.debug("string length = {} {} => {}", new Object[]{len, this.name(), res});
                        }
                    }
                }
                return res;
            }
        };


        abstract boolean eval(Object var1, Object var2, Predicate.PredicateContext var3);

        public static CriteriaType parse(String str) {
            if ("==".equals(str)) {
                return EQ;
            }
            if (">".equals(str)) {
                return GT;
            }
            if (">=".equals(str)) {
                return GTE;
            }
            if ("<".equals(str)) {
                return LT;
            }
            if ("<=".equals(str)) {
                return LTE;
            }
            if ("!=".equals(str)) {
                return NE;
            }
            if ("=~".equals(str)) {
                return REGEX;
            }
            throw new UnsupportedOperationException("CriteriaType " + str + " can not be parsed");
        }
    }
}

