/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.kit;

import java.util.Map;
import org.beetl.sql.core.kit.SqlFormatter;

public final class PageKit {
    static String pageNumberName = "pageNumber";
    static String pageSizeName = "pageSize";
    static int pageSizeValue = 20;

    public static String formatSql(String sql) {
        return SqlFormatter.format(sql);
    }

    public static int getPageNumber(Map<String, Object> paras) {
        Integer pageNumber = (Integer)paras.get(pageNumberName);
        return pageNumber == null ? 1 : pageNumber;
    }

    public static int getPageSize(Map<String, Object> paras) {
        Integer pageSize = (Integer)paras.get(pageSizeName);
        return pageSize == null ? pageSizeValue : pageSize;
    }

    public static String getCountSql(String selectSql) {
        String sql = (selectSql = PageKit.formatSql(selectSql)).toLowerCase();
        boolean hasOrderBy = sql.indexOf("    order by") != -1;
        boolean fromIndexOver = false;
        int fromIndex = 0;
        int fromEnd = 0;
        for (String s : sql.split("\n")) {
            if (!fromIndexOver && s.equals("    from")) {
                fromIndexOver = true;
                if (!hasOrderBy) break;
            }
            if (s.equals("    order by")) break;
            if (!fromIndexOver) {
                fromIndex += s.length() + 1;
            }
            fromEnd += s.length() + 1;
        }
        if (hasOrderBy) {
            return "select count(1) \n" + selectSql.substring(fromIndex, fromEnd);
        }
        return "select count(1) \n" + selectSql.substring(fromIndex);
    }

    public static void main(String[] args) {
        String sql = "select * from user #abcd# where 1=1 and c=#abc# order #text('acd.123/2')#";
        sql = PageKit.getCountSql(sql);
        System.out.println(sql);
    }
}

