/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.beetl.sql.core.annotatoin.AssignID;
import org.beetl.sql.core.annotatoin.AutoID;
import org.beetl.sql.core.annotatoin.SeqID;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.db.KeyWordHandler;
import org.beetl.sql.core.db.PageParamKit;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.kit.BeanKit;

public class DB2SqlStyle
extends AbstractDBStyle {
    public DB2SqlStyle() {
        this.keyWordHandler = new KeyWordHandler(){

            @Override
            public String getTable(String tableName) {
                return tableName;
            }

            @Override
            public String getCol(String colName) {
                return colName;
            }
        };
    }

    @Override
    public String getPageSQL(String sql) {
        return " SELECT * FROM (\tSELECT inner_query_b.*, ROWNUMBER() OVER() beetl_rn  FROM   \t(   " + sql + this.getOrderBy() + "\t) AS inner_query_b  " + " )AS inner_query_a WHERE inner_query_a.beetl_rn BETWEEN " + this.HOLDER_START + "_pageOffset" + this.HOLDER_END + " and " + this.HOLDER_START + "_pageEnd" + this.HOLDER_END;
    }

    @Override
    public String getPageSQLStatement(String sql, long offset, long pageSize) {
        offset = PageParamKit.db2sqlOffset(this.offsetStartZero, offset);
        long pageEnd = PageParamKit.db2sqlPageEnd(offset, pageSize);
        int capacity = sql.length() + 180;
        StringBuilder builder = new StringBuilder(capacity);
        builder.append(" SELECT * FROM ").append("(");
        builder.append("\tSELECT inner_query_b.*, ROWNUMBER() OVER() beetl_rn  FROM   ");
        builder.append("\t(   ").append(sql).append("\t) AS inner_query_b  ");
        builder.append(" )AS inner_query_a WHERE inner_query_a.beetl_rn BETWEEN ");
        builder.append(offset).append(" and ").append(pageEnd);
        return builder.toString();
    }

    @Override
    public void initPagePara(Map<String, Object> paras, long start, long size) {
        long s = start + (long)(this.offsetStartZero ? 1 : 0);
        paras.put("_pageOffset", s);
        paras.put("_pageEnd", s + size - 1L);
    }

    @Override
    public int getIdType(Class c, String idProperty) {
        List<Annotation> ans = BeanKit.getAllAnnoation(c, idProperty);
        int idType = 2;
        for (Annotation an : ans) {
            if (an instanceof AutoID) {
                idType = 2;
                break;
            }
            if (an instanceof SeqID) {
                idType = 3;
                break;
            }
            if (!(an instanceof AssignID)) continue;
            idType = 1;
            break;
        }
        return idType;
    }

    @Override
    public String getName() {
        return "db2";
    }

    @Override
    public int getDBType() {
        return 6;
    }

    @Override
    protected String appendSetColumnAbsolute(Class<?> c, TableDesc table, String colName, String fieldName) {
        int type = table.getColDesc((String)colName).sqlType;
        return this.getKeyWordHandler().getCol(colName) + "=" + this.HOLDER_START + fieldName + ",jdbc='" + type + "'" + this.HOLDER_END + ",";
    }

    @Override
    protected String appendInsertValue(Class<?> c, TableDesc table, String fieldName, String col) {
        int type = table.getColDesc((String)col).sqlType;
        return this.HOLDER_START + fieldName + ",jdbc='" + type + "'" + this.HOLDER_END + ",";
    }

    @Override
    public String getSeqValue(String seqName) {
        return "NEXT VALUE FOR " + seqName + " ";
    }
}

