/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.util.HashMap;
import java.util.Map;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.Tail;
import org.beetl.sql.core.orm.LazyEntity;

public class TailBean
implements Tail {
    protected Map<String, Object> extMap = new HashMap<String, Object>();
    boolean hasLazy = false;

    @Override
    public Object get(String key) {
        if (this.hasLazy) {
            Object o = this.extMap.get(key);
            if (o instanceof LazyEntity) {
                LazyEntity lazyEntity = (LazyEntity)o;
                try {
                    Object real = lazyEntity.get();
                    this.extMap.put(key, real);
                    return real;
                }
                catch (RuntimeException ex) {
                    throw new BeetlSQLException(17, "Lazy Load Error:" + key + "," + ex.getMessage(), ex);
                }
            }
            return o;
        }
        return this.extMap.get(key);
    }

    @Override
    public void set(String key, Object value) {
        if (value instanceof LazyEntity) {
            this.hasLazy = true;
        }
        this.extMap.put(key, value);
    }

    public Map<String, Object> getTails() {
        HashMap<String, Object> newExtMap = new HashMap<String, Object>();
        if (this.hasLazy) {
            for (Map.Entry<String, Object> entry : this.extMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof LazyEntity) {
                    try {
                        LazyEntity lazyEntity = (LazyEntity)value;
                        Object real = lazyEntity.get();
                        newExtMap.put(key, real);
                        continue;
                    }
                    catch (RuntimeException ex) {
                        throw new BeetlSQLException(17, "Lazy Load Error:" + key + "," + ex.getMessage(), ex);
                    }
                }
                newExtMap.put(key, value);
            }
            this.extMap = newExtMap;
            this.hasLazy = false;
        }
        return this.extMap;
    }
}

