/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class DSTransactionManager {
    static ThreadLocal<Boolean> inTrans = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    static ThreadLocal<Map<DataSource, Connection>> conns = new ThreadLocal();

    public static void start() {
        inTrans.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commit() throws SQLException {
        Map<DataSource, Connection> map = conns.get();
        try {
            if (map == null) {
                return;
            }
            SQLException e = null;
            for (Connection conn : map.values()) {
                try {
                    conn.commit();
                }
                catch (SQLException ex) {
                    e = ex;
                }
                finally {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        System.err.println("commit error of connection " + conn + " " + ex.getMessage());
                    }
                }
            }
            if (e != null) {
                throw e;
            }
        }
        finally {
            DSTransactionManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollback() throws SQLException {
        Map<DataSource, Connection> map = conns.get();
        SQLException e = null;
        if (map == null) {
            return;
        }
        try {
            for (Connection conn : map.values()) {
                try {
                    conn.rollback();
                }
                catch (SQLException ex) {
                    e = ex;
                }
                finally {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (e != null) {
                throw e;
            }
        }
        finally {
            DSTransactionManager.clear();
        }
    }

    public static void clear() {
        conns.remove();
        inTrans.remove();
    }

    public static Connection getCurrentThreadConnection(DataSource ds) throws SQLException {
        Map<DataSource, Connection> map = conns.get();
        Connection conn = null;
        if (map == null) {
            map = new HashMap<DataSource, Connection>();
            conn = ds.getConnection();
            conn.setAutoCommit(false);
            map.put(ds, conn);
            conns.set(map);
        } else {
            conn = map.get(ds);
            if (conn != null) {
                return conn;
            }
            conn = ds.getConnection();
            conn.setAutoCommit(false);
            map.put(ds, conn);
        }
        return conn;
    }

    public static boolean inTrans() {
        return inTrans.get();
    }
}

