/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization;

import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.EventHeader;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.FormatDescriptionEventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.AbstractRowsEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.ChecksumType;
import com.github.shyiko.mysql.binlog.event.deserialization.DeleteRowsEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializationException;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventHeaderDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventHeaderV4Deserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.FormatDescriptionEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.GtidEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.IntVarEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.NullEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.PreviousGtidSetDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.QueryEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.RotateEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.RowsQueryEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.TableMapEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.UpdateRowsEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.WriteRowsEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.XAPrepareEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.XidEventDataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class EventDeserializer {
    private final EventHeaderDeserializer eventHeaderDeserializer;
    private final EventDataDeserializer defaultEventDataDeserializer;
    private final Map<EventType, EventDataDeserializer> eventDataDeserializers;
    private EnumSet<CompatibilityMode> compatibilitySet = EnumSet.noneOf(CompatibilityMode.class);
    private int checksumLength;
    private final Map<Long, TableMapEventData> tableMapEventByTableId;
    private EventDataDeserializer tableMapEventDataDeserializer;
    private EventDataDeserializer formatDescEventDataDeserializer;

    public EventDeserializer() {
        this(new EventHeaderV4Deserializer(), new NullEventDataDeserializer());
    }

    public EventDeserializer(EventHeaderDeserializer eventHeaderDeserializer) {
        this(eventHeaderDeserializer, new NullEventDataDeserializer());
    }

    public EventDeserializer(EventDataDeserializer defaultEventDataDeserializer) {
        this(new EventHeaderV4Deserializer(), defaultEventDataDeserializer);
    }

    public EventDeserializer(EventHeaderDeserializer eventHeaderDeserializer, EventDataDeserializer defaultEventDataDeserializer) {
        this.eventHeaderDeserializer = eventHeaderDeserializer;
        this.defaultEventDataDeserializer = defaultEventDataDeserializer;
        this.eventDataDeserializers = new IdentityHashMap<EventType, EventDataDeserializer>();
        this.tableMapEventByTableId = new HashMap<Long, TableMapEventData>();
        this.registerDefaultEventDataDeserializers();
        this.afterEventDataDeserializerSet(null);
    }

    public EventDeserializer(EventHeaderDeserializer eventHeaderDeserializer, EventDataDeserializer defaultEventDataDeserializer, Map<EventType, EventDataDeserializer> eventDataDeserializers, Map<Long, TableMapEventData> tableMapEventByTableId) {
        this.eventHeaderDeserializer = eventHeaderDeserializer;
        this.defaultEventDataDeserializer = defaultEventDataDeserializer;
        this.eventDataDeserializers = eventDataDeserializers;
        this.tableMapEventByTableId = tableMapEventByTableId;
        this.afterEventDataDeserializerSet(null);
    }

    private void registerDefaultEventDataDeserializers() {
        this.eventDataDeserializers.put(EventType.FORMAT_DESCRIPTION, new FormatDescriptionEventDataDeserializer());
        this.eventDataDeserializers.put(EventType.ROTATE, new RotateEventDataDeserializer());
        this.eventDataDeserializers.put(EventType.INTVAR, new IntVarEventDataDeserializer());
        this.eventDataDeserializers.put(EventType.QUERY, new QueryEventDataDeserializer());
        this.eventDataDeserializers.put(EventType.TABLE_MAP, new TableMapEventDataDeserializer());
        this.eventDataDeserializers.put(EventType.XID, new XidEventDataDeserializer());
        this.eventDataDeserializers.put(EventType.WRITE_ROWS, new WriteRowsEventDataDeserializer(this.tableMapEventByTableId));
        this.eventDataDeserializers.put(EventType.UPDATE_ROWS, new UpdateRowsEventDataDeserializer(this.tableMapEventByTableId));
        this.eventDataDeserializers.put(EventType.DELETE_ROWS, new DeleteRowsEventDataDeserializer(this.tableMapEventByTableId));
        this.eventDataDeserializers.put(EventType.EXT_WRITE_ROWS, new WriteRowsEventDataDeserializer(this.tableMapEventByTableId).setMayContainExtraInformation(true));
        this.eventDataDeserializers.put(EventType.EXT_UPDATE_ROWS, new UpdateRowsEventDataDeserializer(this.tableMapEventByTableId).setMayContainExtraInformation(true));
        this.eventDataDeserializers.put(EventType.EXT_DELETE_ROWS, new DeleteRowsEventDataDeserializer(this.tableMapEventByTableId).setMayContainExtraInformation(true));
        this.eventDataDeserializers.put(EventType.ROWS_QUERY, new RowsQueryEventDataDeserializer());
        this.eventDataDeserializers.put(EventType.GTID, new GtidEventDataDeserializer());
        this.eventDataDeserializers.put(EventType.PREVIOUS_GTIDS, new PreviousGtidSetDeserializer());
        this.eventDataDeserializers.put(EventType.XA_PREPARE, new XAPrepareEventDataDeserializer());
    }

    public void setEventDataDeserializer(EventType eventType, EventDataDeserializer eventDataDeserializer) {
        this.ensureCompatibility(eventDataDeserializer);
        this.eventDataDeserializers.put(eventType, eventDataDeserializer);
        this.afterEventDataDeserializerSet(eventType);
    }

    private void afterEventDataDeserializerSet(EventType eventType) {
        EventDataDeserializer eventDataDeserializer;
        if (eventType == null || eventType == EventType.TABLE_MAP) {
            eventDataDeserializer = this.getEventDataDeserializer(EventType.TABLE_MAP);
            this.tableMapEventDataDeserializer = eventDataDeserializer.getClass() != TableMapEventDataDeserializer.class && eventDataDeserializer.getClass() != EventDataWrapper.Deserializer.class ? new EventDataWrapper.Deserializer(new TableMapEventDataDeserializer(), eventDataDeserializer) : null;
        }
        if (eventType == null || eventType == EventType.FORMAT_DESCRIPTION) {
            eventDataDeserializer = this.getEventDataDeserializer(EventType.FORMAT_DESCRIPTION);
            this.formatDescEventDataDeserializer = eventDataDeserializer.getClass() != FormatDescriptionEventDataDeserializer.class && eventDataDeserializer.getClass() != EventDataWrapper.Deserializer.class ? new EventDataWrapper.Deserializer(new FormatDescriptionEventDataDeserializer(), eventDataDeserializer) : null;
        }
    }

    @Deprecated
    public void setChecksumType(ChecksumType checksumType) {
        this.checksumLength = checksumType.getLength();
    }

    public void setCompatibilityMode(CompatibilityMode first, CompatibilityMode ... rest) {
        this.compatibilitySet = EnumSet.of(first, rest);
        for (EventDataDeserializer eventDataDeserializer : this.eventDataDeserializers.values()) {
            this.ensureCompatibility(eventDataDeserializer);
        }
    }

    private void ensureCompatibility(EventDataDeserializer eventDataDeserializer) {
        if (eventDataDeserializer instanceof AbstractRowsEventDataDeserializer) {
            AbstractRowsEventDataDeserializer deserializer = (AbstractRowsEventDataDeserializer)eventDataDeserializer;
            boolean deserializeDateAndTimeAsLong = this.compatibilitySet.contains((Object)CompatibilityMode.DATE_AND_TIME_AS_LONG) || this.compatibilitySet.contains((Object)CompatibilityMode.DATE_AND_TIME_AS_LONG_MICRO);
            deserializer.setDeserializeDateAndTimeAsLong(deserializeDateAndTimeAsLong);
            deserializer.setMicrosecondsPrecision(this.compatibilitySet.contains((Object)CompatibilityMode.DATE_AND_TIME_AS_LONG_MICRO));
            if (this.compatibilitySet.contains((Object)CompatibilityMode.INVALID_DATE_AND_TIME_AS_ZERO)) {
                deserializer.setInvalidDateAndTimeRepresentation(0L);
            }
            if (this.compatibilitySet.contains((Object)CompatibilityMode.INVALID_DATE_AND_TIME_AS_NEGATIVE_ONE)) {
                if (!deserializeDateAndTimeAsLong) {
                    throw new IllegalArgumentException("INVALID_DATE_AND_TIME_AS_NEGATIVE_ONE requires DATE_AND_TIME_AS_LONG or DATE_AND_TIME_AS_LONG_MICRO");
                }
                deserializer.setInvalidDateAndTimeRepresentation(-1L);
            }
            if (this.compatibilitySet.contains((Object)CompatibilityMode.INVALID_DATE_AND_TIME_AS_MIN_VALUE)) {
                if (!deserializeDateAndTimeAsLong) {
                    throw new IllegalArgumentException("INVALID_DATE_AND_TIME_AS_MIN_VALUE requires DATE_AND_TIME_AS_LONG or DATE_AND_TIME_AS_LONG_MICRO");
                }
                deserializer.setInvalidDateAndTimeRepresentation(Long.MIN_VALUE);
            }
            deserializer.setDeserializeCharAndBinaryAsByteArray(this.compatibilitySet.contains((Object)CompatibilityMode.CHAR_AND_BINARY_AS_BYTE_ARRAY));
        }
    }

    public Event nextEvent(ByteArrayInputStream inputStream) throws IOException {
        EventData eventData;
        if (inputStream.peek() == -1) {
            return null;
        }
        Object eventHeader = this.eventHeaderDeserializer.deserialize(inputStream);
        switch (eventHeader.getEventType()) {
            case FORMAT_DESCRIPTION: {
                eventData = this.deserializeFormatDescriptionEventData(inputStream, (EventHeader)eventHeader);
                break;
            }
            case TABLE_MAP: {
                eventData = this.deserializeTableMapEventData(inputStream, (EventHeader)eventHeader);
                break;
            }
            default: {
                EventDataDeserializer eventDataDeserializer = this.getEventDataDeserializer(eventHeader.getEventType());
                eventData = this.deserializeEventData(inputStream, (EventHeader)eventHeader, eventDataDeserializer);
            }
        }
        return new Event((EventHeader)eventHeader, eventData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventData deserializeFormatDescriptionEventData(ByteArrayInputStream inputStream, EventHeader eventHeader) throws EventDataDeserializationException {
        Object eventData;
        EventDataDeserializer eventDataDeserializer = this.formatDescEventDataDeserializer != null ? this.formatDescEventDataDeserializer : this.getEventDataDeserializer(EventType.FORMAT_DESCRIPTION);
        int eventBodyLength = (int)eventHeader.getDataLength();
        try {
            inputStream.enterBlock(eventBodyLength);
            try {
                FormatDescriptionEventData formatDescriptionEvent;
                eventData = eventDataDeserializer.deserialize(inputStream);
                if (eventData instanceof EventDataWrapper) {
                    EventDataWrapper eventDataWrapper = (EventDataWrapper)eventData;
                    formatDescriptionEvent = (FormatDescriptionEventData)eventDataWrapper.getInternal();
                    if (this.formatDescEventDataDeserializer != null) {
                        eventData = eventDataWrapper.getExternal();
                    }
                } else {
                    formatDescriptionEvent = (FormatDescriptionEventData)eventData;
                }
                this.checksumLength = formatDescriptionEvent.getChecksumType().getLength();
            }
            finally {
                inputStream.skipToTheEndOfTheBlock();
            }
        }
        catch (IOException e) {
            throw new EventDataDeserializationException(eventHeader, (Throwable)e);
        }
        return eventData;
    }

    public EventData deserializeTableMapEventData(ByteArrayInputStream inputStream, EventHeader eventHeader) throws IOException {
        TableMapEventData tableMapEvent;
        EventDataDeserializer eventDataDeserializer = this.tableMapEventDataDeserializer != null ? this.tableMapEventDataDeserializer : this.getEventDataDeserializer(EventType.TABLE_MAP);
        EventData eventData = this.deserializeEventData(inputStream, eventHeader, eventDataDeserializer);
        if (eventData instanceof EventDataWrapper) {
            EventDataWrapper eventDataWrapper = (EventDataWrapper)eventData;
            tableMapEvent = (TableMapEventData)eventDataWrapper.getInternal();
            if (this.tableMapEventDataDeserializer != null) {
                eventData = eventDataWrapper.getExternal();
            }
        } else {
            tableMapEvent = (TableMapEventData)eventData;
        }
        this.tableMapEventByTableId.put(tableMapEvent.getTableId(), tableMapEvent);
        return eventData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventData deserializeEventData(ByteArrayInputStream inputStream, EventHeader eventHeader, EventDataDeserializer eventDataDeserializer) throws EventDataDeserializationException {
        Object eventData;
        int eventBodyLength = (int)eventHeader.getDataLength() - this.checksumLength;
        try {
            inputStream.enterBlock(eventBodyLength);
            try {
                eventData = eventDataDeserializer.deserialize(inputStream);
            }
            finally {
                inputStream.skipToTheEndOfTheBlock();
                inputStream.skip(this.checksumLength);
            }
        }
        catch (IOException e) {
            throw new EventDataDeserializationException(eventHeader, (Throwable)e);
        }
        return eventData;
    }

    public EventDataDeserializer getEventDataDeserializer(EventType eventType) {
        EventDataDeserializer eventDataDeserializer = this.eventDataDeserializers.get((Object)eventType);
        return eventDataDeserializer != null ? eventDataDeserializer : this.defaultEventDataDeserializer;
    }

    public static class EventDataWrapper
    implements EventData {
        private EventData internal;
        private EventData external;

        public EventDataWrapper(EventData internal, EventData external) {
            this.internal = internal;
            this.external = external;
        }

        public EventData getInternal() {
            return this.internal;
        }

        public EventData getExternal() {
            return this.external;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("InternalEventData");
            sb.append("{internal=").append(this.internal);
            sb.append(", external=").append(this.external);
            sb.append('}');
            return sb.toString();
        }

        public static EventData internal(EventData eventData) {
            return eventData instanceof EventDataWrapper ? ((EventDataWrapper)eventData).getInternal() : eventData;
        }

        public static class Deserializer
        implements EventDataDeserializer {
            private EventDataDeserializer internal;
            private EventDataDeserializer external;

            public Deserializer(EventDataDeserializer internal, EventDataDeserializer external) {
                this.internal = internal;
                this.external = external;
            }

            public EventData deserialize(ByteArrayInputStream inputStream) throws IOException {
                byte[] bytes = inputStream.read(inputStream.available());
                Object internalEventData = this.internal.deserialize(new ByteArrayInputStream(bytes));
                Object externalEventData = this.external.deserialize(new ByteArrayInputStream(bytes));
                return new EventDataWrapper((EventData)internalEventData, (EventData)externalEventData);
            }
        }
    }

    public static enum CompatibilityMode {
        DATE_AND_TIME_AS_LONG,
        DATE_AND_TIME_AS_LONG_MICRO,
        INVALID_DATE_AND_TIME_AS_ZERO,
        INVALID_DATE_AND_TIME_AS_NEGATIVE_ONE,
        INVALID_DATE_AND_TIME_AS_MIN_VALUE,
        CHAR_AND_BINARY_AS_BYTE_ARRAY;

    }
}

