/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.namespace;

import com.corundumstudio.socketio.AckMode;
import com.corundumstudio.socketio.AckRequest;
import com.corundumstudio.socketio.BroadcastOperations;
import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.MultiTypeArgs;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIONamespace;
import com.corundumstudio.socketio.annotation.ScannerEngine;
import com.corundumstudio.socketio.listener.ConnectListener;
import com.corundumstudio.socketio.listener.DataListener;
import com.corundumstudio.socketio.listener.DisconnectListener;
import com.corundumstudio.socketio.listener.ExceptionListener;
import com.corundumstudio.socketio.listener.MultiTypeEventListener;
import com.corundumstudio.socketio.listener.PingListener;
import com.corundumstudio.socketio.namespace.EventEntry;
import com.corundumstudio.socketio.protocol.JsonSupport;
import com.corundumstudio.socketio.protocol.Packet;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.store.pubsub.JoinLeaveMessage;
import com.corundumstudio.socketio.store.pubsub.PubSubType;
import com.corundumstudio.socketio.transport.NamespaceClient;
import io.netty.util.internal.PlatformDependent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public class Namespace
implements SocketIONamespace {
    public static final String DEFAULT_NAME = "";
    private final ScannerEngine engine = new ScannerEngine();
    private final ConcurrentMap<String, EventEntry<?>> eventListeners = PlatformDependent.newConcurrentHashMap();
    private final Queue<ConnectListener> connectListeners = new ConcurrentLinkedQueue<ConnectListener>();
    private final Queue<DisconnectListener> disconnectListeners = new ConcurrentLinkedQueue<DisconnectListener>();
    private final Queue<PingListener> pingListeners = new ConcurrentLinkedQueue<PingListener>();
    private final Map<UUID, SocketIOClient> allClients = PlatformDependent.newConcurrentHashMap();
    private final ConcurrentMap<String, Set<UUID>> roomClients = PlatformDependent.newConcurrentHashMap();
    private final ConcurrentMap<UUID, Set<String>> clientRooms = PlatformDependent.newConcurrentHashMap();
    private final String name;
    private final AckMode ackMode;
    private final JsonSupport jsonSupport;
    private final StoreFactory storeFactory;
    private final ExceptionListener exceptionListener;

    public Namespace(String name, Configuration configuration) {
        this.name = name;
        this.jsonSupport = configuration.getJsonSupport();
        this.storeFactory = configuration.getStoreFactory();
        this.exceptionListener = configuration.getExceptionListener();
        this.ackMode = configuration.getAckMode();
    }

    public void addClient(SocketIOClient client) {
        this.allClients.put(client.getSessionId(), client);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addMultiTypeEventListener(String eventName, MultiTypeEventListener listener, Class<?> ... eventClass) {
        EventEntry oldEntry;
        EventEntry<MultiTypeArgs> entry = (EventEntry<MultiTypeArgs>)this.eventListeners.get(eventName);
        if (entry == null && (oldEntry = this.eventListeners.putIfAbsent(eventName, entry = new EventEntry<MultiTypeArgs>())) != null) {
            entry = oldEntry;
        }
        entry.addListener(listener);
        this.jsonSupport.addEventMapping(this.name, eventName, eventClass);
    }

    @Override
    public void removeAllListeners(String eventName) {
        EventEntry entry = (EventEntry)this.eventListeners.remove(eventName);
        if (entry != null) {
            this.jsonSupport.removeEventMapping(this.name, eventName);
        }
    }

    @Override
    public <T> void addEventListener(String eventName, Class<T> eventClass, DataListener<T> listener) {
        EventEntry oldEntry;
        EventEntry<T> entry = (EventEntry<T>)this.eventListeners.get(eventName);
        if (entry == null && (oldEntry = this.eventListeners.putIfAbsent(eventName, entry = new EventEntry<T>())) != null) {
            entry = oldEntry;
        }
        entry.addListener(listener);
        this.jsonSupport.addEventMapping(this.name, eventName, eventClass);
    }

    public void onEvent(NamespaceClient client, String eventName, List<Object> args, AckRequest ackRequest) {
        block4: {
            EventEntry entry = (EventEntry)this.eventListeners.get(eventName);
            if (entry == null) {
                return;
            }
            try {
                Queue listeners = entry.getListeners();
                for (DataListener dataListener : listeners) {
                    Object data = this.getEventData(args, dataListener);
                    dataListener.onData(client, data, ackRequest);
                }
            }
            catch (Exception e) {
                this.exceptionListener.onEventException(e, args, client);
                if (this.ackMode != AckMode.AUTO_SUCCESS_ONLY) break block4;
                return;
            }
        }
        this.sendAck(ackRequest);
    }

    private void sendAck(AckRequest ackRequest) {
        if (this.ackMode == AckMode.AUTO || this.ackMode == AckMode.AUTO_SUCCESS_ONLY) {
            ackRequest.sendAckData(Collections.<Object>emptyList());
        }
    }

    private Object getEventData(List<Object> args, DataListener<?> dataListener) {
        if (dataListener instanceof MultiTypeEventListener) {
            return new MultiTypeArgs(args);
        }
        if (!args.isEmpty()) {
            return args.get(0);
        }
        return null;
    }

    @Override
    public void addDisconnectListener(DisconnectListener listener) {
        this.disconnectListeners.add(listener);
    }

    public void onDisconnect(SocketIOClient client) {
        Set<String> joinedRooms = client.getAllRooms();
        this.allClients.remove(client.getSessionId());
        this.leave(this.getName(), client.getSessionId());
        this.storeFactory.pubSubStore().publish(PubSubType.LEAVE, new JoinLeaveMessage(client.getSessionId(), this.getName(), this.getName()));
        for (String joinedRoom : joinedRooms) {
            this.leave(this.roomClients, joinedRoom, client.getSessionId());
        }
        this.clientRooms.remove(client.getSessionId());
        try {
            for (DisconnectListener listener : this.disconnectListeners) {
                listener.onDisconnect(client);
            }
        }
        catch (Exception e) {
            this.exceptionListener.onDisconnectException(e, client);
        }
    }

    @Override
    public void addConnectListener(ConnectListener listener) {
        this.connectListeners.add(listener);
    }

    public void onConnect(SocketIOClient client) {
        this.join(this.getName(), client.getSessionId());
        this.storeFactory.pubSubStore().publish(PubSubType.JOIN, new JoinLeaveMessage(client.getSessionId(), this.getName(), this.getName()));
        try {
            for (ConnectListener listener : this.connectListeners) {
                listener.onConnect(client);
            }
        }
        catch (Exception e) {
            this.exceptionListener.onConnectException(e, client);
        }
    }

    @Override
    public void addPingListener(PingListener listener) {
        this.pingListeners.add(listener);
    }

    public void onPing(SocketIOClient client) {
        try {
            for (PingListener listener : this.pingListeners) {
                listener.onPing(client);
            }
        }
        catch (Exception e) {
            this.exceptionListener.onPingException(e, client);
        }
    }

    @Override
    public BroadcastOperations getBroadcastOperations() {
        return new BroadcastOperations(this.allClients.values(), this.storeFactory);
    }

    @Override
    public BroadcastOperations getRoomOperations(String room) {
        return new BroadcastOperations(this.getRoomClients(room), this.storeFactory);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Namespace other = (Namespace)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public void addListeners(Object listeners) {
        this.addListeners(listeners, listeners.getClass());
    }

    @Override
    public void addListeners(Object listeners, Class<?> listenersClass) {
        this.engine.scan(this, listeners, listenersClass);
    }

    public void joinRoom(String room, UUID sessionId) {
        this.join(room, sessionId);
        this.storeFactory.pubSubStore().publish(PubSubType.JOIN, new JoinLeaveMessage(sessionId, room, this.getName()));
    }

    public void dispatch(String room, Packet packet) {
        Iterable<SocketIOClient> clients = this.getRoomClients(room);
        for (SocketIOClient socketIOClient : clients) {
            socketIOClient.send(packet);
        }
    }

    private <K, V> void join(ConcurrentMap<K, Set<V>> map, K key, V value) {
        Set oldClients;
        Set<V> clients = (Set<V>)map.get(key);
        if (clients == null && (oldClients = map.putIfAbsent(key, clients = Collections.newSetFromMap(PlatformDependent.newConcurrentHashMap()))) != null) {
            clients = oldClients;
        }
        clients.add(value);
        if (clients != map.get(key)) {
            this.join(map, key, value);
        }
    }

    public void join(String room, UUID sessionId) {
        this.join(this.roomClients, room, sessionId);
        this.join(this.clientRooms, sessionId, room);
    }

    public void leaveRoom(String room, UUID sessionId) {
        this.leave(room, sessionId);
        this.storeFactory.pubSubStore().publish(PubSubType.LEAVE, new JoinLeaveMessage(sessionId, room, this.getName()));
    }

    private <K, V> void leave(ConcurrentMap<K, Set<V>> map, K room, V sessionId) {
        Set clients = (Set)map.get(room);
        if (clients == null) {
            return;
        }
        clients.remove(sessionId);
        if (clients.isEmpty()) {
            map.remove(room, Collections.emptySet());
        }
    }

    public void leave(String room, UUID sessionId) {
        this.leave(this.roomClients, room, sessionId);
        this.leave(this.clientRooms, sessionId, room);
    }

    public Set<String> getRooms(SocketIOClient client) {
        Set res = (Set)this.clientRooms.get(client.getSessionId());
        if (res == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(res);
    }

    public Set<String> getRooms() {
        return this.roomClients.keySet();
    }

    public Iterable<SocketIOClient> getRoomClients(String room) {
        Set sessionIds = (Set)this.roomClients.get(room);
        if (sessionIds == null) {
            return Collections.emptyList();
        }
        ArrayList<SocketIOClient> result = new ArrayList<SocketIOClient>();
        for (UUID sessionId : sessionIds) {
            SocketIOClient client = this.allClients.get(sessionId);
            if (client == null) continue;
            result.add(client);
        }
        return result;
    }

    @Override
    public Collection<SocketIOClient> getAllClients() {
        return Collections.unmodifiableCollection(this.allClients.values());
    }

    public JsonSupport getJsonSupport() {
        return this.jsonSupport;
    }

    @Override
    public SocketIOClient getClient(UUID uuid) {
        return this.allClients.get(uuid);
    }
}

