/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.message.aliyun.core;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.common.exception.ExceptionUtils;
import com.bruce.tool.common.exception.I18N;
import com.bruce.tool.common.util.LogUtils;
import com.bruce.tool.common.util.string.JsonUtils;
import com.bruce.tool.common.util.string.StringUtils;
import com.bruce.tool.common.util.valid.ValidUtils;
import com.bruce.tool.message.aliyun.constant.MessageErrorCode;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message {
    private static final Logger log = LoggerFactory.getLogger(Message.class);
    @NotNull(message="\u7b7e\u540dKey\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u7b7e\u540dKey\u4e0d\u80fd\u4e3a\u7a7a") String appKey;
    @NotNull(message="\u7b7e\u540d\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u7b7e\u540d\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a") String appSecret;
    @NotNull(message="\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a") String phone;
    @NotNull(message="\u77ed\u4fe1\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u77ed\u4fe1\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a") String template;
    @NotNull(message="\u77ed\u4fe1\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u77ed\u4fe1\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a") String signature;
    private String region = "cn-hangzhou";
    private String endpoint = "cn-hangzhou";
    private String extend;
    private Map<String, Object> params = Maps.newHashMap();

    public Message auth(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        return this;
    }

    public Message template(String template) {
        this.template = template;
        return this;
    }

    public Message signature(String signature) {
        this.signature = signature;
        return this;
    }

    public Message phone(String phone) {
        this.phone = phone;
        return this;
    }

    public Message param(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public Message params(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public Message region(String region) {
        this.region = region;
        return this;
    }

    public Message endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Message extend(String extend) {
        this.extend = extend;
        return this;
    }

    public void send() {
        try {
            ValidUtils.valid((Object)this);
            DefaultProfile.addEndpoint((String)this.endpoint, (String)this.region, (String)"Dysmsapi", (String)"dysmsapi.aliyuncs.com");
            DefaultProfile profile = DefaultProfile.getProfile((String)this.region, (String)this.appKey, (String)this.appSecret);
            DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
            SendSmsRequest request = this.buildRequest();
            SendSmsResponse sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
            LogUtils.info((Logger)log, (String)"\u4e91\u901a\u4fe1\u8fd4\u56de\u4fe1\u606f:{}", (Object)JsonUtils.objToStr((Object)sendSmsResponse));
            if (!MessageErrorCode.SUCCESS.getCode().equalsIgnoreCase(sendSmsResponse.getCode())) {
                throw new BaseRuntimeException((Object)sendSmsResponse.getCode(), MessageErrorCode.getMessageByCode(sendSmsResponse.getCode(), I18N.ZH_CN));
            }
        }
        catch (Exception e) {
            ExceptionUtils.printErrorInfo((Throwable)e);
            throw new BaseRuntimeException((Throwable)e);
        }
    }

    private SendSmsRequest buildRequest() {
        SendSmsRequest request = new SendSmsRequest();
        request.setPhoneNumbers(this.phone);
        request.setSignName(this.signature);
        request.setTemplateCode(this.template);
        request.setTemplateParam(JsonUtils.objToStr(this.params));
        if (StringUtils.isNotBlank((CharSequence)this.extend)) {
            request.setOutId(this.extend);
        }
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        return request;
    }

    private Message() {
    }

    public static Message create() {
        return new Message();
    }
}

