/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.message.aliyun.constant;

import com.bruce.tool.common.exception.ErrorCode;
import com.bruce.tool.common.exception.I18N;

public enum MessageErrorCode {
    SUCCESS("OK", "\u8bf7\u6c42\u6210\u529f", ""),
    CLIENT_ERROR("SMS0001", "\u5ba2\u6237\u7aef\u5f02\u5e38", "Cient Exception"),
    RESULT_ERROR("SMS0002", "\u672a\u77e5\u9519\u8bef,\u77ed\u4fe1\u53d1\u9001\u5931\u8d25", "send failed"),
    ERROR1("isp.RAM_PERMISSION_DENY", "RAM\u6743\u9650DENY", ""),
    ERROR2("isv.OUT_OF_SERVICE", "\u4e1a\u52a1\u505c\u673a", ""),
    ERROR3("isv.PRODUCT_UN_SUBSCRIPT", "\u672a\u5f00\u901a\u4e91\u901a\u4fe1\u4ea7\u54c1\u7684\u963f\u91cc\u4e91\u5ba2\u6237", ""),
    ERROR4("isv.PRODUCT_UNSUBSCRIBE", "\u4ea7\u54c1\u672a\u5f00\u901a", ""),
    ERROR5("isv.ACCOUNT_NOT_EXISTS", "\u8d26\u6237\u4e0d\u5b58\u5728", ""),
    ERROR6("isv.ACCOUNT_ABNORMAL", "\u8d26\u6237\u5f02\u5e38", ""),
    ERROR7("isv.SMS_TEMPLATE_ILLEGAL", "\u77ed\u4fe1\u6a21\u677f\u4e0d\u5408\u6cd5", ""),
    ERROR8("isv.SMS_SIGNATURE_ILLEGAL", "\u77ed\u4fe1\u7b7e\u540d\u4e0d\u5408\u6cd5", ""),
    ERROR9("isv.INVALID_PARAMETERS", "\u53c2\u6570\u5f02\u5e38", ""),
    ERROR10("isp.SYSTEM_ERROR", "\u7cfb\u7edf\u9519\u8bef", ""),
    ERROR11("isv.MOBILE_NUMBER_ILLEGAL", "\u975e\u6cd5\u624b\u673a\u53f7", ""),
    ERROR12("isv.MOBILE_COUNT_OVER_LIMIT", "\u624b\u673a\u53f7\u7801\u6570\u91cf\u8d85\u8fc7\u9650\u5236", ""),
    ERROR13("isv.TEMPLATE_MISSING_PARAMETERS", "\u6a21\u677f\u7f3a\u5c11\u53d8\u91cf", ""),
    ERROR14("isv.BUSINESS_LIMIT_CONTROL", "\u4e1a\u52a1\u9650\u6d41", ""),
    ERROR15("isv.INVALID_JSON_PARAM", "JSON\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u53ea\u63a5\u53d7\u5b57\u7b26\u4e32\u503c", ""),
    ERROR16("isv.BLACK_KEY_CONTROL_LIMIT", "\u9ed1\u540d\u5355\u7ba1\u63a7", ""),
    ERROR17("isv.PARAM_LENGTH_LIMIT", "\u53c2\u6570\u8d85\u51fa\u957f\u5ea6\u9650\u5236", ""),
    ERROR18("isv.PARAM_NOT_SUPPORT_URL", "\u4e0d\u652f\u6301URL", ""),
    ERROR19("isv.AMOUNT_NOT_ENOUGH", "\u8d26\u6237\u4f59\u989d\u4e0d\u8db3", "");

    private String code;
    private String message;
    private String messageENUS;

    public static String getMessageByCode(String code, I18N i18N) {
        MessageErrorCode target = MessageErrorCode.search(code);
        if (null == target) {
            return "";
        }
        return ErrorCode.getMessageByLanguage((I18N)i18N, (String[])new String[]{target.getMessage(), target.getMessageENUS()});
    }

    public static MessageErrorCode search(String code) {
        MessageErrorCode target = null;
        for (MessageErrorCode messageErrorCode : MessageErrorCode.values()) {
            if (!messageErrorCode.getCode().equals(code)) continue;
            target = messageErrorCode;
        }
        return target;
    }

    private MessageErrorCode(String code, String message, String messageENUS) {
        this.code = code;
        this.message = message;
        this.messageENUS = messageENUS;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageENUS() {
        return this.messageENUS;
    }
}

