/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.tool.search.solr.update;

import com.bruce.tool.common.exception.BaseRuntimeException;
import com.bruce.tool.common.util.LogUtils;
import com.bruce.tool.search.solr.common.SearchUtils;
import com.bruce.tool.search.solr.domain.FilterQuerys;
import com.bruce.tool.search.solr.domain.KeyWords;
import com.bruce.tool.search.solr.update.SolrUpdate;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSolrUpdate
implements SolrUpdate {
    private static final Logger log = LoggerFactory.getLogger(AbstractSolrUpdate.class);

    protected abstract SolrClient getSolrClient();

    @Override
    public UpdateResponse updateDocuments(FilterQuerys querys, SolrUpdate.Callback callback) {
        SolrDocumentList documents = this.getDocuments(querys);
        Collection<SolrInputDocument> inputDocuments = SearchUtils.transfer(documents);
        inputDocuments = callback.fillUpdateInfo(inputDocuments);
        return this.updateDocuments(inputDocuments);
    }

    @Override
    public UpdateResponse updateDocuments(Collection<SolrInputDocument> documents) {
        UpdateResponse updateResponse;
        if (CollectionUtils.isEmpty(documents)) {
            LogUtils.info((Logger)log, (Object)"\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5546\u54c1,\u76f4\u63a5\u8fd4\u56de,\u4e0d\u66f4\u65b0\u6570\u636e");
            return null;
        }
        long start = System.currentTimeMillis();
        try {
            this.getSolrClient().add(documents);
            updateResponse = this.getSolrClient().commit();
        }
        catch (IOException | SolrServerException e) {
            throw new BaseRuntimeException((Object)e.getCause(), e.getMessage());
        }
        LogUtils.info((Logger)log, (String)"\u66f4\u65b0\u6587\u6863\u6570\u91cf:{},\u8017\u65f6:{}ms", (Object[])new Object[]{documents.size(), System.currentTimeMillis() - start});
        return updateResponse;
    }

    private SolrDocumentList getDocuments(FilterQuerys querys) {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery(KeyWords.build().toString());
        SearchUtils.setFilterQuery(solrQuery, querys);
        LogUtils.info((Logger)log, (String)"\u6267\u884c\u641c\u7d22\uff0c\u641c\u7d22\u53c2\u6570\uff1a {}", (Object)solrQuery.toQueryString());
        QueryResponse response = SearchUtils.executeQuery(this.getSolrClient(), solrQuery);
        return response.getResults();
    }
}

